/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.structures;

import com.legacy.structure_gel.access_helpers.StructureAccessHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public abstract class GelStructure<C extends IFeatureConfig>
extends Structure<C> {
    public GelStructure(Codec<C> codec) {
        super(codec);
        MinecraftForge.EVENT_BUS.addListener(this::potentialSpawnsEvent);
        this.setLakeProof(true);
    }

    public GelStructure<C> setLakeProof(boolean lakeProof) {
        if (lakeProof) {
            StructureAccessHelper.addLakeProofStructure(this);
        } else {
            StructureAccessHelper.removeLakeProofStructure(this);
        }
        return this;
    }

    public ChunkPos func_236392_a_(StructureSeparationSettings settings, long seed, SharedSeedRandom sharedSeedRand, int x, int z) {
        int spacing = this.getSpacing();
        int gridX = x / spacing * spacing;
        int gridZ = z / spacing * spacing;
        int offset = this.getOffset() + 1;
        sharedSeedRand.func_202427_a(seed, gridX, gridZ, this.getSeed());
        int offsetX = sharedSeedRand.nextInt(offset);
        int offsetZ = sharedSeedRand.nextInt(offset);
        int gridOffsetX = gridX + offsetX;
        int gridOffsetZ = gridZ + offsetZ;
        return new ChunkPos(gridOffsetX, gridOffsetZ);
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, C config) {
        sharedSeedRand.func_202427_a(seed, chunkPosX, chunkPosZ, this.getSeed());
        return sharedSeedRand.nextDouble() < this.getProbability();
    }

    public BlockPos func_236388_a_(IWorldReader worldIn, StructureManager structureManager, BlockPos startPos, int searchRadius, boolean skipExistingChunks, long seed, StructureSeparationSettings settings) {
        int spacing = this.getSpacing();
        int chunkX = startPos.func_177958_n() >> 4;
        int chunkZ = startPos.func_177952_p() >> 4;
        SharedSeedRandom rand = new SharedSeedRandom();
        block0: for (int i = 0; i <= searchRadius; ++i) {
            for (int xOffset = -i; xOffset <= i; ++xOffset) {
                boolean flag = xOffset == -i || xOffset == i;
                for (int zOffset = -i; zOffset <= i; ++zOffset) {
                    boolean flag1;
                    boolean bl = flag1 = zOffset == -i || zOffset == i;
                    if (!flag && !flag1) continue;
                    int newChunkX = chunkX + spacing * xOffset;
                    int newChunkZ = chunkZ + spacing * zOffset;
                    ChunkPos chunkpos = this.func_236392_a_(settings, seed, rand, newChunkX, newChunkZ);
                    IChunk chunk = worldIn.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222606_b);
                    StructureStart start = structureManager.func_235013_a_(SectionPos.func_218156_a((ChunkPos)chunk.func_76632_l(), (int)0), (Structure)this, (IStructureReader)chunk);
                    if (start != null && start.func_75069_d()) {
                        if (skipExistingChunks && start.func_212687_g()) {
                            start.func_212685_h();
                            return start.func_204294_a();
                        }
                        if (!skipExistingChunks) {
                            return start.func_204294_a();
                        }
                    }
                    if (i == 0) break;
                }
                if (i == 0) continue block0;
            }
        }
        return null;
    }

    public abstract int getSeed();

    public abstract double getProbability();

    public abstract int getSpacing();

    public abstract int getOffset();

    public String func_143025_a() {
        return this.getRegistryName().toString();
    }

    @Nullable
    public List<Biome.SpawnListEntry> func_202279_e() {
        return null;
    }

    @Nullable
    public List<Biome.SpawnListEntry> func_214469_f() {
        return null;
    }

    public void potentialSpawnsEvent(WorldEvent.PotentialSpawns event) {
        if (event.getWorld() instanceof ServerWorld && ((ServerWorld)event.getWorld()).func_241112_a_().func_235010_a_(event.getPos(), false, (Structure)this).func_75069_d()) {
            if (event.getType() == EntityClassification.MONSTER && this.func_202279_e() != null) {
                event.getList().clear();
                event.getList().addAll(this.func_202279_e());
            }
            if (event.getType() == EntityClassification.CREATURE && this.func_214469_f() != null) {
                event.getList().clear();
                event.getList().addAll(this.func_214469_f());
            }
        }
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }
}

