/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.client.FarlandersClientEvents;
import com.legacy.farlanders.client.render.FarlanderEntityRendering;
import com.legacy.farlanders.event.FarlandersEvents;
import com.legacy.farlanders.registry.FarlandersBlocks;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.legacy.farlanders.registry.FarlandersStructures;
import com.legacy.farlanders.util.FarlandersRankings;
import com.legacy.farlanders.world.structure.FarlanderLootFeature;
import com.legacy.farlanders.world.structure.TitanSpireFeature;
import com.legacy.structure_gel.util.RegistryHelper;
import com.mojang.serialization.Codec;
import java.util.logging.Logger;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="farlanders")
public class TheFarlandersMod {
    public static final String NAME = "The Farlanders";
    public static final String MODID = "farlanders";
    public static Logger LOGGER = Logger.getLogger("farlanders");

    public TheFarlandersMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FarlandersConfig.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)new FarlandersEvents());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TheFarlandersMod::commonInit);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(TheFarlandersMod::clientInit));
    }

    public static void clientInit(FMLClientSetupEvent event) {
        FarlanderEntityRendering.init();
        MinecraftForge.EVENT_BUS.register((Object)new FarlandersClientEvents());
    }

    public static void commonInit(FMLCommonSetupEvent event) {
        FarlandersRankings.init();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (!(!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.VOID) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN))) {
                if (!(!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST))) {
                    RegistryHelper.addStructure((Biome)biome, (Structure)((Structure)FarlandersStructures.FARLANDER_VILLAGE.getFirst()));
                }
                RegistryHelper.addStructure((Biome)biome, (Structure)((Structure)FarlandersStructures.SMALL_HOUSE.getFirst()));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new FarlanderLootFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, Blocks.field_196658_i.func_176223_P()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new TitanSpireFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
                biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(FarlandersEntityTypes.ENDERMINION, 2, 1, 1));
                biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(FarlandersEntityTypes.MYSTIC_ENDERMINION, 1, 1, 1));
                biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(FarlandersEntityTypes.WANDERER, 3, 1, 1));
                biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(FarlandersEntityTypes.LOOTER, 20, 1, 2));
                biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(FarlandersEntityTypes.REBEL, 20, 1, 4));
                biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(FarlandersEntityTypes.CLASSIC_ENDERMAN, 7, 1, 4));
                biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(FarlandersEntityTypes.FANMADE_ENDERMAN, 5, 1, 2));
                biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(FarlandersEntityTypes.MYSTIC_ENDERMAN, 3, 1, 2));
            }
            if (biome != Biomes.field_76770_e && biome != Biomes.field_76775_o && biome != Biomes.field_76783_v) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), FarlandersBlocks.endumium_ore.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }

    public static ResourceLocation locate(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static String find(String name) {
        return "farlanders:" + name;
    }
}

