/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.ai.tasks.FarlanderTasks;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.EnderGuardianEntity;
import com.legacy.farlanders.entity.hostile.LooterEntity;
import com.legacy.farlanders.entity.hostile.RebelEntity;
import com.legacy.farlanders.entity.hostile.boss.EnderColossusEntity;
import com.legacy.farlanders.entity.util.FarlanderTrades;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.registry.FarlandersBlocks;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.legacy.farlanders.registry.FarlandersItems;
import com.legacy.farlanders.registry.FarlandersSchedules;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FarlanderEntity
extends AbstractVillagerEntity
implements IColoredEyes {
    public static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(FarlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(FarlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int particleEffect;
    private int xp;
    private int timeUntilReset;
    private int resetsSinceRestocked;
    private long lastRestockTime;
    private long timeOfDay;
    private boolean customer;
    private BlockPos homePos;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220948_i, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220952_m, (Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_220955_p, (Object[])new MemoryModuleType[]{MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y});
    private static final ImmutableList<SensorType<? extends Sensor<? super FarlanderEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_221000_d, (Object)SensorType.field_221001_e, (Object)SensorType.field_221002_f, (Object)SensorType.field_221003_g);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<FarlanderEntity, PointOfInterestType>> VALID_POI = ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (entity, type) -> type == PointOfInterestType.field_221069_q, (Object)MemoryModuleType.field_220943_d, (entity, type) -> type == PointOfInterestType.field_221070_r);

    public FarlanderEntity(EntityType<? extends FarlanderEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, LooterEntity.class, 8.0f, 0.7, 0.8));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, RebelEntity.class, 8.0f, 0.7, 0.8));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, EnderColossusEntity.class, 8.0f, 0.5, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 0.6, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{FarlandersBlocks.endumium_block.func_199767_j()}), false));
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p instanceof ServerWorld) {
            this.resetBrain((ServerWorld)this.field_70170_p);
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.75f : 1.6f;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(6));
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74768_a("Xp", this.xp);
        compound.func_74768_a("Level", this.getLevel());
        if (this.homePos != null) {
            compound.func_218657_a("HomePosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.homePos));
        }
        compound.func_74772_a("LastRestock", this.lastRestockTime);
        compound.func_74768_a("RestocksToday", this.resetsSinceRestocked);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setLevel(compound.func_74762_e("Level"));
        if (compound.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("Xp", 3)) {
            this.xp = compound.func_74762_e("Xp");
        }
        if (compound.func_74764_b("HomePosition")) {
            this.homePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HomePosition"));
        }
        this.lastRestockTime = compound.func_74763_f("LastRestock");
        this.func_98053_h(false);
        this.resetBrain((ServerWorld)this.field_70170_p);
        this.resetsSinceRestocked = compound.func_74762_e("RestocksToday");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_72820_D() % 6000L == 0L && !this.field_70170_p.func_72935_r() && this.canRestock()) {
            this.restockTrades();
        }
        if (this.func_203005_aq()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.getClass() == FarlanderEntity.class) {
            if (this.getEyeColor() == 0) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            } else if (this.getEyeColor() == 1) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
            } else if (this.getEyeColor() == 2) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            } else if (this.getEyeColor() == 3) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            } else if (this.getEyeColor() == 4) {
                ++this.particleEffect;
                if (this.particleEffect == 3) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                    this.particleEffect = 0;
                }
            } else if (this.getEyeColor() == 5) {
                ++this.particleEffect;
                if (this.particleEffect == 1) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.5 + this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    this.particleEffect = 0;
                }
            }
        }
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("brain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.func_213716_dX() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.customer) {
                    this.levelUp();
                    this.customer = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197633_z);
        } else if (id == 13) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197609_b);
        } else if (id == 14) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197632_y);
        } else if (id == 42) {
            this.func_213718_a((IParticleData)ParticleTypes.field_218422_X);
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_FARLANDER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FarlandersSounds.ENTITY_FARLANDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_FARLANDER_DEATH;
    }

    public SoundEvent func_213714_ea() {
        this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 1.3f);
        return null;
    }

    protected SoundEvent func_213721_r(boolean positive) {
        if (positive) {
            this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 1.3f);
        } else {
            this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 0.7f);
        }
        return null;
    }

    public FarlanderEntity createChild(AgeableEntity ageable) {
        return (FarlanderEntity)FarlandersEntityTypes.FARLANDER.func_200721_a(this.field_70170_p);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() != FarlandersItems.farlander_spawn_egg && this.func_70089_S() && !this.func_70608_bn() && !this.func_70631_g_() && !player.func_226563_dT_()) {
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return super.func_230254_b_(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), this.getLevel());
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    private void levelUp() {
        this.setLevel(this.getLevel() + 1);
        this.func_213712_ef();
    }

    private void beginRestock() {
        this.restockAndCalculateDemand();
        this.resetsSinceRestocked = 0;
    }

    public boolean canRestock() {
        long i = this.lastRestockTime + 12000L;
        boolean flag = this.field_70170_p.func_82737_E() > i;
        long j = this.field_70170_p.func_72820_D();
        if (this.timeOfDay > 0L) {
            long l = j / 24000L;
            long k = this.timeOfDay / 24000L;
            flag |= l > k;
        }
        this.timeOfDay = j;
        if (flag) {
            this.beginRestock();
        }
        return this.isRestockTime() && this.hasUsedOffer();
    }

    private boolean hasUsedOffer() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            if (!merchantoffer.func_222217_o()) continue;
            return true;
        }
        return false;
    }

    private boolean isRestockTime() {
        return this.resetsSinceRestocked < 2 && this.field_70170_p.func_82737_E() > this.lastRestockTime + 2400L;
    }

    public void restockTrades() {
        this.calculateDemandOfOffers();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        ++this.resetsSinceRestocked;
    }

    private void restockAndCalculateDemand() {
        int i = 2 - this.resetsSinceRestocked;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222203_h();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.calculateDemandOfOffers();
        }
    }

    private void calculateDemandOfOffers() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222222_e();
        }
    }

    protected void func_213713_b(MerchantOffer offer) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.xp += offer.func_222210_n();
        if (this.func_213741_eu()) {
            this.timeUntilReset = 40;
            this.customer = true;
            i += 5;
        }
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade = (VillagerTrades.ITrade[])FarlanderTrades.farlanderTrades.get(this.getLevel());
        if (avillagertrades$itrade != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    private boolean func_213741_eu() {
        int i = this.getLevel();
        return VillagerData.func_221128_d((int)i) && this.xp >= VillagerData.func_221127_c((int)i);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public int func_213708_dV() {
        return this.xp;
    }

    public void setXp(int amount) {
        this.xp = amount;
    }

    public void setHomePos(@Nullable BlockPos pos) {
        this.homePos = pos;
    }

    @Nullable
    public BlockPos getHomePos() {
        return this.homePos;
    }

    public void func_70645_a(DamageSource cause) {
        this.removeModule((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220941_b);
        this.removeModule((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220943_d);
        super.func_70645_a(cause);
    }

    public void removeModule(MemoryModuleType<GlobalPos> p_213742_1_) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer minecraftserver = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(p_213742_1_).ifPresent(p_213752_3_ -> {
                ServerWorld serverworld = minecraftserver.func_71218_a(p_213752_3_.func_239646_a_());
                PointOfInterestManager pointofinterestmanager = serverworld.func_217443_B();
                Optional optional = pointofinterestmanager.func_219148_c(p_213752_3_.func_218180_b());
                BiPredicate<FarlanderEntity, PointOfInterestType> bipredicate = VALID_POI.get(p_213742_1_);
                if (optional.isPresent() && bipredicate.test(this, (PointOfInterestType)optional.get())) {
                    pointofinterestmanager.func_219140_a(p_213752_3_.func_218180_b());
                    DebugPacketSender.func_218801_c((ServerWorld)serverworld, (BlockPos)p_213752_3_.func_218180_b());
                }
            });
        }
    }

    public float getPosDistance(double x, double y, double z) {
        float f = (float)(this.func_226277_ct_() - x);
        float f1 = (float)(this.func_226278_cu_() - y);
        float f2 = (float)(this.func_226281_cx_() - z);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof EnderGolemEntity || entityIn instanceof EnderGuardianEntity || entityIn instanceof FarlanderEntity) {
            return true;
        }
        return this.func_184194_a(entityIn.func_96124_cp());
    }

    public boolean func_213743_em() {
        return this.func_70874_b() == 0;
    }

    public Brain<FarlanderEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected Brain.BrainCodec<FarlanderEntity> func_230289_cH_() {
        return Brain.func_233705_a_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = this.func_230289_cH_().func_233748_a_(dynamicIn);
        this.initBrain((Brain<FarlanderEntity>)brain);
        return brain;
    }

    public void resetBrain(ServerWorld p_213770_1_) {
        Brain<FarlanderEntity> brain = this.func_213375_cj();
        brain.func_218227_b(p_213770_1_, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        this.initBrain(this.func_213375_cj());
    }

    private void initBrain(Brain<FarlanderEntity> villagerBrain) {
        float f = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        if (this.func_70631_g_()) {
            villagerBrain.func_218203_a(FarlandersSchedules.FARLANDER_BABY);
            villagerBrain.func_218208_a(Activity.field_221368_d, FarlanderTasks.play(f + 0.1f));
        } else {
            villagerBrain.func_218203_a(FarlandersSchedules.FARLANDER_DEFAULT);
        }
        villagerBrain.func_218208_a(Activity.field_221365_a, FarlanderTasks.core(f + 0.1f));
        villagerBrain.func_233700_a_(Activity.field_221370_f, FarlanderTasks.meet(f + 0.1f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        villagerBrain.func_218208_a(Activity.field_221369_e, FarlanderTasks.rest(f + 0.1f));
        villagerBrain.func_218208_a(Activity.field_221366_b, FarlanderTasks.idle(f + 0.1f));
        villagerBrain.func_218208_a(Activity.field_221371_g, FarlanderTasks.panic(f));
        villagerBrain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        villagerBrain.func_218200_b(Activity.field_221366_b);
        villagerBrain.func_218202_a(Activity.field_221366_b);
        villagerBrain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    public void func_213342_e(BlockPos pos) {
        super.func_213342_e(pos);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, (Object)this.field_70170_p.func_82737_E());
        this.field_213378_br.func_218189_b(MemoryModuleType.field_220950_k);
        this.field_213378_br.func_218189_b(MemoryModuleType.field_223021_x);
    }
}

