/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile;

import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.WandererEntity;
import com.legacy.farlanders.entity.ai.GolemStayNearFarlanderGoal;
import com.legacy.farlanders.entity.hostile.EnderGuardianEntity;
import com.legacy.farlanders.entity.hostile.TitanEntity;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.entity.util.ITeleportingEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PatrolVillageGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderGolemEntity
extends MonsterEntity
implements IColoredEyes,
ITeleportingEntity {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(EnderGolemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EnderGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;

    public EnderGolemEntity(EntityType<? extends EnderGolemEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GolemStayNearFarlanderGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 0.6, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new PatrolVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.65, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, entity -> entity instanceof IMob && !(entity instanceof CreeperEntity) && !(entity instanceof TitanEntity) && !(entity instanceof EnderGolemEntity) && !(entity instanceof EnderGuardianEntity) || entity instanceof WandererEntity));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(6));
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74757_a("IsAngry", this.getAngry());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setAngry(compound.func_74767_n("IsAngry"));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 3.55f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233818_a_, 100.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAngry(true);
        } else {
            this.setAngry(false);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_203005_aq()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        BlockState blockstate;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (EnderGolemEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)this.field_70170_p, this.func_233580_cy_())) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_174813_aQ().field_72338_b + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source instanceof IndirectEntityDamageSource)) {
            boolean flag = super.func_70097_a(source, amount);
            if (!this.field_70170_p.func_201670_d() && source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
                this.teleportRandomly((LivingEntity)this);
            }
            return flag;
        }
        for (int i = 0; i < 64; ++i) {
            if (!this.teleportRandomly((LivingEntity)this)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_ENDER_GOLEM_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(FarlandersSounds.ENTITY_ENDER_GOLEM_HURT, 1.0f, 0.8f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_ENDER_GOLEM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected float func_70647_i() {
        return 1.2f;
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    public void setAngry(boolean ang) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)ang);
    }

    public boolean getAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }
}

