/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile;

import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.WandererEntity;
import com.legacy.farlanders.entity.ai.GolemStayNearFarlanderGoal;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.TitanEntity;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.entity.util.ITeleportingEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PatrolVillageGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EnderGuardianEntity
extends MonsterEntity
implements IColoredEyes,
IRangedAttackMob,
ITeleportingEntity {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(EnderGuardianEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> GUARDIAN_ATTACKING = EntityDataManager.func_187226_a(EnderGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int particleEffect;

    public EnderGuardianEntity(EntityType<? extends EnderGuardianEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new GolemStayNearFarlanderGoal(this, 0.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedBowAttackGoal((MonsterEntity)this, 0.61, 20, 15.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 0.6, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new PatrolVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, entity -> entity instanceof IMob && !(entity instanceof CreeperEntity) && !(entity instanceof TitanEntity) && !(entity instanceof EnderGolemEntity) && !(entity instanceof EnderGuardianEntity) || entity instanceof WandererEntity));
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(6));
        this.field_70180_af.func_187214_a(GUARDIAN_ATTACKING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74757_a("GuardianAttacking", this.getAttacking());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setAttacking(compound.func_74767_n("GuardianAttacking"));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.6f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233818_a_, 30.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_203005_aq()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.getEyeColor() == 0) {
            for (int k = 0; k < 2; ++k) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        } else if (this.getEyeColor() == 1) {
            for (int k = 0; k < 2; ++k) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            }
        } else if (this.getEyeColor() == 2) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
        } else if (this.getEyeColor() == 3) {
            for (int k = 0; k < 2; ++k) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        } else if (this.getEyeColor() == 4) {
            ++this.particleEffect;
            if (this.particleEffect == 3) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                this.particleEffect = 0;
            }
        } else if (this.getEyeColor() == 5) {
            ++this.particleEffect;
            if (this.particleEffect == 1) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.5 + this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                this.particleEffect = 0;
            }
        }
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAttacking(true);
        } else {
            this.setAttacking(false);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source instanceof IndirectEntityDamageSource)) {
            boolean flag = super.func_70097_a(source, amount);
            if (!this.field_70170_p.func_201670_d() && source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
                this.teleportRandomly((LivingEntity)this);
            }
            return flag;
        }
        for (int i = 0; i < 64; ++i) {
            if (!this.teleportRandomly((LivingEntity)this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    public void setAttacking(boolean att) {
        this.field_70180_af.func_187227_b(GUARDIAN_ATTACKING, (Object)att);
    }

    public boolean getAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(GUARDIAN_ATTACKING);
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_ENDER_GUARDIAN_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(FarlandersSounds.ENTITY_ENDER_GUARDIAN_HURT, 1.0f, 1.2f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_ENDER_GUARDIAN_DEATH;
    }

    protected float func_70647_i() {
        return 1.7f;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }
}

