/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.google.common.collect.ImmutableList;
import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.entity.ElderFarlanderEntity;
import com.legacy.farlanders.entity.FarlanderEntity;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.EnderGuardianEntity;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.legacy.farlanders.registry.FarlandersStructures;
import com.legacy.structure_gel.structures.GelStructurePiece;
import com.legacy.structure_gel.structures.jigsaw.JigsawRegistryHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FarlanderVillagePieces {
    public static void assemble(ChunkGenerator chunkGen, TemplateManager template, BlockPos pos, List<StructurePiece> pieces, SharedSeedRandom seed) {
        JigsawManager.func_236823_a_((ResourceLocation)TheFarlandersMod.locate("village/normal/centers"), (int)7, Piece::new, (ChunkGenerator)chunkGen, (TemplateManager)template, (BlockPos)pos, pieces, (Random)seed, (boolean)true, (boolean)true);
    }

    public static void init() {
    }

    static {
        RuleStructureProcessor fixLeaves = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196642_W), (RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196642_W), (RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), Blocks.field_150346_d.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196642_W), (RuleTest)new BlockMatchRuleTest(Blocks.field_150348_b), Blocks.field_150348_b.func_176223_P())));
        ImmutableList villagePathChanges = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_185774_da), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196662_n.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_185774_da, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()))));
        JigsawRegistryHelper registry = new JigsawRegistryHelper("farlanders", "village/normal/");
        registry.register("centers", registry.builder().names(new String[]{"centers/watch_tower", "centers/wooden_tower", "centers/gazebo"}).maintainWater(false).processors((List)villagePathChanges).build());
        registry.register("streets", registry.builder().names(new String[]{"streets/path_1", "streets/path_2", "streets/path_3", "streets/path_4"}).maintainWater(false).processors((List)villagePathChanges).build(), JigsawPattern.PlacementBehaviour.TERRAIN_MATCHING);
        registry.register("house", registry.builder().names(new String[]{"house_1", "house_2", "house_3", "house_4"}).maintainWater(false).build());
        registry.register("house_special", registry.builder().names(new String[]{"house_special_1", "house_special_2"}).maintainWater(false).processors(new StructureProcessor[]{fixLeaves}).build());
    }

    public static class Piece
    extends GelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super((IStructurePieceType)FarlandersStructures.FARLANDER_VILLAGE.getSecond(), template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt, (IStructurePieceType)FarlandersStructures.FARLANDER_VILLAGE.getSecond());
        }

        public void handleDataMarker(String key, IWorld worldIn, BlockPos pos, Random rand, MutableBoundingBox bounds) {
            IColoredEyes entity;
            if (key.equals("farlander")) {
                this.setAir(worldIn, pos);
                entity = (FarlanderEntity)this.createEntity(FarlandersEntityTypes.FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("elder")) {
                this.setAir(worldIn, pos);
                entity = (ElderFarlanderEntity)this.createEntity(FarlandersEntityTypes.ELDER_FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("golem")) {
                this.setAir(worldIn, pos);
                entity = (EnderGolemEntity)this.createEntity(FarlandersEntityTypes.ENDER_GOLEM, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.contains("guardian")) {
                if (key.contains("up")) {
                    worldIn.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 3);
                    entity = (EnderGuardianEntity)this.createEntity(FarlandersEntityTypes.ENDER_GUARDIAN, worldIn, pos.func_177984_a(), this.field_214834_c);
                    ((EnderGuardianEntity)entity).func_213386_a(worldIn, worldIn.func_175649_E(pos.func_177984_a()), SpawnReason.STRUCTURE, null, null);
                    entity.func_110163_bv();
                    worldIn.func_217376_c((Entity)entity);
                } else {
                    this.setAir(worldIn, pos);
                    entity = (EnderGuardianEntity)this.createEntity(FarlandersEntityTypes.ENDER_GUARDIAN, worldIn, pos, this.field_214834_c);
                    ((EnderGuardianEntity)entity).func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    entity.func_110163_bv();
                    worldIn.func_217376_c((Entity)entity);
                }
            }
            if (key.equals("elder-loot")) {
                this.setAir(worldIn, pos);
                ChestTileEntity tile = (ChestTileEntity)worldIn.func_175625_s(pos.func_177977_b());
                tile.func_189404_a(TheFarlandersMod.locate("chests/elder_house_chest"), worldIn.func_201674_k().nextLong());
            }
        }
    }
}

