/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.TitanEntity;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class TitanSpireFeature
extends Feature<NoFeatureConfig> {
    private BlockState replaceID = Blocks.field_196658_i.func_176223_P();

    public TitanSpireFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean locationIsValidSpawn(IWorld par1World, int i, int j, int k) {
        int distanceToAir;
        BlockState checkID = par1World.func_180495_p(new BlockPos(i, j, k));
        for (distanceToAir = 0; distanceToAir < 255 && checkID != Blocks.field_150350_a.func_176223_P(); ++distanceToAir) {
            checkID = par1World.func_180495_p(new BlockPos(i, j + distanceToAir, k));
            if (distanceToAir > 100) {
                return false;
            }
            if (distanceToAir >= 0) continue;
            return false;
        }
        if (distanceToAir > 2) {
            return false;
        }
        BlockState blockID = par1World.func_180495_p(new BlockPos(i, j += distanceToAir - 1, k));
        BlockState blockIDAbove = par1World.func_180495_p(new BlockPos(i, j + 1, k));
        BlockState blockIDBelow = par1World.func_180495_p(new BlockPos(i, j - 1, k));
        if (blockIDAbove != Blocks.field_150350_a.func_176223_P()) {
            return false;
        }
        if (blockID.func_177230_c() == Blocks.field_150433_aE && blockIDBelow == this.replaceID || blockID.func_177230_c() == Blocks.field_150349_c && blockIDBelow == this.replaceID || blockID == Blocks.field_196606_bd.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196605_bc.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196555_aI.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150434_aF.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150338_P.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150337_Q.func_176223_P() && blockIDBelow == this.replaceID) {
            return true;
        }
        return blockID == this.replaceID;
    }

    public boolean func_230362_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        int par3 = pos.func_177958_n();
        int par4 = pos.func_177956_o();
        int par5 = pos.func_177952_p();
        if ((Integer)FarlandersConfig.COMMON.obsidianSpireSpawnRate.get() > 1 && random.nextInt((Integer)FarlandersConfig.COMMON.obsidianSpireSpawnRate.get()) != 0 || (Integer)FarlandersConfig.COMMON.obsidianSpireSpawnRate.get() <= 1) {
            return false;
        }
        if (this.locationIsValidSpawn((IWorld)world, par3, par4, par5)) {
            int var11;
            int var8;
            int var6 = random.nextInt(32) + 8;
            int var7 = random.nextInt(4) + 3;
            int var9 = 0;
            int var10 = 0;
            for (var8 = par3 - var7; var8 <= par3 + var7; ++var8) {
                for (var9 = par5 - var7; var9 <= par5 + var7; ++var9) {
                    var10 = var8 - par3;
                    var11 = var9 - par5;
                    if (var10 * var10 + var11 * var11 > var7 * var7 + 1 || world.func_180495_p(new BlockPos(var8, par4 - 1, var9)) == this.replaceID) continue;
                    return false;
                }
            }
            for (var8 = par4; var8 < par4 + var6 && var8 < 128; ++var8) {
                for (var9 = par3 - var7; var9 <= par3 + var7; ++var9) {
                    for (var10 = par5 - var7; var10 <= par5 + var7; ++var10) {
                        var11 = var9 - par3;
                        int var12 = var10 - par5;
                        if (var11 * var11 + var12 * var12 > var7 * var7 + 1) continue;
                        world.func_180501_a(new BlockPos(var9, var8, var10), Blocks.field_150343_Z.func_176223_P(), 2);
                    }
                }
            }
            if (world.func_201674_k().nextBoolean()) {
                world.func_180501_a(new BlockPos(var9 - 6, var8 - 3, var10 - 4), Blocks.field_150486_ae.func_176223_P(), 2);
                ChestTileEntity tile = (ChestTileEntity)world.func_175625_s(new BlockPos(var9 - 6, var8 - 3, var10 - 4));
                tile.func_189404_a(TheFarlandersMod.locate("chests/spire_chest"), world.func_201674_k().nextLong());
            } else {
                world.func_180501_a(new BlockPos(var9 - 6, var8 - 6, var10 - 4), Blocks.field_150486_ae.func_176223_P(), 2);
                ChestTileEntity tile2 = (ChestTileEntity)world.func_175625_s(new BlockPos(var9 - 6, var8 - 6, var10 - 4));
                tile2.func_189404_a(TheFarlandersMod.locate("chests/spire_chest"), world.func_201674_k().nextLong());
            }
            if (world.func_201674_k().nextInt(4) == 3) {
                TitanEntity var4 = new TitanEntity(FarlandersEntityTypes.TITAN, world.func_201672_e());
                var4.func_70107_b(var9 - 6, var8 + 2, var10 - 4);
                var4.func_110163_bv();
                world.func_217376_c((Entity)var4);
            } else {
                EnderGolemEntity var5 = new EnderGolemEntity(FarlandersEntityTypes.ENDER_GOLEM, world.func_201672_e());
                var5.func_70107_b(var9 - 6, var8 + 2, var10 - 4);
                var5.func_110163_bv();
                world.func_217376_c((Entity)var5);
            }
            return true;
        }
        return false;
    }
}

