/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.biome_dictionary;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.util.Internal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class BiomeDictionary {
    @Internal
    private static final String BOP = "biomesoplenty";
    public static final IForgeRegistry<BiomeType> REGISTRY = RegistryManager.ACTIVE.getRegistry(BiomeType.class);
    @Internal
    private static final Map<RegistryKey<Biome>, Set<BiomeType>> BIOME_TO_BIOMETYPE_CACHE = new HashMap<RegistryKey<Biome>, Set<BiomeType>>();
    @Internal
    protected static final ResourceLocation EMPTY_NAME = StructureGelMod.locate("empty");
    @Internal
    public static final BiomeType EMPTY = new BiomeType(EMPTY_NAME, new HashSet<ResourceLocation>(), new HashSet<RegistryKey<Biome>>());
    public static final BiomeType FROZEN_OCEAN = BiomeDictionary.register(BiomeType.create("frozen_ocean").biomes(Biomes.field_76776_l, Biomes.field_203620_Z));
    public static final BiomeType COLD_OCEAN = BiomeDictionary.register(BiomeType.create("cold_ocean").biomes(Biomes.field_203616_V, Biomes.field_203619_Y));
    public static final BiomeType WARM_OCEAN = BiomeDictionary.register(BiomeType.create("warm_ocean").biomes(Biomes.field_203614_T, Biomes.field_203617_W));
    public static final BiomeType OCEAN = BiomeDictionary.register(BiomeType.create("ocean").parents(COLD_OCEAN, WARM_OCEAN, FROZEN_OCEAN).biomes(Biomes.field_76771_b, Biomes.field_203618_X, Biomes.field_150575_M, Biomes.field_203615_U));
    public static final BiomeType PLAINS = BiomeDictionary.register(BiomeType.create("plains").biomes(Biomes.field_76772_c, Biomes.field_185441_Q).biomes("biomesoplenty", "steppe", "highland", "tundra", "lush_grassland", "grassland", "shrubland", "poppy_field", "scrubland", "flower_meadow", "prarie", "pasture"));
    public static final BiomeType SNOWY_PLAINS = BiomeDictionary.register(BiomeType.create("snowy_plains").biomes(Biomes.field_76774_n));
    public static final BiomeType DESERT = BiomeDictionary.register(BiomeType.create("desert").biomes(Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R).biomes("biomesoplenty", "xeric_shrubland", "outback"));
    public static final BiomeType SAVANNA = BiomeDictionary.register(BiomeType.create("savanna").biomes(Biomes.field_150588_X, Biomes.field_150587_Y).biomes("biomesoplenty", "brushland"));
    public static final BiomeType MOUNTAIN_SAVANNA = BiomeDictionary.register(BiomeType.create("mountain_savanna").biomes(Biomes.field_185435_ag, Biomes.field_185436_ah));
    public static final BiomeType FLOWERY = BiomeDictionary.register(BiomeType.create("flowery").biomes(Biomes.field_185444_T, Biomes.field_185441_Q).biomes("biomesoplenty", "lavender_field", "poppy_field", "flower_meadow"));
    public static final BiomeType OAK_FOREST = BiomeDictionary.register(BiomeType.create("oak_forest").biomes(Biomes.field_76767_f).biomes("biomesoplenty", "maple_woods", "orchard", "origin_hills", "rainforest", "silkglade", "snowy_forest", "woodland"));
    public static final BiomeType BIRCH_FOREST = BiomeDictionary.register(BiomeType.create("birch_forest").biomes(Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_185448_Z, Biomes.field_185429_aa).biomes("biomesoplenty", "boreal_forest", "rainbow_valley"));
    public static final BiomeType SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("spruce_forest").biomes(Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_150590_f).biomes("biomesoplenty", "shield", "grove", "meadow"));
    public static final BiomeType SNOWY_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("snowy_spruce_forest").biomes(Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_185431_ac));
    public static final BiomeType LARGE_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("large_spruce_forest").biomes(Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150578_U, Biomes.field_150581_V));
    public static final BiomeType BAMBOO_JUNGLE = BiomeDictionary.register(BiomeType.create("bamboo_jungle").biomes(Biomes.field_222370_aw, Biomes.field_222371_ax));
    public static final BiomeType JUNGLE = BiomeDictionary.register(BiomeType.create("jungle").parents(BAMBOO_JUNGLE).biomes(Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_185446_X, Biomes.field_185447_Y).biomes("biomesoplenty", "overgrown_cliffs"));
    public static final BiomeType DARK_FOREST = BiomeDictionary.register(BiomeType.create("dark_forest").biomes(Biomes.field_150585_R, Biomes.field_185430_ab));
    public static final BiomeType CONIFEROUS_FOREST = BiomeDictionary.register(BiomeType.create("coniferous_forest").biomes("biomesoplenty", "snowy_coniferous_forest", "coniferous_forest", "fir_clearing", "snowy_fir_clearing"));
    public static final BiomeType REDWOOD_FOREST = BiomeDictionary.register(BiomeType.create("redwood_forest").biomes("biomesoplenty", "redwood_forest", "redwood_forest_edge", "temperate_rainforest", "temperate_rainforest_hills"));
    public static final BiomeType AUTUMN_FOREST = BiomeDictionary.register(BiomeType.create("autumn_forest").biomes("biomesoplenty", "maple_woods", "seasonal_forest"));
    public static final BiomeType MOUNTAIN = BiomeDictionary.register(BiomeType.create("mountain").biomes(Biomes.field_76770_e, Biomes.field_185443_S, Biomes.field_185434_af, Biomes.field_76775_o, Biomes.field_150580_W).biomes("biomesoplenty", "steppe", "overgrown_cliffs", "highland_moor", "highland", "chaparral", "muskeg", "alps", "alps_foothills"));
    public static final BiomeType SWAMP = BiomeDictionary.register(BiomeType.create("swamp").biomes(Biomes.field_76780_h, Biomes.field_150599_m).biomes("biomesoplenty", "mire", "floodplain", "bayou", "mangrove", "wetland", "lush_swamp", "bog", "marsh"));
    public static final BiomeType BADLANDS = BiomeDictionary.register(BiomeType.create("bandlands").biomes(Biomes.field_150589_Z, Biomes.field_150608_ab, Biomes.field_185437_ai, Biomes.field_185439_ak, Biomes.field_185438_aj, Biomes.field_150607_aa).biomes("biomesoplenty", "outback"));
    public static final BiomeType MUSHROOM = BiomeDictionary.register(BiomeType.create("mushroom").biomes(Biomes.field_76788_q, Biomes.field_76789_p).biomes("biomesoplenty", "fungal_jungle"));
    public static final BiomeType RIVER = BiomeDictionary.register(BiomeType.create("river").biomes(Biomes.field_76781_i, Biomes.field_76777_m));
    public static final BiomeType LAKE = BiomeDictionary.register(BiomeType.create("lake").biomes("biomesoplenty", "oasis"));
    public static final BiomeType BEACH = BiomeDictionary.register(BiomeType.create("beach").biomes(Biomes.field_76787_r).biomes("biomesoplenty", "tropic_beach"));
    public static final BiomeType GRAVELLY = BiomeDictionary.register(BiomeType.create("gravelly").biomes("biomesoplenty", "gravel_beach", "cold_desert"));
    public static final BiomeType WOODED = BiomeDictionary.register(BiomeType.create("wooded").parents(OAK_FOREST, BIRCH_FOREST, SPRUCE_FOREST, SNOWY_SPRUCE_FOREST, LARGE_SPRUCE_FOREST, JUNGLE, DARK_FOREST, CONIFEROUS_FOREST, REDWOOD_FOREST).biomes(Biomes.field_185444_T).biomes("biomesoplenty", "seasonal_forest", "lavender_field", "tropical_rainforest", "dead_forest", "muskeg", "cherry_blossom_grove"));
    public static final BiomeType SANDY = BiomeDictionary.register(BiomeType.create("sandy").parents(DESERT, BEACH).biomes(Biomes.field_235252_ay_, Biomes.field_150589_Z));
    public static final BiomeType TROPICAL = BiomeDictionary.register(BiomeType.create("tropical").biomes("biomesoplenty", "tropic_beach", "tropics", "rainforest", "tropical_rainforest", "overgrown_cliffs"));
    public static final BiomeType VOLCANIC = BiomeDictionary.register(BiomeType.create("volcanic").biomes("biomesoplenty", "volcanic_plains", "volcano"));
    public static final BiomeType DEAD = BiomeDictionary.register(BiomeType.create("dead").biomes(Biomes.field_235254_j_).biomes("biomesoplenty", "dead_forest", "wasteland", "silkglade", "xeric_shrubland", "brushland", "muskeg"));
    public static final BiomeType FROZEN = BiomeDictionary.register(BiomeType.create("frozen").biomes(Biomes.field_76777_m, Biomes.field_185445_W));
    public static final BiomeType SNOWY = BiomeDictionary.register(BiomeType.create("snowy").parents(SNOWY_SPRUCE_FOREST, SNOWY_PLAINS).biomes(Biomes.field_76777_m, Biomes.field_150577_O).biomes("biomesoplenty", "snowy_forest", "snowy_coniferous_forest", "snowy_fir_clearing", "muskeg", "alps", "alps_foothills"));
    public static final BiomeType COLD = BiomeDictionary.register(BiomeType.create("cold").parents(SPRUCE_FOREST, LARGE_SPRUCE_FOREST, CONIFEROUS_FOREST).biomes(Biomes.field_76770_e, Biomes.field_185443_S, Biomes.field_150580_W, Biomes.field_185434_af, Biomes.field_150576_N).biomes("biomesoplenty", "tundra", "cold_desert"));
    public static final BiomeType NEUTRAL_TEMP = BiomeDictionary.register(BiomeType.create("neutral_temp").parents(PLAINS, OAK_FOREST, BIRCH_FOREST, DARK_FOREST).biomes(Biomes.field_185444_T));
    public static final BiomeType WARM = BiomeDictionary.register(BiomeType.create("warm").parents(SWAMP, JUNGLE, MUSHROOM, TROPICAL).biomes("biomesoplenty", "temperate_rainforest", "temperate_rainforest_hills"));
    public static final BiomeType HOT = BiomeDictionary.register(BiomeType.create("hot").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, VOLCANIC));
    public static final BiomeType FIERY = BiomeDictionary.register(BiomeType.create("fiery").biomes(Biomes.field_235254_j_, Biomes.field_235252_ay_, Biomes.field_235251_aB_));
    public static final BiomeType HUMID = BiomeDictionary.register(BiomeType.create("humid").parents(SWAMP, JUNGLE, TROPICAL));
    public static final BiomeType DRY = BiomeDictionary.register(BiomeType.create("dry").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, DEAD));
    public static final BiomeType OVERGROWN_NETHER = BiomeDictionary.register(BiomeType.create("overgrown_nether").biomes("biomesoplenty", "undergrowth"));
    public static final BiomeType NETHER_FOREST = BiomeDictionary.register(BiomeType.create("nether_forest").biomes(Biomes.field_235253_az_, Biomes.field_235250_aA_));
    public static final BiomeType NETHER = BiomeDictionary.register(BiomeType.create("nether").parents(NETHER_FOREST, OVERGROWN_NETHER).biomes(Biomes.field_235254_j_, Biomes.field_235252_ay_, Biomes.field_235251_aB_).biomes("biomesoplenty", "crystalline_chasm", "visceral_heap", "withered_abyss"));
    public static final BiomeType OUTER_END_ISLAND = BiomeDictionary.register(BiomeType.create("outer_end_island").biomes(Biomes.field_201938_R, Biomes.field_201937_Q).biomes("endergetic", "poise_forest", "chorus_plains", "end_midlands", "end_highlands"));
    public static final BiomeType OUTER_END = BiomeDictionary.register(BiomeType.create("outer_end").parents(OUTER_END_ISLAND).biomes(Biomes.field_201939_S, Biomes.field_201936_P));
    public static final BiomeType END = BiomeDictionary.register(BiomeType.create("end").parents(OUTER_END).biomes(Biomes.field_76779_k));
    public static final BiomeType OVERWORLD = BiomeDictionary.register(BiomeType.create("overworld").setBiomes(BiomeDictionary.getOverworldBiomes()));
    public static final BiomeType VOID = BiomeDictionary.register(BiomeType.create("void").biomes(Biomes.field_185440_P));
    public static final BiomeType MAGICAL = BiomeDictionary.register(BiomeType.create("magical").biomes("biomesoplenty", "mystic_grove", "rainbow_valley"));
    public static final BiomeType SPOOKY = BiomeDictionary.register(BiomeType.create("spooky").parents(DARK_FOREST).biomes("biomesoplenty", "ominous_woods", "pumpkin_patch", "silkglade", "visceral_heap", "withered_abyss"));
    public static final BiomeType RARE = BiomeDictionary.register(BiomeType.create("rare").parents(MUSHROOM).biomes(Biomes.field_150574_L).biomes("biomesoplenty", "mystic_grove", "origin_hills", "rainbow_valley"));

    public static void init() {
        REGISTRY.register((IForgeRegistryEntry)EMPTY);
    }

    public static BiomeType register(BiomeType biomeType) {
        ResourceLocation key = biomeType.getRegistryName();
        if (biomeType.getRegistryName().equals((Object)EMPTY_NAME)) {
            StructureGelMod.LOGGER.warn(String.format("Registry failed: Attempted to register a biome dictionary entry under the name \"%s\" and that shouldn't be done.", EMPTY_NAME.toString()));
            return biomeType;
        }
        if (REGISTRY.containsKey(key)) {
            ((BiomeType)REGISTRY.getValue(key)).addBiomes(biomeType.getBiomes()).addParents(biomeType.getParents());
        } else {
            REGISTRY.register((IForgeRegistryEntry)biomeType);
        }
        if (!BIOME_TO_BIOMETYPE_CACHE.isEmpty()) {
            BIOME_TO_BIOMETYPE_CACHE.clear();
        }
        return biomeType;
    }

    public static void registerAll(BiomeType ... biomeTypes) {
        for (BiomeType type : biomeTypes) {
            BiomeDictionary.register(type);
        }
    }

    public static Set<RegistryKey<Biome>> getOverworldBiomes() {
        HashSet<RegistryKey<Biome>> biomes = new HashSet<RegistryKey<Biome>>();
        ForgeRegistries.BIOMES.getValues().stream().filter(b -> (b.getRegistryName().func_110624_b().equals("minecraft") || b.getRegistryName().func_110624_b().equals(BOP)) && !NETHER.contains((Biome)b) && !END.contains((Biome)b)).forEach(b -> {
            if (BiomeDictionary.getBiomeKey(b) != null) {
                biomes.add(BiomeDictionary.getBiomeKey(b));
            }
        });
        return biomes;
    }

    protected static RegistryKey<Biome> getBiomeKey(Biome biome) {
        return RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)biome.getRegistryName());
    }

    public static Set<BiomeType> getAllTypes(RegistryKey<Biome> biome) {
        if (BIOME_TO_BIOMETYPE_CACHE.containsKey(biome)) {
            return BIOME_TO_BIOMETYPE_CACHE.get(biome);
        }
        HashSet<BiomeType> types = new HashSet<BiomeType>();
        REGISTRY.forEach((T type) -> {
            if (type.getAllBiomes().contains(biome)) {
                types.add((BiomeType)type);
            }
        });
        BIOME_TO_BIOMETYPE_CACHE.put(biome, types);
        return types;
    }

    public static boolean contains(ResourceLocation name) {
        return REGISTRY.containsKey(name);
    }

    public static BiomeType get(ResourceLocation name) {
        return (BiomeType)REGISTRY.getValue(name);
    }

    public static void forEach(Consumer<BiomeType> action) {
        REGISTRY.forEach(action);
    }
}

