/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile;

import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.WandererEntity;
import com.legacy.farlanders.entity.hostile.LooterEntity;
import com.legacy.farlanders.entity.hostile.RebelEntity;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.entity.util.ITeleportingEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TitanEntity
extends MonsterEntity
implements IColoredEyes,
ITeleportingEntity {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(TitanEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> HOLDING_PLAYER = EntityDataManager.func_187226_a(TitanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(TitanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> RAGE = EntityDataManager.func_187226_a(TitanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;
    private int holdingChance;
    private long holdingTimerInit;
    private long holdingTimerEnd;
    private LivingEntity entityRidingTitan;
    private int attackNumber;
    private float rageHealth;
    private long rageTimerInit;
    private long rageTimerEnd;

    public TitanEntity(EntityType<? extends TitanEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.rageTimerEnd = 0L;
        this.rageTimerInit = 0L;
        this.holdingChance = this.field_70146_Z.nextInt(15);
        this.attackNumber = -1;
        this.rageHealth = this.func_110138_aP() * 25.0f / 100.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.65, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LooterEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RebelEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WandererEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, false));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.rageHealth = this.func_110138_aP() * 25.0f / 100.0f;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(36));
        this.field_70180_af.func_187214_a(HOLDING_PLAYER, (Object)false);
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(RAGE, (Object)false);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74757_a("HoldingPlayer", this.getHoldingPlayer());
        compound.func_74757_a("IsAngry", this.getAngry());
        compound.func_74757_a("InRage", this.inRage());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setHoldingPlayer(compound.func_74767_n("HoldingPlayer"));
        this.setAngry(compound.func_74767_n("IsAngry"));
        this.setInRage(compound.func_74767_n("InRage"));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 4.8f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233818_a_, 135.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_203005_aq()) {
            this.teleportRandomly((LivingEntity)this);
        }
        try {
            int k;
            int j;
            int i;
            BlockPos pos;
            BlockState blockstate;
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.inRage()) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            }
            if (this.getHoldingPlayer() && this.func_184187_bx() == null && !this.field_70170_p.field_72995_K && this.entityRidingTitan != null) {
                this.entityRidingTitan.func_184220_m((Entity)this);
            }
            if (this.func_110143_aJ() < this.getRageHealth() && !this.inRage() && !this.field_70170_p.field_72995_K) {
                this.func_195064_c(new EffectInstance(Effects.field_76420_g, 232));
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 232));
                this.func_195064_c(new EffectInstance(Effects.field_76424_c, 232));
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 232));
                this.func_195064_c(new EffectInstance(Effects.field_76432_h, 5));
                this.func_184185_a(SoundEvents.field_187942_hp, 1.0f, 1.0f);
                this.rageTimerInit = System.currentTimeMillis();
                this.setInRage(true);
            }
            if (this.inRage() && !this.field_70170_p.field_72995_K) {
                this.rageTimerEnd = System.currentTimeMillis() - this.rageTimerInit;
                if (this.rageTimerEnd > 15000L) {
                    this.setInRage(false);
                }
            }
            if (TitanEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)this.field_70170_p, pos)) {
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_174813_aQ().field_72338_b + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
            }
            if (this.holdingChance == 1 && this.getHoldingPlayer() && !this.field_70170_p.field_72995_K && this.entityRidingTitan != null) {
                if (this.entityRidingTitan != null && !this.entityRidingTitan.func_70089_S()) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                }
                this.holdingTimerEnd = System.currentTimeMillis() - this.holdingTimerInit;
                if (this.attackNumber == 0 && this.holdingTimerEnd > 5000L) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                } else if (this.attackNumber == 1 && this.holdingTimerEnd > 3600L) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                } else if (this.attackNumber == 2 && this.holdingTimerEnd > 2200L) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                }
            } else {
                this.holdingChance = this.field_70146_Z.nextInt(15);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        if (this.holdingChance == 1 && !this.getHoldingPlayer()) {
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.setHoldingPlayer(true);
                this.attackNumber = this.field_70146_Z.nextInt(3);
                this.holdingTimerInit = System.currentTimeMillis();
                entityIn.func_184220_m((Entity)this);
                this.setAngry(true);
                if (this.attackNumber == 0) {
                    this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), FarlandersSounds.ENTITY_TITAN_HOLDING_LONG, SoundCategory.HOSTILE, 1.0f, 0.6f);
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76440_q, 120));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76431_k, 176));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76437_t, 120));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_82731_v, 120, 2));
                } else if (this.attackNumber == 1) {
                    this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), FarlandersSounds.ENTITY_TITAN_HOLDING_MED, SoundCategory.HOSTILE, 1.0f, 0.6f);
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76431_k, 144));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_82731_v, 80, 2));
                } else {
                    this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), FarlandersSounds.ENTITY_TITAN_HOLDING_SHORT, SoundCategory.HOSTILE, 1.0f, 0.6f);
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_82731_v, 56, 1));
                }
                this.entityRidingTitan = (LivingEntity)entityIn;
            } else if (this.field_70170_p.field_72995_K) {
                if (this.attackNumber == 0) {
                    this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), FarlandersSounds.ENTITY_TITAN_HOLDING_LONG, SoundCategory.HOSTILE, 1.0f, 0.6f);
                } else if (this.attackNumber == 1) {
                    this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), FarlandersSounds.ENTITY_TITAN_HOLDING_MED, SoundCategory.HOSTILE, 1.0f, 0.6f);
                } else {
                    this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), FarlandersSounds.ENTITY_TITAN_HOLDING_SHORT, SoundCategory.HOSTILE, 1.0f, 0.6f);
                }
            }
        } else {
            flag = this.getHoldingPlayer() ? entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f) : entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 8.0f);
        }
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source instanceof IndirectEntityDamageSource)) {
            boolean flag = super.func_70097_a(source, amount);
            if (!this.field_70170_p.func_201670_d() && source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
                this.teleportRandomly((LivingEntity)this);
            }
            return flag;
        }
        for (int i = 0; i < 64; ++i) {
            if (!this.teleportRandomly((LivingEntity)this)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_TITAN_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(FarlandersSounds.ENTITY_TITAN_HURT, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_TITAN_DEATH_ECHO;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected float func_70647_i() {
        return 0.8f;
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    public void setInRage(boolean rage) {
        this.field_70180_af.func_187227_b(RAGE, (Object)rage);
    }

    public boolean inRage() {
        return (Boolean)this.field_70180_af.func_187225_a(RAGE);
    }

    public void setHoldingPlayer(boolean hold) {
        this.field_70180_af.func_187227_b(HOLDING_PLAYER, (Object)hold);
    }

    public boolean getHoldingPlayer() {
        return (Boolean)this.field_70180_af.func_187225_a(HOLDING_PLAYER);
    }

    public void setAngry(boolean ang) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)ang);
    }

    public boolean getAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    public float getRageHealth() {
        return this.rageHealth;
    }
}

