/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile.boss;

import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.hostile.boss.summon.EnderColossusShadowEntity;
import com.legacy.farlanders.entity.hostile.boss.summon.MiniDragonEntity;
import com.legacy.farlanders.entity.hostile.boss.summon.ThrownBlockEntity;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class EnderColossusEntity
extends MonsterEntity
implements IRangedAttackMob {
    protected static final DataParameter<Boolean> NIGHTFALL_SPAWNED = EntityDataManager.func_187226_a(EnderColossusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EnderColossusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> SHADOW_COUNTER = EntityDataManager.func_187226_a(EnderColossusEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DRAGON_COUNTER = EntityDataManager.func_187226_a(EnderColossusEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.NOTCHED_6).func_186741_a(false).func_186742_b(true).func_186743_c(true);
    public int deathTicks;
    private int attackTimer;
    private int screamTimer;
    public boolean angry;

    public EnderColossusEntity(EntityType<? extends EnderColossusEntity> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedAttackGoal(this, 0.6, 30, 40.0f){

            public boolean func_75253_b() {
                MobEntity entity = (MobEntity)ObfuscationReflectionHelper.getPrivateValue(RangedAttackGoal.class, (Object)((Object)this), (String)"field_75322_b");
                if (entity.func_70638_az() != null) {
                    return entity.func_70032_d((Entity)entity.func_70638_az()) > 15.0f && super.func_75253_b();
                }
                return super.func_75250_a();
            }

            public boolean func_75250_a() {
                MobEntity entity = (MobEntity)ObfuscationReflectionHelper.getPrivateValue(RangedAttackGoal.class, (Object)((Object)this), (String)"field_75322_b");
                if (entity.func_70638_az() != null) {
                    return entity.func_70032_d((Entity)entity.func_70638_az()) > 15.0f && super.func_75250_a();
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.65, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 40.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 19.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(NIGHTFALL_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(SHADOW_COUNTER, (Object)2);
        this.field_70180_af.func_187214_a(DRAGON_COUNTER, (Object)1);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        this.setNightfallSpawned(compound.func_74767_n("NightfallSpawned"));
        this.setAngry(compound.func_74767_n("IsAngry"));
        this.setShadowCounter(compound.func_74762_e("ShadowCounter"));
        this.setDragonCounter(compound.func_74762_e("DragonCounter"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("NightfallSpawned", this.getNightfallSpawned());
        compound.func_74757_a("IsAngry", this.getAngry());
        compound.func_74768_a("ShadowCounter", this.getShadowCounter());
        compound.func_74768_a("DragonCounter", this.getDragonCounter());
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void setNightfallSpawned(boolean natural) {
        this.field_70180_af.func_187227_b(NIGHTFALL_SPAWNED, (Object)natural);
    }

    public boolean getNightfallSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(NIGHTFALL_SPAWNED);
    }

    private double getHealthPercentage() {
        return this.func_110143_aJ() * 100.0f / this.func_110138_aP();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 10.0f);
        if (flag) {
            double d0 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
            double d1 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
            double d2 = entityIn.func_226277_ct_() - d0;
            double d3 = entityIn.func_226281_cx_() - d1;
            double d4 = d2 * d2 + d3 * d3;
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(d2 / d4 * 1.1, 0.5000000029802323, d3 / d4 * 10.1));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 2.0f, 0.5f);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        }
        if (id == 5) {
            this.screamTimer = 100;
            this.func_184185_a(FarlandersSounds.ENTITY_MYSTIC_ENDERMINION_DEATH, 5.0f, 0.1f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getScreamTimer() {
        return this.screamTimer;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAngry(true);
        } else {
            this.setAngry(false);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.screamTimer > 0) {
            --this.screamTimer;
        }
        if (this.getHealthPercentage() < 25.0) {
            if (this.field_70146_Z.nextInt(400) == 0 && !this.field_70170_p.field_72995_K && this.field_70122_E && this.getScreamTimer() == 0 && this.func_70638_az() != null) {
                this.screamTimer = 100;
                this.func_184185_a(FarlandersSounds.ENTITY_MYSTIC_ENDERMINION_DEATH, 5.0f, 0.1f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                List list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0));
                if (!list.isEmpty()) {
                    for (int k = 0; k < list.size(); ++k) {
                        PlayerEntity entity = (PlayerEntity)list.get(k);
                        if (entity.func_184812_l_()) continue;
                        entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 1));
                        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 50, 2));
                    }
                }
            }
            return;
        }
        if (this.getHealthPercentage() < 75.0 && this.getHealthPercentage() > 25.0 && this.field_70146_Z.nextInt(400) == 0 && !this.field_70170_p.field_72995_K && this.field_70122_E && this.func_70638_az() != null && this.getScreamTimer() == 0) {
            this.func_184185_a(FarlandersSounds.ENTITY_ENDER_GOLEM_DEATH, 5.0f, 0.5f);
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 1.7000000014901162, 0.0));
        }
        if (this.getHealthPercentage() < 25.0 && this.getShadowCounter() == 1) {
            this.setShadowCounter(this.getShadowCounter() - 1);
            for (int i = 0; i < 3; ++i) {
                BlockPos offsetPos = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, this.func_233580_cy_().func_177982_a(this.field_70146_Z.nextInt(16) - 8, 0, this.field_70146_Z.nextInt(16) - 8));
                EnderColossusShadowEntity ent = new EnderColossusShadowEntity(FarlandersEntityTypes.ENDER_COLOSSUS_SHADOW, this.field_70170_p);
                ent.func_70012_b(offsetPos.func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p(), 0.0f, 0.0f);
                ent.func_70656_aK();
                this.func_184185_a(SoundEvents.field_187941_ho, 3.0f, 0.8f);
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_217376_c((Entity)ent);
            }
        } else if (this.getHealthPercentage() < 50.0 && this.getDragonCounter() == 1) {
            this.setDragonCounter(this.getDragonCounter() - 1);
            MiniDragonEntity ent = new MiniDragonEntity(FarlandersEntityTypes.MINI_ENDER_DRAGON, this.field_70170_p);
            ent.func_70012_b(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(32) - 16.0, this.func_226278_cu_() + (double)this.func_70047_e() + (double)this.field_70146_Z.nextInt(30), this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(32) - 16.0, 0.0f, 0.0f);
            this.func_184185_a(SoundEvents.field_187941_ho, 3.0f, 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)ent);
            }
        } else if (this.getHealthPercentage() < 75.0 && this.getShadowCounter() == 2) {
            this.setShadowCounter(this.getShadowCounter() - 1);
            for (int i = 0; i < 2; ++i) {
                EnderColossusShadowEntity ent = new EnderColossusShadowEntity(FarlandersEntityTypes.ENDER_COLOSSUS_SHADOW, this.field_70170_p);
                BlockPos offsetPos = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, this.func_233580_cy_().func_177982_a(this.field_70146_Z.nextInt(16) - 8, 0, this.field_70146_Z.nextInt(16) - 8));
                ent.func_70012_b(offsetPos.func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p(), 0.0f, 0.0f);
                ent.func_70656_aK();
                this.func_184185_a(SoundEvents.field_187941_ho, 3.0f, 0.8f);
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_217376_c((Entity)ent);
            }
        }
        if (this.func_70638_az() != null && this.func_110143_aJ() > 0.0f) {
            if (this.func_70032_d((Entity)this.func_70638_az()) >= 20.0f) {
                this.func_70605_aq().func_75642_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_(), this.func_70638_az().func_226281_cx_(), 1.0);
            }
            if (this.func_70032_d((Entity)this.func_70638_az()) >= 30.0f) {
                this.func_70107_b(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_() + 25.0, this.func_70638_az().func_226281_cx_());
                this.func_184185_a(FarlandersSounds.ENTITY_ENDER_GOLEM_DEATH, 5.0f, 0.5f);
                this.func_184185_a(SoundEvents.field_187534_aX, 5.0f, 0.5f);
                this.func_184185_a(SoundEvents.field_187534_aX, 5.0f, 0.7f);
            }
        }
    }

    protected void func_70609_aI() {
        int i;
        this.func_189654_d(true);
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 20.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_() + (double)f, this.func_226278_cu_() + 13.0 + (double)f1, this.func_226281_cx_() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e);
        int n = i = this.getNightfallSpawned() ? 12000 : 500;
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && flag) {
                this.dropExperience(MathHelper.func_76141_d((float)((float)i * 0.08f)));
            }
            if (this.deathTicks == 1) {
                this.func_213317_d(Vector3d.field_186680_a);
                this.field_70170_p.func_175669_a(1028, new BlockPos(this.func_213303_ch()), 0);
            }
        }
        this.func_213315_a(MoverType.SELF, new Vector3d(0.0, (double)0.2f, 0.0));
        this.field_70761_aq += 0.0f;
        this.field_70759_as += 0.0f;
        this.field_70125_A += 0.0f;
        if (this.deathTicks == 197 && !this.field_70170_p.field_72995_K) {
            if (flag) {
                this.dropExperience(MathHelper.func_76141_d((float)((float)i * 0.2f)));
            }
            this.func_70106_y();
        }
    }

    private void dropExperience(int amount) {
        while (amount > 0) {
            int i = ExperienceOrbEntity.func_70527_a((int)amount);
            amount -= i;
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), i));
        }
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_TITAN_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(FarlandersSounds.ENTITY_TITAN_HURT, this.func_70599_aP(), 0.1f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(FarlandersSounds.ENTITY_TITAN_DEATH_ECHO, 5.0f, 0.1f);
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 2.5f, 0.5f);
        this.func_184185_a(SoundEvents.field_187807_fF, 0.5f, 0.1f);
    }

    protected float func_70647_i() {
        return 0.6f;
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void fall(float distance, float damageMultiplier) {
        if (distance >= 10.0f) {
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, Explosion.Mode.NONE);
            List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(10.0, 5.0, 10.0));
            if (!list.isEmpty()) {
                for (int k = 0; k < list.size(); ++k) {
                    LivingEntity entity = (LivingEntity)list.get(k);
                    if (entity.field_70160_al) continue;
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
                }
            }
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        Vector3d look = this.func_70676_i(1.0f);
        double xPos = (double)this.func_233580_cy_().func_177958_n() + look.field_72450_a * 4.0;
        double yPos = (double)((float)this.func_233580_cy_().func_177956_o() + this.func_70047_e()) - 5.0;
        double zPos = (double)this.func_233580_cy_().func_177952_p() + look.field_72449_c * 4.0;
        ThrownBlockEntity thrownBlock = new ThrownBlockEntity(this.field_70170_p, xPos, yPos, zPos, (LivingEntity)this);
        thrownBlock.field_145812_b = 200;
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + ((double)(target.func_213302_cg() / 3.0f) - thrownBlock.func_226278_cu_() + 15.0);
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187596_cD, this.func_184176_by(), 4.0f, 0.5f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        float inaccuracy = 1.0f;
        float velocity = this.func_70032_d((Entity)target) / 26.0f;
        Vector3d vec3d = new Vector3d(d0, d1, d2).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        thrownBlock.func_213317_d(vec3d);
        float f1 = MathHelper.func_76133_a((double)EnderColossusEntity.func_213296_b((Vector3d)vec3d));
        thrownBlock.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)d2) * 57.2957763671875);
        thrownBlock.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f1) * 57.2957763671875);
        thrownBlock.field_70126_B = this.field_70177_z;
        thrownBlock.field_70127_C = this.field_70125_A;
        this.field_70170_p.func_217376_c((Entity)thrownBlock);
    }

    public void setAngry(boolean ang) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)ang);
    }

    public boolean getAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    public void setShadowCounter(int count) {
        this.field_70180_af.func_187227_b(SHADOW_COUNTER, (Object)count);
    }

    public int getShadowCounter() {
        return (Integer)this.field_70180_af.func_187225_a(SHADOW_COUNTER);
    }

    public void setDragonCounter(int count) {
        this.field_70180_af.func_187227_b(DRAGON_COUNTER, (Object)count);
    }

    public int getDragonCounter() {
        return (Integer)this.field_70180_af.func_187225_a(DRAGON_COUNTER);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }
}

