/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.registry;

import com.legacy.farlanders.FarlandersRegistry;
import com.legacy.farlanders.registry.FarlandersBlocks;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.legacy.farlanders.registry.FarlandersStructures;
import com.legacy.farlanders.world.structure.FarlanderLootFeature;
import com.legacy.farlanders.world.structure.TitanSpireFeature;
import com.legacy.structure_gel.access_helpers.BiomeAccessHelper;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.mojang.serialization.Codec;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FarlandersFeatures {
    public static final Feature<NoFeatureConfig> LOOT_WELL = new FarlanderLootFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, Blocks.field_196658_i.func_176223_P());
    public static final Feature<NoFeatureConfig> TITAN_SPIRE = new TitanSpireFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Feature<?>> event) {
        FarlandersRegistry.register(event.getRegistry(), "loot_well", LOOT_WELL);
        FarlandersRegistry.register(event.getRegistry(), "titan_spire", TITAN_SPIRE);
    }

    public static void addFeatures(Biome biomeIn) {
        if (!(biomeIn.func_201856_r() == Biome.Category.THEEND || biomeIn.func_201856_r() == Biome.Category.NETHER || biomeIn.func_201856_r() == Biome.Category.NONE || biomeIn.func_201856_r() == Biome.Category.RIVER || biomeIn.func_201856_r() == Biome.Category.OCEAN || BiomeDictionary.NETHER.contains(biomeIn) || BiomeDictionary.END.contains(biomeIn) || BiomeDictionary.VOID.contains(biomeIn) || BiomeDictionary.RIVER.contains(biomeIn) || BiomeDictionary.OCEAN.contains(biomeIn))) {
            if (BiomeDictionary.PLAINS.contains(biomeIn) && !BiomeDictionary.COLD.contains(biomeIn) && !BiomeDictionary.SNOWY.contains(biomeIn) && !BiomeDictionary.HOT.contains(biomeIn) && biomeIn.func_201856_r() != Biome.Category.FOREST) {
                BiomeAccessHelper.addStructure((Biome)biomeIn, (StructureFeature)FarlandersStructures.FARLANDER_VILLAGE.getStructureFeature());
            }
            BiomeAccessHelper.addStructure((Biome)biomeIn, (StructureFeature)FarlandersStructures.SMALL_HOUSE.getStructureFeature());
            BiomeAccessHelper.addFeature((Biome)biomeIn, (GenerationStage.Decoration)GenerationStage.Decoration.RAW_GENERATION, (ConfiguredFeature)((ConfiguredFeature)LOOT_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1)));
            BiomeAccessHelper.addFeature((Biome)biomeIn, (GenerationStage.Decoration)GenerationStage.Decoration.RAW_GENERATION, (ConfiguredFeature)TITAN_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(1))));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.CREATURE, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.ENDERMINION, 2, 1, 1));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.CREATURE, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.MYSTIC_ENDERMINION, 1, 1, 1));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.CREATURE, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.WANDERER, 3, 1, 1));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.MONSTER, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.LOOTER, 20, 1, 2));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.MONSTER, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.REBEL, 20, 1, 4));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.MONSTER, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.CLASSIC_ENDERMAN, 7, 1, 4));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.MONSTER, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.FANMADE_ENDERMAN, 5, 1, 2));
            BiomeAccessHelper.addSpawn((Biome)biomeIn, (EntityClassification)EntityClassification.MONSTER, (MobSpawnInfo.Spawners)new MobSpawnInfo.Spawners(FarlandersEntityTypes.MYSTIC_ENDERMAN, 3, 1, 2));
        }
        if (BiomeDictionary.MOUNTAIN.contains(biomeIn)) {
            BiomeAccessHelper.addFeature((Biome)biomeIn, (GenerationStage.Decoration)GenerationStage.Decoration.RAW_GENERATION, (ConfiguredFeature)Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), FarlandersBlocks.endumium_ore.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }

    public static boolean doesBiomeMatch(Biome biomeIn, RegistryKey<Biome> wantedBiomeIn) {
        return biomeIn.toString().matches(wantedBiomeIn.func_240901_a_().toString());
    }
}

