/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.util.Internal;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@Internal
public class StructureGelConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    protected static final ForgeConfigSpec COMMON_SPEC;
    protected static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPairCommon = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Client {
        private final ForgeConfigSpec.BooleanValue skipExperimentalBackupScreen;

        public Client(ForgeConfigSpec.Builder builder) {
            this.skipExperimentalBackupScreen = builder.comment("Skips the screen that tells you that a world uses experimental settings.").define("gui.skip_experimental_backup_screen", true);
        }

        public boolean skipExperimentalScreen() {
            return (Boolean)this.skipExperimentalBackupScreen.get();
        }
    }

    public static class Common {
        private final ForgeConfigSpec.BooleanValue extraLakeProofing;

        public Common(ForgeConfigSpec.Builder builder) {
            this.extraLakeProofing = builder.comment("Adds more vanilla structures to the list of structures that lakes cannot generate inside of. Only villages when set to false. Requires reload.").define("features.extra_lake_proofing", true);
        }

        public boolean getExtraLakeProofing() {
            return (Boolean)this.extraLakeProofing.get();
        }
    }
}

