/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.biome_dictionary;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.util.Internal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeType
implements IForgeRegistryEntry<BiomeType> {
    private ResourceLocation registryName = BiomeDictionary.EMPTY_NAME;
    private Set<ResourceLocation> biomes = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> parents = new HashSet<ResourceLocation>();

    public BiomeType(ResourceLocation name, Set<ResourceLocation> parents, Set<RegistryKey<Biome>> biomes) {
        if (name != null) {
            this.registryName = name;
        }
        if (parents != null) {
            this.parents = new HashSet<ResourceLocation>(parents);
        }
        if (biomes != null) {
            this.biomes = biomes.stream().map(r -> r.func_240901_a_()).collect(Collectors.toSet());
        }
    }

    @Internal
    private BiomeType() {
    }

    public static BiomeType create(ResourceLocation name) {
        BiomeType biomeType = new BiomeType();
        biomeType.registryName = name;
        return biomeType;
    }

    @Internal
    protected static BiomeType create(String name) {
        return BiomeType.create(StructureGelMod.locate(name));
    }

    public BiomeType biomes(RegistryKey<Biome> ... biomes) {
        this.addBiomes(Arrays.asList(biomes).stream().map(r -> r.func_240901_a_()).collect(Collectors.toSet()));
        return this;
    }

    public BiomeType biomes(String modid, String ... biomes) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String biome : biomes) {
            set.add(new ResourceLocation(modid, biome));
        }
        this.addBiomes(set);
        return this;
    }

    public BiomeType parents(ResourceLocation ... parents) {
        this.setParents(new HashSet<ResourceLocation>(Arrays.asList(parents)));
        return this;
    }

    public BiomeType parents(BiomeType ... parents) {
        this.parents = Arrays.asList(parents).stream().map(b -> b.getRegistryName()).collect(Collectors.toSet());
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public BiomeType setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public BiomeType addBiomes(Set<ResourceLocation> biomes) {
        this.getBiomes().addAll(biomes);
        return this;
    }

    public BiomeType addBiome(RegistryKey<Biome> biome) {
        this.getBiomes().add(biome.func_240901_a_());
        return this;
    }

    public Set<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    public BiomeType setBiomes(Set<RegistryKey<Biome>> biomes) {
        this.biomes = biomes.stream().map(r -> r.func_240901_a_()).collect(Collectors.toSet());
        return this;
    }

    public BiomeType addParents(Set<ResourceLocation> parents) {
        this.getParents().addAll(parents);
        return this;
    }

    public BiomeType addParent(ResourceLocation parent) {
        this.getParents().add(parent);
        return this;
    }

    public Set<ResourceLocation> getParents() {
        return this.parents;
    }

    public BiomeType setParents(Set<ResourceLocation> parents) {
        this.parents = new HashSet<ResourceLocation>(parents);
        return this;
    }

    public Set<RegistryKey<Biome>> getAllBiomes() {
        Set<RegistryKey<Biome>> biomes = this.getBiomes().stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).containsKey(arg_0)).map(r -> RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)r)).collect(Collectors.toSet());
        for (ResourceLocation parent : this.getParents()) {
            if (!BiomeDictionary.REGISTRY.containsKey(parent)) continue;
            biomes.addAll(((BiomeType)BiomeDictionary.REGISTRY.getValue(parent)).getAllBiomes());
        }
        return biomes;
    }

    public boolean contains(Biome biome) {
        if (BiomeDictionary.getBiomeKey(biome) != null) {
            return this.getAllBiomes().contains(BiomeDictionary.getBiomeKey(biome));
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeType) {
            return ((BiomeType)obj).getRegistryName().equals((Object)this.getRegistryName());
        }
        return false;
    }

    public String toString() {
        String parents = "";
        Iterator<ResourceLocation> iterator = this.getParents().iterator();
        while (iterator.hasNext()) {
            parents = parents + iterator.next().toString();
            if (!iterator.hasNext()) continue;
            parents = parents + ", ";
        }
        String biomes = "";
        Iterator<ResourceLocation> iterator2 = this.getBiomes().iterator();
        while (iterator2.hasNext()) {
            biomes = biomes + iterator2.next().toString();
            if (!iterator2.hasNext()) continue;
            biomes = biomes + ", ";
        }
        return String.format("name = %s, parents = [%s], biomes = [%s]", this.getRegistryName().toString(), parents, biomes);
    }

    public Class<BiomeType> getRegistryType() {
        return BiomeType.class;
    }
}

