/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.blocks;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.util.GelPortalSize;
import com.legacy.structure_gel.util.GelTeleporter;
import com.legacy.structure_gel.util.capability.GelCapability;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GelPortalBlock
extends NetherPortalBlock {
    private final Function<ServerWorld, GelTeleporter> teleporter;

    public GelPortalBlock(AbstractBlock.Properties properties, Function<ServerWorld, GelTeleporter> teleporter) {
        super(properties);
        this.teleporter = teleporter;
    }

    public static boolean fillPortal(World world, BlockPos pos, GelPortalBlock portal, List<Block> allowedBlocks) {
        GelTeleporter teleporter = portal.getTeleporter(null);
        return (world.func_234923_W_() == teleporter.getDimension1().get() || world.func_234923_W_() == teleporter.getDimension2().get()) && GelPortalSize.trySpawnPortal((IWorld)world, pos, portal, allowedBlocks);
    }

    public final GelTeleporter getTeleporter(ServerWorld world) {
        return this.teleporter.apply(world);
    }

    public Supplier<BlockState> getFrameBlock() {
        return this.teleporter.apply(null).getFrameBlock();
    }

    public int getMaxTimeInside(Entity entityIn) {
        return entityIn.func_82145_z();
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis facingAxis = facing.func_176740_k();
        Direction.Axis portalAxis = (Direction.Axis)stateIn.func_177229_b((Property)field_176550_a);
        boolean flag = portalAxis != facingAxis && facingAxis.func_176722_c();
        return !flag && !facingState.func_203425_a((Block)this) && !new GelPortalSize(worldIn, currentPos, portalAxis, this.getFrameBlock().get().func_177230_c(), this, (List<Block>)ImmutableList.of()).isPortalComplete() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU() && entityIn.getCapability(GelCapability.INSTANCE).isPresent()) {
            entityIn.func_181015_d(pos);
            entityIn.getCapability(GelCapability.INSTANCE).ifPresent(c -> c.setPortal(this));
        }
    }
}

