/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.registrars;

import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.registrars.IForgeRegistrar;
import com.legacy.structure_gel.util.RegistryHelper;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegistrar<C extends IFeatureConfig, S extends Structure<C>>
implements IForgeRegistrar<StructureRegistrar<C, S>, Structure<?>> {
    private final ResourceLocation name;
    private final S structure;
    private final IStructurePieceType pieceType;
    private final Map<String, StructureFeature<C, S>> structureFeatures;
    private final GenerationStage.Decoration generationStage;

    public StructureRegistrar(ResourceLocation name, S structure, IStructurePieceType pieceType, Map<String, C> configs, GenerationStage.Decoration generationStage) {
        this.name = name;
        this.structure = structure;
        this.pieceType = pieceType;
        this.structureFeatures = configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> structure.func_236391_a_((IFeatureConfig)v.getValue())));
        this.generationStage = generationStage;
    }

    public StructureRegistrar(ResourceLocation name, S structure, IStructurePieceType pieceType, C config, GenerationStage.Decoration generationStage) {
        this(name, structure, pieceType, ImmutableMap.of((Object)"", config), generationStage);
    }

    public static <C extends IFeatureConfig, S extends Structure<C>> StructureRegistrar<C, S> of(ResourceLocation name, S structure, IStructurePieceType pieceType, Map<String, C> configs, GenerationStage.Decoration generationStage) {
        return new StructureRegistrar<Map<String, C>, S>(name, structure, pieceType, configs, generationStage);
    }

    public static <C extends IFeatureConfig, S extends Structure<C>> StructureRegistrar<C, S> of(ResourceLocation name, S structure, IStructurePieceType pieceType, C config, GenerationStage.Decoration generationStage) {
        return new StructureRegistrar<C, S>(name, structure, pieceType, config, generationStage);
    }

    public S getStructure() {
        return this.structure;
    }

    public IStructurePieceType getPieceType() {
        return this.pieceType;
    }

    public Map<String, StructureFeature<C, S>> getStructureFeatures() {
        return this.structureFeatures;
    }

    @Nullable
    public StructureFeature<C, S> getStructureFeature(String name) {
        return this.structureFeatures.get(name);
    }

    @Nullable
    public StructureFeature<C, S> getStructureFeature() {
        if (this.structureFeatures.size() > 0) {
            return this.structureFeatures.get(this.structureFeatures.keySet().toArray()[0]);
        }
        return null;
    }

    @Override
    public StructureRegistrar<C, S> handle() {
        RegistryHelper.registerStructurePiece(this.name, this.pieceType);
        this.structureFeatures.forEach((s, sf) -> RegistryHelper.registerStructureFeature(s.isEmpty() ? this.name : new ResourceLocation(this.name.func_110624_b(), this.name.func_110623_a() + "_" + s), sf));
        return this;
    }

    @Override
    public StructureRegistrar<C, S> handleForge(IForgeRegistry<Structure<?>> registry) {
        RegistryHelper.registerStructure(registry, this.name, this.structure, this.generationStage);
        return this;
    }
}

