/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity;

import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.EnderGuardianEntity;
import com.legacy.farlanders.entity.hostile.LooterEntity;
import com.legacy.farlanders.entity.hostile.RebelEntity;
import com.legacy.farlanders.entity.util.FarlanderTrades;
import com.legacy.farlanders.registry.FarlandersItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WandererEntity
extends AbstractVillagerEntity {
    public Int2ObjectMap<VillagerTrades.ITrade[]> wandererTrades = new Int2ObjectOpenHashMap();
    private BlockPos targetWanderingPos;
    private int despawnDelay;

    public WandererEntity(EntityType<? extends WandererEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
        this.field_98038_p = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, LooterEntity.class, 8.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, RebelEntity.class, 8.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, EnderGolemEntity.class, 8.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, EnderGuardianEntity.class, 20.0f, 0.5, 0.7));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveToGoal(this, 2.0, 0.35));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    public AgeableEntity func_241840_a(ServerWorld worldIn, AgeableEntity ageableIn) {
        return null;
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() != FarlandersItems.wanderer_spawn_egg && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (p_230254_2_ == Hand.MAIN_HAND) {
                p_230254_1_.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(p_230254_1_);
                this.func_213707_a(p_230254_1_, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] wandererTradeList = (VillagerTrades.ITrade[])FarlanderTrades.wandererTrades.get(1);
        if (wandererTradeList != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, wandererTradeList, 5);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
        if (this.targetWanderingPos != null) {
            compound.func_218657_a("WanderTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.targetWanderingPos));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
        if (compound.func_74764_b("WanderTarget")) {
            this.targetWanderingPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("WanderTarget"));
        }
        this.func_70873_a(Math.max(0, this.func_70874_b()));
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.field_70173_aa > 3600;
    }

    protected void func_213713_b(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_FARLANDER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FarlandersSounds.ENTITY_FARLANDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_FARLANDER_DEATH;
    }

    public SoundEvent func_213714_ea() {
        this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 1.3f);
        return null;
    }

    protected SoundEvent func_213721_r(boolean positive) {
        if (positive) {
            this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 1.3f);
        } else {
            this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 0.7f);
        }
        return null;
    }

    public void func_213728_s(int p_213728_1_) {
        this.despawnDelay = p_213728_1_;
    }

    public int func_213735_eg() {
        return this.despawnDelay;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_203005_aq()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_222821_eh();
        }
    }

    private void func_222821_eh() {
        if (this.despawnDelay > 0 && !this.func_213716_dX() && --this.despawnDelay == 0) {
            this.func_70106_y();
        }
    }

    public void setWanderPos(BlockPos pos) {
        this.targetWanderingPos = pos;
    }

    @Nullable
    private BlockPos wanderPos() {
        return this.targetWanderingPos;
    }

    protected class MoveToGoal
    extends Goal {
        final WandererEntity entity;
        final double maxDistance;
        final double speed;

        protected MoveToGoal(WandererEntity entityIn, double maxDistanceIn, double speedIn) {
            this.entity = entityIn;
            this.maxDistance = maxDistanceIn;
            this.speed = speedIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            this.entity.setWanderPos(null);
            WandererEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.entity.wanderPos();
            return blockpos != null && this.canMoveToPos(blockpos, this.maxDistance);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.entity.wanderPos();
            if (blockpos != null && WandererEntity.this.field_70699_by.func_75500_f()) {
                if (this.canMoveToPos(blockpos, 10.0)) {
                    Vector3d vec3d = new Vector3d((double)blockpos.func_177958_n() - this.entity.func_226277_ct_(), (double)blockpos.func_177956_o() - this.entity.func_226278_cu_(), (double)blockpos.func_177952_p() - this.entity.func_226281_cx_()).func_72432_b();
                    Vector3d vec3d1 = vec3d.func_186678_a(10.0).func_72441_c(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_());
                    WandererEntity.this.field_70699_by.func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.speed);
                } else {
                    WandererEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean canMoveToPos(BlockPos posIn, double distanceIn) {
            return !posIn.func_218137_a((IPosition)this.entity.func_213303_ch(), distanceIn);
        }
    }
}

