/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.ai.tasks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.farlanders.entity.FarlanderEntity;
import com.legacy.farlanders.entity.ai.tasks.FarlanderClearHurtTask;
import com.legacy.farlanders.entity.ai.tasks.FarlanderPanicTask;
import com.legacy.farlanders.entity.ai.tasks.FarlanderStayNearPointTask;
import com.legacy.farlanders.entity.ai.tasks.FarlanderTradeTask;
import com.legacy.farlanders.entity.ai.tasks.FarlanderWalkToPOITask;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.BeginRaidTask;
import net.minecraft.entity.ai.brain.task.CongregateTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.ExpirePOITask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindWalkTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.GatherPOITask;
import net.minecraft.entity.ai.brain.task.HideFromRaidOnBellRingTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.JumpOnBedTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.UpdateActivityTask;
import net.minecraft.entity.ai.brain.task.WakeUpTask;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToHouseTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkToVillagerBabiesTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.ai.brain.task.WorkTask;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.village.PointOfInterestType;

public class FarlanderTasks {
    public static ImmutableList<Pair<Integer, ? extends Task<? super FarlanderEntity>>> core(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SwimTask(0.8f)), (Object)Pair.of((Object)0, (Object)new InteractWithDoorTask()), (Object)Pair.of((Object)0, (Object)new LookTask(45, 90)), (Object)Pair.of((Object)0, (Object)((Object)new FarlanderPanicTask())), (Object)Pair.of((Object)0, (Object)new WakeUpTask()), (Object)Pair.of((Object)0, (Object)new HideFromRaidOnBellRingTask()), (Object)Pair.of((Object)0, (Object)new BeginRaidTask()), (Object)Pair.of((Object)1, (Object)new WalkToTargetTask()), (Object)Pair.of((Object)2, (Object)((Object)new FarlanderTradeTask(speed))), (Object)Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221069_q, MemoryModuleType.field_220941_b, false, Optional.of((byte)14))), (Object)Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d, true, Optional.of((byte)14))));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super FarlanderEntity>>> work(float speed) {
        return ImmutableList.of(FarlanderTasks.lookAtPlayersOrVillagers(), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super FarlanderEntity>>> play(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new WalkToTargetTask(80, 120)), FarlanderTasks.lookAtMany(), (Object)Pair.of((Object)5, (Object)new WalkToVillagerBabiesTask()), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220947_h, (Object)MemoryModuleStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(FarlandersEntityTypes.FARLANDER, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speed, (int)2), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_220360_g, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speed, (int)2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(speed), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(speed, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(speed), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super FarlanderEntity>>> meet(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WorkTask(MemoryModuleType.field_220943_d, 0.4f, 40), (Object)2), (Object)Pair.of((Object)new CongregateTask(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)2, (Object)((Object)new FarlanderStayNearPointTask((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220943_d, speed, 6, 100, 200))), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d)), FarlanderTasks.lookAtMany(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super FarlanderEntity>>> rest(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)((Object)new FarlanderStayNearPointTask((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220941_b, speed, 1, 150, 1200))), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.field_221069_q, MemoryModuleType.field_220941_b)), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new WalkToHouseTask(speed), (Object)1), (Object)Pair.of((Object)new WalkRandomlyTask(speed), (Object)4), (Object)Pair.of((Object)((Object)new FarlanderWalkToPOITask(speed, 4)), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), FarlanderTasks.lookAtPlayersOrVillagers(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super FarlanderEntity>>> idle(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(FarlandersEntityTypes.FARLANDER, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speed, (int)2), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_220360_g, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speed, (int)2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(speed), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(speed, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(speed), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), FarlanderTasks.lookAtMany(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super FarlanderEntity>>> panic(float speed) {
        float f = speed * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FarlanderClearHurtTask())), (Object)Pair.of((Object)1, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220959_t, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)1, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220958_s, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)new FindWalkTargetTask(f, 2, 2)), FarlanderTasks.lookAtPlayersOrVillagers());
    }

    private static Pair<Integer, Task<FarlanderEntity>> lookAtMany() {
        return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(FarlandersEntityTypes.ELDER_FARLANDER, 8.0f), (Object)8), (Object)Pair.of((Object)new LookAtEntityTask(FarlandersEntityTypes.ENDER_GUARDIAN, 8.0f), (Object)8), (Object)Pair.of((Object)new LookAtEntityTask(FarlandersEntityTypes.ENDER_GOLEM, 8.0f), (Object)8), (Object)Pair.of((Object)new LookAtEntityTask(FarlandersEntityTypes.FARLANDER, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)2))));
    }

    private static Pair<Integer, Task<FarlanderEntity>> lookAtPlayersOrVillagers() {
        return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(FarlandersEntityTypes.FARLANDER, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200756_av, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)8))));
    }
}

