/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.google.common.collect.Lists;
import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.entity.ElderFarlanderEntity;
import com.legacy.farlanders.entity.FarlanderEntity;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.legacy.farlanders.registry.FarlandersStructures;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelConfigJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallHouseStructure
extends GelConfigJigsawStructure {
    public SmallHouseStructure(Codec<VillageConfig> configFactoryIn, ConfigTemplates.StructureConfig config) {
        super(configFactoryIn, config, 0, true, true);
        this.setSpawnList(EntityClassification.MONSTER, Lists.newArrayList());
    }

    public int getSeed() {
        return 395674;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt);
        }

        public IStructurePieceType func_214807_k() {
            return FarlandersStructures.SMALL_HOUSE.getPieceType();
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox bounds) {
            FarlanderEntity entity;
            if (key.equals("farlander")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (FarlanderEntity)this.createEntity(FarlandersEntityTypes.FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("elder")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (ElderFarlanderEntity)this.createEntity(FarlandersEntityTypes.ELDER_FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("golem")) {
                this.setAir((IWorld)worldIn, pos);
                int safeY = worldIn.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos.func_177958_n(), pos.func_177952_p());
                BlockPos groundPos = new BlockPos(pos.func_177958_n(), safeY, pos.func_177952_p());
                EnderGolemEntity entity2 = (EnderGolemEntity)this.createEntity(FarlandersEntityTypes.ENDER_GOLEM, worldIn, groundPos, this.field_214834_c);
                entity2.func_213386_a(worldIn, worldIn.func_175649_E(groundPos), SpawnReason.STRUCTURE, null, null);
                entity2.func_110163_bv();
                worldIn.func_217376_c((Entity)entity2);
            }
            if (key.equals("chest")) {
                worldIn.func_180501_a(pos, Blocks.field_196553_aF.func_176223_P(), 3);
                ChestTileEntity tile = (ChestTileEntity)worldIn.func_175625_s(pos.func_177977_b());
                tile.func_189404_a(TheFarlandersMod.locate("chests/elder_house_chest"), worldIn.func_201674_k().nextLong());
            }
        }
    }
}

