/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.TitanEntity;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class TitanSpireFeature
extends Feature<NoFeatureConfig> {
    private BlockState replaceID = Blocks.field_196658_i.func_176223_P();

    public TitanSpireFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean locationIsValidSpawn(IWorld worldIn, int x, int y, int z) {
        int distanceToAir;
        BlockPos pos = new BlockPos(x, y, z);
        BlockState checkID = worldIn.func_180495_p(pos);
        for (distanceToAir = 0; distanceToAir < 255 && checkID != Blocks.field_150350_a.func_176223_P(); ++distanceToAir) {
            checkID = worldIn.func_180495_p(pos.func_177963_a(0.0, (double)distanceToAir, 0.0));
            if (distanceToAir > 100) {
                return false;
            }
            if (distanceToAir >= 0) continue;
            return false;
        }
        if (distanceToAir > 2) {
            return false;
        }
        y += distanceToAir - 1;
        BlockState blockID = worldIn.func_180495_p(pos);
        BlockState blockIDAbove = worldIn.func_180495_p(pos.func_177984_a());
        BlockState blockIDBelow = worldIn.func_180495_p(pos.func_177977_b());
        if (blockIDAbove != Blocks.field_150350_a.func_176223_P()) {
            return false;
        }
        if (blockID.func_177230_c() == Blocks.field_150433_aE && blockIDBelow == this.replaceID || blockID.func_177230_c() == Blocks.field_150349_c && blockIDBelow == this.replaceID || blockID == Blocks.field_196606_bd.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196605_bc.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196555_aI.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150434_aF.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150338_P.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150337_Q.func_176223_P() && blockIDBelow == this.replaceID) {
            return true;
        }
        return blockID == this.replaceID;
    }

    public boolean func_241855_a(ISeedReader worldIn, ChunkGenerator generatorIn, Random randomIn, BlockPos posIn, NoFeatureConfig configIn) {
        int x = posIn.func_177958_n();
        int y = posIn.func_177956_o();
        int z = posIn.func_177952_p();
        if ((Integer)FarlandersConfig.COMMON.obsidianSpireSpawnRate.get() > 1 && randomIn.nextInt((Integer)FarlandersConfig.COMMON.obsidianSpireSpawnRate.get()) != 0 || (Integer)FarlandersConfig.COMMON.obsidianSpireSpawnRate.get() <= 1) {
            return false;
        }
        if (this.locationIsValidSpawn((IWorld)worldIn, x, y, z)) {
            int finalX;
            int newY;
            int yOffset = randomIn.nextInt(32) + 8;
            int xZOffset = randomIn.nextInt(4) + 3;
            int newX = 0;
            int newZ = 0;
            for (newY = x - xZOffset; newY <= x + xZOffset; ++newY) {
                for (newX = z - xZOffset; newX <= z + xZOffset; ++newX) {
                    newZ = newY - x;
                    finalX = newX - z;
                    if (newZ * newZ + finalX * finalX > xZOffset * xZOffset + 1 || worldIn.func_180495_p(new BlockPos(newY, y - 1, newX)) == this.replaceID) continue;
                    return false;
                }
            }
            for (newY = y; newY < y + yOffset && newY < 128; ++newY) {
                for (newX = x - xZOffset; newX <= x + xZOffset; ++newX) {
                    for (newZ = z - xZOffset; newZ <= z + xZOffset; ++newZ) {
                        finalX = newX - x;
                        int finalZ = newZ - z;
                        if (finalX * finalX + finalZ * finalZ > xZOffset * xZOffset + 1) continue;
                        worldIn.func_180501_a(new BlockPos(newX, newY, newZ), Blocks.field_150343_Z.func_176223_P(), 2);
                    }
                }
            }
            if (worldIn.func_201674_k().nextBoolean()) {
                worldIn.func_180501_a(new BlockPos(newX - 6, newY - 3, newZ - 4), Blocks.field_150486_ae.func_176223_P(), 2);
                ChestTileEntity tile = (ChestTileEntity)worldIn.func_175625_s(new BlockPos(newX - 6, newY - 3, newZ - 4));
                tile.func_189404_a(TheFarlandersMod.locate("chests/spire_chest"), worldIn.func_201674_k().nextLong());
            } else {
                worldIn.func_180501_a(new BlockPos(newX - 6, newY - 6, newZ - 4), Blocks.field_150486_ae.func_176223_P(), 2);
                ChestTileEntity tile2 = (ChestTileEntity)worldIn.func_175625_s(new BlockPos(newX - 6, newY - 6, newZ - 4));
                tile2.func_189404_a(TheFarlandersMod.locate("chests/spire_chest"), worldIn.func_201674_k().nextLong());
            }
            if (worldIn.func_201674_k().nextInt(4) == 3) {
                TitanEntity var4 = new TitanEntity(FarlandersEntityTypes.TITAN, (World)worldIn.func_201672_e());
                var4.func_70107_b(newX - 6, newY + 2, newZ - 4);
                var4.func_110163_bv();
                worldIn.func_217376_c((Entity)var4);
            } else {
                EnderGolemEntity var5 = new EnderGolemEntity(FarlandersEntityTypes.ENDER_GOLEM, (World)worldIn.func_201672_e());
                var5.func_70107_b(newX - 6, newY + 2, newZ - 4);
                var5.func_110163_bv();
                worldIn.func_217376_c((Entity)var5);
            }
            return true;
        }
        return false;
    }
}

