/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagespawnpoint_common_forge.events;

import com.mojang.logging.LogUtils;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.FeatureFunctions;
import com.natamus.villagespawnpoint_common_forge.data.Constants;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.ServerLevelData;
import org.slf4j.Logger;

public class VillageSpawnEvent {
    private static final Logger logger = LogUtils.getLogger();

    public static boolean onWorldLoad(ServerLevel serverLevel, ServerLevelData serverLevelData) {
        if (Constants.biomeSpawnPointLoaded) {
            return false;
        }
        WorldGenSettings worldGeneratorOptions = serverLevel.m_142572_().m_129910_().m_5961_();
        if (!worldGeneratorOptions.m_64657_()) {
            return false;
        }
        logger.info("[Village Spawn Point] Finding the nearest village. This might take a few seconds.");
        BlockPos spawnpos = BlockPosFunctions.getCenterNearbyVillage((ServerLevel)serverLevel);
        if (spawnpos == null) {
            return false;
        }
        logger.info("[Village Spawn Point] Village found! The world will now generate.");
        serverLevel.m_8733_(spawnpos, 1.0f);
        if (worldGeneratorOptions.m_64660_()) {
            FeatureFunctions.placeBonusChest((Level)serverLevel, (BlockPos)spawnpos);
        }
        return true;
    }
}

