/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.forgemod.Share;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockModel;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.ColorUtils;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;

public class ColorManager
implements IColorManager {
    private IVoxelMap master;
    Minecraft game = null;
    private boolean resourcePacksChanged = false;
    private BufferedImage terrainBuff = null;
    private BufferedImage colorPicker;
    private int sizeOfBiomeArray = 0;
    private final int BIOME_ARRAY_HEIGHT = 32;
    private final int WORLD_HEIGHT = 256;
    private final int BIOME_ARRAY_HEIGHT_MULTIPLIER = 8;
    private int[] blockColors = new int[16384];
    private int[] blockColorsWithDefaultTint = new int[16384];
    private final int COLOR_NOT_LOADED = -16842497;
    private final int COLOR_FAILED_LOAD = 0x1B000000;
    private HashSet<Integer> biomeTintsAvailable = new HashSet();
    private boolean optifineInstalled = false;
    private HashMap<Integer, int[][]> blockTintTables = new HashMap();
    private HashSet<Integer> biomeTextureAvailable = new HashSet();
    private HashMap<String, Integer> blockBiomeSpecificColors = new HashMap();
    private float failedToLoadX = 0.0f;
    private float failedToLoadY = 0.0f;
    private String renderPassThreeBlendMode;
    private Random random = new Random();
    private final Object tpLoadLock = new Object();
    private boolean loaded = false;
    private final MutableBlockPos dummyBlockPos = new MutableBlockPos(BlockPos.field_177992_a.func_177958_n(), BlockPos.field_177992_a.func_177956_o(), BlockPos.field_177992_a.func_177952_p());
    private final ColorResolver spruceColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome biome, BlockPos blockPos) {
            return FoliageColors.func_77466_a();
        }
    };
    private final ColorResolver birchColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome biome, BlockPos blockPos) {
            return FoliageColors.func_77469_b();
        }
    };
    private final ColorResolver grassColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome biome, BlockPos blockPos) {
            return biome.func_225528_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177952_p());
        }
    };
    private final ColorResolver foliageColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome biome, BlockPos blockPos) {
            return biome.func_225527_a_();
        }
    };
    private final ColorResolver waterColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome biome, BlockPos blockPos) {
            return biome.func_185361_o();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorManager(IVoxelMap master) {
        this.master = master;
        this.game = Minecraft.func_71410_x();
        this.optifineInstalled = false;
        Field ofProfiler = null;
        try {
            ofProfiler = GameSettings.class.getDeclaredField("ofProfiler");
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        finally {
            if (ofProfiler != null) {
                this.optifineInstalled = true;
            }
        }
        for (Biome biome : WorldGenRegistries.field_243657_i) {
            int biomeID = WorldGenRegistries.field_243657_i.func_148757_b((Object)biome);
            if (biomeID <= this.sizeOfBiomeArray) continue;
            this.sizeOfBiomeArray = biomeID;
        }
        ++this.sizeOfBiomeArray;
    }

    @Override
    public int getAirColor() {
        return this.blockColors[BlockRepository.airID];
    }

    @Override
    public BufferedImage getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.resourcePacksChanged = true;
    }

    @Override
    public boolean checkForChanges() {
        boolean changed = this.resourcePacksChanged;
        this.resourcePacksChanged = false;
        if (changed) {
            this.loadColors();
        }
        return changed;
    }

    public void loadColors() {
        this.game.field_71439_g.func_110306_p();
        BlockRepository.getBlocks();
        BiomeRepository.getBiomes();
        this.loadColorPicker();
        this.loadTexturePackTerrainImage();
        TextureAtlasSprite missing = (TextureAtlasSprite)this.game.func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("missingno"));
        this.failedToLoadX = missing.func_94209_e();
        this.failedToLoadY = missing.func_94206_g();
        this.loaded = false;
        try {
            Arrays.fill(this.blockColors, -16842497);
            Arrays.fill(this.blockColorsWithDefaultTint, -16842497);
            this.loadSpecialColors();
            this.biomeTintsAvailable.clear();
            this.biomeTextureAvailable.clear();
            this.blockBiomeSpecificColors.clear();
            this.blockTintTables.clear();
            if (this.optifineInstalled) {
                try {
                    this.processCTM();
                }
                catch (Exception e) {
                    System.err.println("error loading CTM " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            try {
                this.loadWaterColor();
            }
            catch (Exception e) {
                System.err.println("error getting water color " + e.getLocalizedMessage());
            }
            if (this.optifineInstalled) {
                try {
                    this.processColorProperties();
                }
                catch (Exception e) {
                    System.err.println("error loading custom color properties " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            this.master.getMap().forceFullRender(true);
        }
        catch (Exception e) {
            System.err.println("error loading pack");
            e.printStackTrace();
        }
        this.loaded = true;
    }

    @Override
    public final BufferedImage getBlockImage(BlockState blockState, ItemStack stack, World world, float iconScale, float captureDepth) {
        try {
            BlockRendererDispatcher blockRendererDispatcher = this.game.func_175602_ab();
            IBakedModel model = this.game.func_175599_af().func_184393_a(stack, world, (LivingEntity)null);
            this.drawModel(Direction.EAST, blockState, model, stack, iconScale, captureDepth);
            BufferedImage blockImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            return blockImage;
        }
        catch (Exception e) {
            System.out.println("error getting block armor image for " + blockState.toString() + ": " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void drawModel(Direction facing, BlockState blockState, IBakedModel model, ItemStack stack, float scale, float captureDepth) {
        float size = 8.0f * scale;
        ItemCameraTransforms transforms = model.func_177552_f();
        ItemTransformVec3f headTransforms = transforms.field_178353_d;
        Vector3f translations = headTransforms.field_178365_c;
        float transX = translations.func_195899_a() * size + 0.5f * size;
        float transY = translations.func_195900_b() * size + 0.5f * size;
        float transZ = -translations.func_195902_c() * size + 0.5f * size;
        Vector3f rotations = headTransforms.field_178364_b;
        float rotX = rotations.func_195899_a();
        float rotY = -rotations.func_195900_b();
        float rotZ = rotations.func_195902_c();
        GLShim.glBindTexture(3553, GLUtils.fboTextureID);
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        GLShim.glBindTexture(3553, 0);
        GLShim.glPushAttrib(4096);
        GLShim.glViewport(0, 0, width, height);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, width, height, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -3000.0f - captureDepth * scale);
        GLUtils.bindFrameBuffer();
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glEnable(3553);
        GLShim.glEnable(3042);
        GLShim.glEnable(3008);
        GLShim.glEnable(2977);
        GLShim.glDisable(2884);
        GLShim.glTexEnvi(8960, 8704, 7681);
        GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLShim.glClear(16640);
        GLShim.glBlendFunc(770, 771);
        GLShim.glPushMatrix();
        GLShim.glTranslatef((float)(width / 2) - size / 2.0f + transX, (float)(height / 2) - size / 2.0f + transY, 0.0f + transZ);
        GLShim.glScalef(size, size, size);
        GLUtils.img(AtlasTexture.field_110575_b);
        GLShim.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(rotY, 0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(rotX, 1.0f, 0.0f, 0.0f);
        GLShim.glRotatef(rotZ, 0.0f, 0.0f, 1.0f);
        if (facing == Direction.UP) {
            GLShim.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        }
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
        IRenderTypeBuffer.Impl immediate = this.game.func_228019_au_().func_228487_b_();
        this.game.func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, matrixStack, (IRenderTypeBuffer)immediate, 0xF000F0, OverlayTexture.field_229196_a_, model);
        immediate.func_228461_a_();
        GLShim.glPopMatrix();
        GLShim.glTexEnvi(8960, 8704, 8448);
        GLShim.glEnable(2884);
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glPopAttrib();
        GLShim.glViewport(0, 0, this.game.func_228018_at_().func_198109_k(), this.game.func_228018_at_().func_198091_l());
    }

    private void loadColorPicker() {
        try {
            InputStream is = this.game.func_195551_G().func_199002_a(new ResourceLocation("voxelmap", "images/colorpicker.png")).func_199027_b();
            BufferedImage picker = ImageIO.read(is);
            is.close();
            this.colorPicker = new BufferedImage(((Image)picker).getWidth(null), ((Image)picker).getHeight(null), 2);
            Graphics2D gfx = this.colorPicker.createGraphics();
            gfx.drawImage((Image)picker, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception e) {
            System.err.println("Error loading color picker: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setSkyColor(int skyColor) {
        this.blockColors[BlockRepository.airID] = skyColor;
        this.blockColors[BlockRepository.voidAirID] = skyColor;
    }

    private void loadTexturePackTerrainImage() {
        try {
            TextureManager textureManager = this.game.func_110434_K();
            textureManager.func_110577_a(AtlasTexture.field_110575_b);
            BufferedImage terrainStitched = ImageUtils.createBufferedImageFromCurrentGLImage();
            this.terrainBuff = new BufferedImage(terrainStitched.getWidth(null), terrainStitched.getHeight(null), 6);
            Graphics2D gfx = this.terrainBuff.createGraphics();
            gfx.drawImage((Image)terrainStitched, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception e) {
            System.err.println("Error processing new resource pack: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void loadSpecialColors() {
        int blockStateID;
        for (BlockState blockState : BlockRepository.pistonTechBlock.func_176194_O().func_177619_a()) {
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColors[blockStateID] = 0;
        }
        for (BlockState blockState : BlockRepository.barrier.func_176194_O().func_177619_a()) {
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColors[blockStateID] = 0;
        }
    }

    private void loadWaterColor() {
        int waterRGB = -1;
        BlockState blockState = BlockRepository.water.func_176223_P();
        int blockStateID = BlockRepository.getStateId(blockState);
        waterRGB = this.getBlockColor(blockStateID);
        int waterMult = -1;
        if (this.optifineInstalled) {
            InputStream is = null;
            try {
                is = this.game.func_195551_G().func_199002_a(new ResourceLocation("optifine/colormap/water.png")).func_199027_b();
            }
            catch (IOException e) {
                is = null;
            }
            if (is != null) {
                try {
                    BufferedImage waterColor = ImageIO.read(is);
                    is.close();
                    BufferedImage waterColorBuff = new BufferedImage(((Image)waterColor).getWidth(null), ((Image)waterColor).getHeight(null), 1);
                    Graphics2D gfx = waterColorBuff.createGraphics();
                    gfx.drawImage((Image)waterColor, 0, 0, null);
                    gfx.dispose();
                    Biome biome = BiomeRepository.FOREST;
                    double var1 = MathHelper.func_76131_a((float)biome.func_225486_c(new BlockPos(0, 64, 0)), (float)0.0f, (float)1.0f);
                    double var2 = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
                    var2 *= var1;
                    var1 = 1.0 - var1;
                    var2 = 1.0 - var2;
                    waterMult = waterColorBuff.getRGB((int)((double)(waterColorBuff.getWidth() - 1) * var1), (int)((double)(waterColorBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        waterRGB = waterMult != -1 && waterMult != 0 ? ColorUtils.colorMultiplier(waterRGB, waterMult | 0xFF000000) : ColorUtils.colorMultiplier(waterRGB, BiomeRepository.FOREST.func_185361_o() | 0xFF000000);
        for (int t = 0; t < 16; ++t) {
            blockState = (BlockState)BlockRepository.water.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(t));
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColorsWithDefaultTint[blockStateID] = waterRGB;
        }
    }

    @Override
    public final int getBlockColorWithDefaultTint(MutableBlockPos blockPos, int blockStateID) {
        if (this.loaded) {
            int col = 0x1B000000;
            try {
                col = this.blockColorsWithDefaultTint[blockStateID];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (col != -16842497 && col != 0x1B000000) {
                return col;
            }
            return this.getBlockColor(blockPos, blockStateID);
        }
        return 0;
    }

    @Override
    public final int getBlockColor(MutableBlockPos blockPos, int blockStateID, int biomeID) {
        if (this.loaded) {
            Integer col;
            if (this.optifineInstalled && this.biomeTextureAvailable.contains(blockStateID) && (col = this.blockBiomeSpecificColors.get("" + blockStateID + " " + biomeID)) != null) {
                return col;
            }
            return this.getBlockColor(blockPos, blockStateID);
        }
        return 0;
    }

    private int getBlockColor(int blockStateID) {
        return this.getBlockColor(this.dummyBlockPos, blockStateID);
    }

    private final int getBlockColor(MutableBlockPos blockPos, int blockStateID) {
        int col = 0x1B000000;
        try {
            col = this.blockColors[blockStateID];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.resizeColorArrays(blockStateID);
        }
        if (col == -16842497 || col == 0x1B000000) {
            BlockState blockState = BlockRepository.getStateById(blockStateID);
            col = this.blockColors[blockStateID] = this.getColor(blockPos, blockState);
        }
        return col;
    }

    private synchronized void resizeColorArrays(int queriedID) {
        if (queriedID >= this.blockColors.length) {
            int[] newBlockColors = new int[this.blockColors.length * 2];
            int[] newBlockColorsWithDefaultTint = new int[this.blockColors.length * 2];
            System.arraycopy(this.blockColors, 0, newBlockColors, 0, this.blockColors.length);
            System.arraycopy(this.blockColorsWithDefaultTint, 0, newBlockColorsWithDefaultTint, 0, this.blockColorsWithDefaultTint.length);
            Arrays.fill(newBlockColors, this.blockColors.length, newBlockColors.length, -16842497);
            Arrays.fill(newBlockColorsWithDefaultTint, this.blockColorsWithDefaultTint.length, newBlockColorsWithDefaultTint.length, -16842497);
            this.blockColors = newBlockColors;
            this.blockColorsWithDefaultTint = newBlockColorsWithDefaultTint;
        }
    }

    private int getColor(MutableBlockPos blockPos, BlockState blockState) {
        try {
            Block block;
            int color = this.getColorForBlockPosBlockStateAndFacing(blockPos, blockState, Direction.UP);
            if (color == this.COLOR_FAILED_LOAD) {
                BlockRendererDispatcher blockRendererDispatcher = this.game.func_175602_ab();
                color = this.getColorForTerrainSprite(blockState, blockRendererDispatcher);
            }
            if ((block = blockState.func_177230_c()) == BlockRepository.cobweb) {
                color |= 0xFF000000;
            }
            if (block == BlockRepository.redstone) {
                color = ColorUtils.colorMultiplier(color, this.game.func_184125_al().func_228054_a_(blockState, (IBlockDisplayReader)null, (BlockPos)null, 0) | 0xFF000000);
            }
            if (BlockRepository.biomeBlocks.contains(block)) {
                this.applyDefaultBuiltInShading(blockState, color);
            } else {
                this.checkForBiomeTinting(blockPos, blockState, color);
            }
            if (BlockRepository.shapedBlocks.contains(block)) {
                color = this.applyShape(block, color);
            }
            if ((color >> 24 & 0xFF) < 27) {
                color |= 0x1B000000;
            }
            return color;
        }
        catch (Exception e) {
            System.err.println("failed getting color: " + blockState.func_177230_c().func_235333_g_().getString());
            e.printStackTrace();
            return 0x1B000000;
        }
    }

    private int getColorForBlockPosBlockStateAndFacing(BlockPos blockPos, BlockState blockState, Direction facing) {
        int color = this.COLOR_FAILED_LOAD;
        try {
            BlockRenderType blockRenderType = blockState.func_185901_i();
            BlockRendererDispatcher blockRendererDispatcher = this.game.func_175602_ab();
            if (blockRenderType == BlockRenderType.MODEL) {
                BufferedImage modelImage;
                IBakedModel iBakedModel = blockRendererDispatcher.func_184389_a(blockState);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                quads.addAll(iBakedModel.func_200117_a(blockState, facing, this.random));
                quads.addAll(iBakedModel.func_200117_a(blockState, null, this.random));
                BlockModel model = new BlockModel(quads, this.failedToLoadX, this.failedToLoadY);
                if (model.numberOfFaces() > 0 && (modelImage = model.getImage(this.terrainBuff)) != null) {
                    color = this.getColorForCoordinatesAndImage(new float[]{0.0f, 1.0f, 0.0f, 1.0f}, modelImage);
                }
            }
        }
        catch (Exception e) {
            color = this.COLOR_FAILED_LOAD;
        }
        return color;
    }

    private int getColorForTerrainSprite(BlockState blockState, BlockRendererDispatcher blockRendererDispatcher) {
        int color = this.COLOR_FAILED_LOAD;
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite icon = blockModelShapes.func_178122_a(blockState);
        if (icon == blockModelShapes.func_178126_b().func_174951_a().func_177554_e()) {
            Block block = blockState.func_177230_c();
            Material material = blockState.func_185904_a();
            if (block instanceof FlowingFluidBlock) {
                if (material == Material.field_151586_h) {
                    icon = (TextureAtlasSprite)this.game.func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft:blocks/water_flow"));
                } else if (material == Material.field_151587_i) {
                    icon = (TextureAtlasSprite)this.game.func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft:blocks/lava_flow"));
                }
            } else if (material == Material.field_151586_h) {
                icon = (TextureAtlasSprite)this.game.func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft:blocks/water_still"));
            } else if (material == Material.field_151587_i) {
                icon = (TextureAtlasSprite)this.game.func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft:blocks/lava_still"));
            }
        }
        color = this.getColorForIcon(icon);
        return color;
    }

    private int getColorForIcon(TextureAtlasSprite icon) {
        int color = this.COLOR_FAILED_LOAD;
        if (icon != null) {
            float left = icon.func_94209_e();
            float right = icon.func_94212_f();
            float top = icon.func_94206_g();
            float bottom = icon.func_94210_h();
            color = this.getColorForCoordinatesAndImage(new float[]{left, right, top, bottom}, this.terrainBuff);
        }
        return color;
    }

    private int getColorForCoordinatesAndImage(float[] uv, BufferedImage imageBuff) {
        int color = 0x1B000000;
        if (uv[0] != this.failedToLoadX || uv[2] != this.failedToLoadY) {
            int left = (int)(uv[0] * (float)imageBuff.getWidth());
            int right = (int)Math.ceil(uv[1] * (float)imageBuff.getWidth());
            int top = (int)(uv[2] * (float)imageBuff.getHeight());
            int bottom = (int)Math.ceil(uv[3] * (float)imageBuff.getHeight());
            try {
                BufferedImage blockTexture = imageBuff.getSubimage(left, top, right - left, bottom - top);
                Image singlePixel = blockTexture.getScaledInstance(1, 1, 4);
                BufferedImage singlePixelBuff = new BufferedImage(1, 1, imageBuff.getType());
                Graphics2D gfx = singlePixelBuff.createGraphics();
                gfx.drawImage(singlePixel, 0, 0, null);
                gfx.dispose();
                color = singlePixelBuff.getRGB(0, 0);
            }
            catch (RasterFormatException e) {
                System.out.println("error getting color");
                System.out.println(left + " " + right + " " + top + " " + bottom);
                color = 0x1B000000;
            }
        }
        return color;
    }

    private void applyDefaultBuiltInShading(BlockState blockState, int color) {
        Block block = blockState.func_177230_c();
        int blockStateID = BlockRepository.getStateId(blockState);
        this.blockColorsWithDefaultTint[blockStateID] = block == BlockRepository.largeFern || block == BlockRepository.tallGrass || block == BlockRepository.reeds ? ColorUtils.colorMultiplier(color, GrassColors.func_77480_a((double)0.7, (double)0.8) | 0xFF000000) : ColorUtils.colorMultiplier(color, this.game.func_184125_al().func_228054_a_(blockState, (IBlockDisplayReader)null, (BlockPos)null, 0) | 0xFF000000);
    }

    private void checkForBiomeTinting(MutableBlockPos blockPos, BlockState blockState, int color) {
        Block block = blockState.func_177230_c();
        String blockName = "" + Registry.field_212618_g.func_177774_c((Object)block);
        if (!BlockRepository.biomeBlocks.contains(block) && !blockName.startsWith("minecraft:")) {
            IChunk chunk;
            int tint = -1;
            MutableBlockPos tempBlockPos = new MutableBlockPos(0, 0, 0);
            tint = blockPos == this.dummyBlockPos ? this.tintFromFakePlacedBlock(blockState, tempBlockPos, (byte)4) : ((chunk = this.game.field_71441_e.func_217349_x((BlockPos)blockPos)) != null && !((Chunk)chunk).func_76621_g() && this.game.field_71441_e.func_217354_b(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4) ? this.game.func_184125_al().func_228054_a_(blockState, (IBlockDisplayReader)this.game.field_71441_e, (BlockPos)blockPos, 1) | 0xFF000000 : this.tintFromFakePlacedBlock(blockState, tempBlockPos, (byte)4));
            if (tint != 0xFFFFFF && tint != -1) {
                int blockStateID = BlockRepository.getStateId(blockState);
                this.biomeTintsAvailable.add(blockStateID);
                this.blockColorsWithDefaultTint[blockStateID] = ColorUtils.colorMultiplier(color, tint);
                this.createTintTable(blockState, tempBlockPos);
            } else {
                this.blockColorsWithDefaultTint[BlockRepository.getStateId((BlockState)blockState)] = 0x1B000000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tintFromFakePlacedBlock(BlockState blockState, MutableBlockPos loopBlockPos, byte biomeID) {
        ClientWorld world = this.game.field_71441_e;
        if (world == null) {
            return -1;
        }
        if (blockState.func_177230_c() == null) {
            return -1;
        }
        Share.updateCloudsLock.lock();
        int tint = -1;
        try {
            int fakeX = (int)this.game.field_71439_g.func_226277_ct_() - 32;
            int fakeZ = (int)this.game.field_71439_g.func_226281_cx_() - 32;
            IChunk chunk = world.func_217349_x((BlockPos)loopBlockPos.withXYZ(fakeX, 0, fakeZ));
            BlockState actualBlockState = world.func_180495_p((BlockPos)loopBlockPos);
            chunk.func_177436_a((BlockPos)loopBlockPos, blockState, false);
            BiomeContainer biomeArray = chunk.func_225549_i_();
            Object[] currentBiomes = (Biome[])ReflectionUtils.getPrivateFieldValueByType(biomeArray, BiomeContainer.class, Biome[].class);
            Biome[] originalBiomes = new Biome[currentBiomes.length];
            System.arraycopy(currentBiomes, 0, originalBiomes, 0, currentBiomes.length);
            Arrays.fill(currentBiomes, WorldGenRegistries.field_243657_i.func_148745_a((int)biomeID));
            tint = this.game.func_184125_al().func_228054_a_(blockState, (IBlockDisplayReader)world, (BlockPos)loopBlockPos, 1) | 0xFF000000;
            System.arraycopy(originalBiomes, 0, currentBiomes, 0, currentBiomes.length);
            chunk.func_177436_a((BlockPos)loopBlockPos, actualBlockState, false);
        }
        catch (Exception exception) {
        }
        finally {
            Share.updateCloudsLock.unlock();
        }
        return tint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTintTable(BlockState blockState, MutableBlockPos loopBlockPos) {
        ClientWorld world = this.game.field_71441_e;
        if (world == null) {
            return;
        }
        Block block = blockState.func_177230_c();
        if (block == null) {
            return;
        }
        Share.updateCloudsLock.lock();
        try {
            int[][] tints;
            for (int[] row : tints = new int[this.sizeOfBiomeArray][32]) {
                Arrays.fill(row, -1);
            }
            int fakeX = (int)this.game.field_71439_g.func_226277_ct_() - 32;
            int fakeZ = (int)this.game.field_71439_g.func_226281_cx_() - 32;
            IChunk chunk = world.func_217349_x((BlockPos)loopBlockPos.withXYZ(fakeX, 0, fakeZ));
            BlockState actualBlockState = world.func_180495_p((BlockPos)loopBlockPos);
            chunk.func_177436_a((BlockPos)loopBlockPos, blockState, false);
            BiomeContainer biomeArray = chunk.func_225549_i_();
            Object[] currentBiomes = (Biome[])ReflectionUtils.getPrivateFieldValueByType(biomeArray, BiomeContainer.class, Biome[].class);
            Biome[] originalBiomes = new Biome[currentBiomes.length];
            System.arraycopy(currentBiomes, 0, originalBiomes, 0, currentBiomes.length);
            for (int biomeID = 0; biomeID < this.sizeOfBiomeArray; ++biomeID) {
                Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_148745_a(biomeID);
                if (biome == null) continue;
                int[] row = new int[32];
                Arrays.fill(currentBiomes, biome);
                Arrays.fill(row, this.game.func_184125_al().func_228054_a_(blockState, (IBlockDisplayReader)world, (BlockPos)loopBlockPos, 1) | 0xFF000000);
                tints[biomeID] = row;
            }
            System.arraycopy(originalBiomes, 0, currentBiomes, 0, currentBiomes.length);
            chunk.func_177436_a((BlockPos)loopBlockPos, actualBlockState, false);
            int blockStateID = BlockRepository.getStateId(blockState);
            this.blockTintTables.put(blockStateID, tints);
        }
        catch (Exception exception) {
        }
        finally {
            Share.updateCloudsLock.unlock();
        }
    }

    @Override
    public int getBiomeTint(AbstractMapData mapData, World world, BlockState blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        IChunk chunk = world.func_217349_x((BlockPos)blockPos);
        boolean live = chunk != null && !((Chunk)chunk).func_76621_g() && this.game.field_71441_e.func_217354_b(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        int tint = -2;
        if (this.optifineInstalled || !live && this.biomeTintsAvailable.contains(blockStateID)) {
            try {
                int[][] tints = this.blockTintTables.get(blockStateID);
                if (tints != null) {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    for (int t = blockPos.func_177958_n() - 1; t <= blockPos.func_177958_n() + 1; ++t) {
                        for (int s = blockPos.func_177952_p() - 1; s <= blockPos.func_177952_p() + 1; ++s) {
                            int biomeID = 0;
                            if (live) {
                                biomeID = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_148757_b((Object)world.func_226691_t_((BlockPos)loopBlockPos.withXYZ(t, blockPos.func_177956_o(), s)));
                            } else {
                                int dataX = t - startX;
                                int dataZ = s - startZ;
                                dataX = Math.max(dataX, 0);
                                dataX = Math.min(dataX, mapData.getWidth() - 1);
                                dataZ = Math.max(dataZ, 0);
                                biomeID = mapData.getBiomeID(dataX, dataZ = Math.min(dataZ, mapData.getHeight() - 1));
                                if (biomeID == -1) {
                                    biomeID = 1;
                                }
                            }
                            int biomeTint = tints[biomeID][loopBlockPos.field_177960_b / 8];
                            r += (biomeTint & 0xFF0000) >> 16;
                            g += (biomeTint & 0xFF00) >> 8;
                            b += biomeTint & 0xFF;
                        }
                    }
                    tint = 0xFF000000 | (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
                }
            }
            catch (Exception e) {
                tint = -2;
            }
        }
        if (tint == -2) {
            tint = this.getBuiltInBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ, live);
        }
        return tint;
    }

    private int getBuiltInBiomeTint(AbstractMapData mapData, World world, BlockState blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ, boolean live) {
        int tint = -1;
        Block block = blockState.func_177230_c();
        if (block == BlockRepository.redstone || BlockRepository.biomeBlocks.contains(block) || this.biomeTintsAvailable.contains(blockStateID)) {
            tint = !live ? this.getBuiltInBiomeTintFromUnloadedChunk(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ) | 0xFF000000 : this.game.func_184125_al().func_228054_a_(blockState, (IBlockDisplayReader)world, (BlockPos)blockPos, 1) | 0xFF000000;
        }
        return tint;
    }

    private int getBuiltInBiomeTintFromUnloadedChunk(AbstractMapData mapData, World world, BlockState blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        int tint = -1;
        Block block = blockState.func_177230_c();
        ColorResolver colorResolver = null;
        if (block == BlockRepository.water) {
            colorResolver = this.waterColorResolver;
        } else if (block == BlockRepository.spruceLeaves) {
            colorResolver = this.spruceColorResolver;
        } else if (block == BlockRepository.birchLeaves) {
            colorResolver = this.birchColorResolver;
        } else if (block == BlockRepository.oakLeaves || block == BlockRepository.jungleLeaves || block == BlockRepository.acaciaLeaves || block == BlockRepository.darkOakLeaves || block == BlockRepository.vine) {
            colorResolver = this.foliageColorResolver;
        } else if (BlockRepository.biomeBlocks.contains(block)) {
            colorResolver = this.grassColorResolver;
        }
        if (colorResolver != null) {
            int var3 = 0;
            int var4 = 0;
            int var5 = 0;
            for (int t = blockPos.func_177958_n() - 1; t <= blockPos.func_177958_n() + 1; ++t) {
                for (int s = blockPos.func_177952_p() - 1; s <= blockPos.func_177952_p() + 1; ++s) {
                    int dataX = t - startX;
                    int dataZ = s - startZ;
                    dataX = Math.max(dataX, 0);
                    dataX = Math.min(dataX, 255);
                    dataZ = Math.max(dataZ, 0);
                    int biomeID = mapData.getBiomeID(dataX, dataZ = Math.min(dataZ, 255));
                    Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_148745_a(biomeID);
                    if (biome == null) {
                        MessageUtils.printDebug("Null biome ID! " + biomeID + " at " + t + "," + s);
                        MessageUtils.printDebug("block: " + mapData.getBlockstate(dataX, dataZ) + ", height: " + mapData.getHeight(dataX, dataZ));
                        MessageUtils.printDebug("Mapdata: " + mapData.toString());
                        biome = BiomeRepository.FOREST;
                    }
                    int var8 = colorResolver.getColorAtPos(biome, loopBlockPos.withXYZ(t, blockPos.func_177956_o(), s));
                    var3 += (var8 & 0xFF0000) >> 16;
                    var4 += (var8 & 0xFF00) >> 8;
                    var5 += var8 & 0xFF;
                }
            }
            tint = (var3 / 9 & 0xFF) << 16 | (var4 / 9 & 0xFF) << 8 | var5 / 9 & 0xFF;
        } else if (this.biomeTintsAvailable.contains(blockStateID)) {
            tint = this.getCustomBlockBiomeTintFromUnloadedChunk(mapData, world, blockState, blockPos, loopBlockPos, startX, startZ);
        }
        return tint;
    }

    private int getCustomBlockBiomeTintFromUnloadedChunk(AbstractMapData mapData, World world, BlockState blockState, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        int tint = -1;
        try {
            int dataX = blockPos.func_177958_n() - startX;
            int dataZ = blockPos.func_177952_p() - startZ;
            dataX = Math.max(dataX, 0);
            dataX = Math.min(dataX, mapData.getWidth() - 1);
            dataZ = Math.max(dataZ, 0);
            dataZ = Math.min(dataZ, mapData.getHeight() - 1);
            byte biomeID = (byte)mapData.getBiomeID(dataX, dataZ);
            tint = this.tintFromFakePlacedBlock(blockState, loopBlockPos, biomeID);
        }
        catch (Exception e) {
            tint = -1;
        }
        return tint;
    }

    private int applyShape(Block block, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color >> 0 & 0xFF;
        if (block instanceof AbstractSignBlock) {
            alpha = 31;
        } else if (block instanceof DoorBlock) {
            alpha = 47;
        } else if (block == BlockRepository.ladder || block == BlockRepository.vine) {
            alpha = 15;
        }
        color = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return color;
    }

    private void processCTM() {
        this.renderPassThreeBlendMode = "alpha";
        Properties properties = new Properties();
        ResourceLocation propertiesFile = new ResourceLocation("minecraft", "optifine/renderpass.properties");
        try {
            InputStream input = this.game.func_195551_G().func_199002_a(propertiesFile).func_199027_b();
            if (input != null) {
                properties.load(input);
                input.close();
                this.renderPassThreeBlendMode = properties.getProperty("blend.3", "alpha");
            }
        }
        catch (IOException e) {
            this.renderPassThreeBlendMode = "alpha";
        }
        String namespace = "minecraft";
        for (ResourceLocation s : this.findResources(namespace, "/optifine/ctm", ".properties", true, false, true)) {
            try {
                this.loadCTM(s);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (int t = 0; t < this.blockColors.length; ++t) {
            if (this.blockColors[t] == this.COLOR_FAILED_LOAD || this.blockColors[t] == this.COLOR_NOT_LOADED) continue;
            if ((this.blockColors[t] >> 24 & 0xFF) < 27) {
                this.blockColors[t] = this.blockColors[t] | 0x1B000000;
            }
            this.checkForBiomeTinting(this.dummyBlockPos, BlockRepository.getStateById(t), this.blockColors[t]);
        }
    }

    private void loadCTM(ResourceLocation propertiesFile) {
        if (propertiesFile == null) {
            return;
        }
        BlockRendererDispatcher blockRendererDispatcher = this.game.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        Properties properties = new Properties();
        try {
            InputStream input = this.game.func_195551_G().func_199002_a(propertiesFile).func_199027_b();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException e) {
            return;
        }
        String filePath = propertiesFile.func_110623_a();
        String method = properties.getProperty("method", "").trim().toLowerCase();
        String faces = properties.getProperty("faces", "").trim().toLowerCase();
        String matchBlocks = properties.getProperty("matchBlocks", "").trim().toLowerCase();
        String matchTiles = properties.getProperty("matchTiles", "").trim().toLowerCase();
        String metadata = properties.getProperty("metadata", "").trim().toLowerCase();
        String tiles = properties.getProperty("tiles", "").trim();
        String biomes = properties.getProperty("biomes", "").trim().toLowerCase();
        String renderPass = properties.getProperty("renderPass", "").trim().toLowerCase();
        metadata = metadata.replaceAll("\\s+", ",");
        HashSet<Object> blockStates = new HashSet<Object>();
        blockStates.addAll(this.parseBlocksList(matchBlocks, metadata));
        String directory = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        String[] tilesParsed = this.parseStringList(tiles);
        String tilePath = directory + "0";
        if (tilesParsed.length > 0) {
            tilePath = tilesParsed[0].trim();
        }
        if (tilePath.startsWith("~")) {
            tilePath = tilePath.replace("~", "optifine");
        } else if (!tilePath.contains("/")) {
            tilePath = directory + tilePath;
        }
        if (!tilePath.toLowerCase().endsWith(".png")) {
            tilePath = tilePath + ".png";
        }
        String[] biomesArray = biomes.split(" ");
        if (blockStates.size() == 0) {
            Block block = null;
            Pattern pattern = Pattern.compile(".*/block_(.+).properties");
            Matcher matcher = pattern.matcher(filePath);
            if (matcher.find()) {
                block = this.getBlockFromName(matcher.group(1));
                if (block != null) {
                    Set<BlockState> matching = this.parseBlockMetadata(block, metadata);
                    if (matching.size() == 0) {
                        matching.addAll((Collection<BlockState>)block.func_176194_O().func_177619_a());
                    }
                    blockStates.addAll(matching);
                }
            } else {
                if (matchTiles.equals("")) {
                    matchTiles = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf(".properties"));
                }
                if (!matchTiles.contains(":")) {
                    matchTiles = "minecraft:blocks/" + matchTiles;
                }
                ResourceLocation matchID = new ResourceLocation(matchTiles);
                TextureAtlasSprite compareIcon = (TextureAtlasSprite)this.game.func_228015_a_(AtlasTexture.field_110575_b).apply(matchID);
                if (compareIcon.func_195668_m() != MissingTextureSprite.func_195675_b()) {
                    ArrayList<BlockState> tmpList = new ArrayList<BlockState>();
                    for (Block block2 : Registry.field_212618_g) {
                        for (BlockState blockState : block2.func_176194_O().func_177619_a()) {
                            try {
                                IBakedModel bakedModel = blockModelShapes.func_178125_b(blockState);
                                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                                quads.addAll(bakedModel.func_200117_a(blockState, Direction.UP, this.random));
                                quads.addAll(bakedModel.func_200117_a(blockState, null, this.random));
                                BlockModel model = new BlockModel(quads, this.failedToLoadX, this.failedToLoadY);
                                if (model.numberOfFaces() <= 0) continue;
                                ArrayList<BlockModel.BlockFace> blockFaces = model.getFaces();
                                for (int i = 0; i < blockFaces.size(); ++i) {
                                    float maxV;
                                    float minV;
                                    float maxU;
                                    BlockModel.BlockFace face = model.getFaces().get(i);
                                    float minU = face.getMinU();
                                    if (!this.similarEnough(minU, maxU = face.getMaxU(), minV = face.getMinV(), maxV = face.getMaxV(), compareIcon.func_94209_e(), compareIcon.func_94212_f(), compareIcon.func_94206_g(), compareIcon.func_94210_h())) continue;
                                    tmpList.add(blockState);
                                }
                            }
                            catch (Exception bakedModel) {
                            }
                        }
                    }
                    blockStates.addAll(tmpList);
                }
            }
        }
        if (blockStates.size() == 0) {
            return;
        }
        if (!method.equals("horizontal") && !method.startsWith("overlay") && (method.equals("sandstone") || method.equals("top") || faces.contains("top") || faces.contains("all") || faces.length() == 0)) {
            try {
                ResourceLocation pngResource = new ResourceLocation(propertiesFile.func_110624_b(), tilePath);
                InputStream is = this.game.func_195551_G().func_199002_a(pngResource).func_199027_b();
                Image top = ImageIO.read(is);
                is.close();
                top = top.getScaledInstance(1, 1, 4);
                BufferedImage topBuff = new BufferedImage(top.getWidth(null), top.getHeight(null), 6);
                Graphics2D gfx = topBuff.createGraphics();
                gfx.drawImage(top, 0, 0, null);
                gfx.dispose();
                int topRGB = topBuff.getRGB(0, 0);
                if ((topRGB >> 24 & 0xFF) == 0) {
                    return;
                }
                for (BlockState blockState : blockStates) {
                    int blockStateID;
                    topRGB = topBuff.getRGB(0, 0);
                    if (blockState.func_177230_c() == BlockRepository.cobweb) {
                        topRGB |= 0xFF000000;
                    }
                    if (renderPass.equals("3")) {
                        topRGB = this.processRenderPassThree(topRGB);
                        blockStateID = BlockRepository.getStateId(blockState);
                        int baseRGB = this.blockColors[blockStateID];
                        if (baseRGB != this.COLOR_FAILED_LOAD && baseRGB != this.COLOR_NOT_LOADED) {
                            topRGB = ColorUtils.colorMultiplier(baseRGB, topRGB);
                        }
                    }
                    if (BlockRepository.shapedBlocks.contains(blockState.func_177230_c())) {
                        topRGB = this.applyShape(blockState.func_177230_c(), topRGB);
                    }
                    blockStateID = BlockRepository.getStateId(blockState);
                    if (!biomes.equals("")) {
                        this.biomeTextureAvailable.add(blockStateID);
                        for (int r = 0; r < biomesArray.length; ++r) {
                            int biomeInt = this.parseBiomeName(biomesArray[r]);
                            if (biomeInt == -1) continue;
                            this.blockBiomeSpecificColors.put("" + blockStateID + " " + biomeInt, topRGB);
                        }
                        continue;
                    }
                    this.blockColors[blockStateID] = topRGB;
                }
            }
            catch (IOException e) {
                System.err.println("error getting CTM block from " + propertiesFile.func_110623_a() + ": " + filePath + " " + Registry.field_212618_g.func_177774_c((Object)((BlockState)blockStates.iterator().next()).func_177230_c()).toString() + " " + tilePath);
                e.printStackTrace();
            }
        }
    }

    private boolean similarEnough(float a, float b, float c, float d, float one, float two, float three, float four) {
        boolean similar = (double)Math.abs(a - one) < 1.0E-4;
        similar = similar && (double)Math.abs(b - two) < 1.0E-4;
        similar = similar && (double)Math.abs(c - three) < 1.0E-4;
        similar = similar && (double)Math.abs(d - four) < 1.0E-4;
        return similar;
    }

    private int processRenderPassThree(int rgb) {
        if (this.renderPassThreeBlendMode.equals("color") || this.renderPassThreeBlendMode.equals("overlay")) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb >> 0 & 0xFF;
            float colorAverage = (float)(red + blue + green) / 3.0f;
            float lighteningFactor = (colorAverage - 127.5f) * 2.0f;
            red += (int)((float)red * (lighteningFactor / 255.0f));
            int newAlpha = (int)Math.abs(lighteningFactor);
            rgb = newAlpha << 24 | (red & 0xFF) << 16 | ((green += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF) << 8 | (blue += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF;
        }
        return rgb;
    }

    private String[] parseStringList(String list) {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (String token : list.split("\\s+")) {
            token = token.trim();
            try {
                if (token.matches("^\\d+$")) {
                    tmpList.add("" + Integer.parseInt(token));
                    continue;
                }
                if (token.matches("^\\d+-\\d+$")) {
                    String[] t = token.split("-");
                    int min = Integer.parseInt(t[0]);
                    int max = Integer.parseInt(t[1]);
                    for (int i = min; i <= max; ++i) {
                        tmpList.add("" + i);
                    }
                    continue;
                }
                if (token == null || token == "") continue;
                tmpList.add(token);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String[] a = new String[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (String)tmpList.get(i);
        }
        return a;
    }

    private Set<BlockState> parseBlocksList(String blocks, String metadataLine) {
        HashSet<BlockState> blockStates = new HashSet<BlockState>();
        for (String blockString : blocks.split("\\s+")) {
            String metadata = metadataLine;
            blockString = blockString.trim();
            String[] blockComponents = blockString.split(":");
            int tokensUsed = 0;
            Block block = null;
            block = this.getBlockFromName(blockComponents[0]);
            if (block != null) {
                tokensUsed = 1;
            } else if (blockComponents.length > 1 && (block = this.getBlockFromName(blockComponents[0] + ":" + blockComponents[1])) != null) {
                tokensUsed = 2;
            }
            if (block == null) continue;
            if (blockComponents.length > tokensUsed) {
                metadata = blockComponents[tokensUsed];
                for (int t = tokensUsed + 1; t < blockComponents.length; ++t) {
                    metadata = metadata + ":" + blockComponents[t];
                }
            }
            blockStates.addAll(this.parseBlockMetadata(block, metadata));
        }
        return blockStates;
    }

    private <T extends Comparable<T>, V extends T> Set<BlockState> parseBlockMetadata(Block block, String metadataList) {
        HashSet<BlockState> blockStates = new HashSet<BlockState>();
        if (metadataList.equals("")) {
            blockStates.addAll((Collection<BlockState>)block.func_176194_O().func_177619_a());
        } else {
            HashSet<String> valuePairs = new HashSet<String>();
            for (String metadata : metadataList.split(":")) {
                metadata.trim();
                if (!metadata.contains("=")) continue;
                valuePairs.add(metadata);
            }
            if (valuePairs.size() > 0) {
                for (BlockState blockState : block.func_176194_O().func_177619_a()) {
                    boolean matches = true;
                    for (String pair : valuePairs) {
                        String[] values;
                        Property property;
                        String[] propertyAndValues = pair.split("\\s*=\\s*", 5);
                        if (propertyAndValues.length != 2 || (property = block.func_176194_O().func_185920_a(propertyAndValues[0])) == null) continue;
                        boolean valueIncluded = false;
                        for (String value : values = propertyAndValues[1].split(",")) {
                            if (property.func_177699_b() == Integer.class && value.matches("^\\d+-\\d+$")) {
                                String[] range = value.split("-");
                                int min = Integer.parseInt(range[0]);
                                int max = Integer.parseInt(range[1]);
                                int intValue = (Integer)Integer.class.cast(blockState.func_177229_b(property));
                                if (intValue < min || intValue > max) continue;
                                valueIncluded = true;
                                continue;
                            }
                            if (blockState.func_177229_b(property).equals(property.func_185929_b(value))) continue;
                            valueIncluded = true;
                        }
                        matches = matches && valueIncluded;
                    }
                    if (!matches) continue;
                    blockStates.add(blockState);
                }
            }
        }
        return blockStates;
    }

    private int parseBiomeName(String name) {
        Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_82594_a(new ResourceLocation(name));
        if (biome != null) {
            return WorldGenRegistries.field_243657_i.func_148757_b((Object)biome);
        }
        return -1;
    }

    private List<ResourceLocation> findResources(String namespace, String directory, String suffixMaybeNull, boolean recursive, boolean directories, boolean sortByFilename) {
        if (directory == null) {
            directory = "";
        }
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        String suffix = suffixMaybeNull == null ? "" : suffixMaybeNull;
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        Collection candidates = this.game.func_195551_G().func_199003_a(directory, asset -> asset.endsWith(suffix));
        for (ResourceLocation candidate : candidates) {
            if (!candidate.func_110624_b().equals(namespace)) continue;
            resources.add(candidate);
        }
        if (sortByFilename) {
            Collections.sort(resources, new Comparator<ResourceLocation>(){

                @Override
                public int compare(ResourceLocation o1, ResourceLocation o2) {
                    String f2;
                    String f1 = o1.func_110623_a().replaceAll(".*/", "").replaceFirst("\\.properties", "");
                    int result = f1.compareTo(f2 = o2.func_110623_a().replaceAll(".*/", "").replaceFirst("\\.properties", ""));
                    if (result != 0) {
                        return result;
                    }
                    return o1.func_110623_a().compareTo(o2.func_110623_a());
                }
            });
        } else {
            Collections.sort(resources, new Comparator<ResourceLocation>(){

                @Override
                public int compare(ResourceLocation o1, ResourceLocation o2) {
                    return o1.func_110623_a().compareTo(o2.func_110623_a());
                }
            });
        }
        return resources;
    }

    private void processColorProperties() {
        Properties properties = new Properties();
        try {
            InputStream input = this.game.func_195551_G().func_199002_a(new ResourceLocation("optifine/color.properties")).func_199027_b();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException input) {
            // empty catch block
        }
        BlockState blockState = BlockRepository.lilypad.func_176223_P();
        int blockStateID = BlockRepository.getStateId(blockState);
        int lilyRGB = this.getBlockColor(blockStateID);
        int lilypadMultiplier = 2129968;
        String lilypadMultiplierString = properties.getProperty("lilypad");
        if (lilypadMultiplierString != null) {
            lilypadMultiplier = Integer.parseInt(lilypadMultiplierString, 16);
        }
        for (BlockState padBlockState : BlockRepository.lilypad.func_176194_O().func_177619_a()) {
            blockStateID = BlockRepository.getStateId(padBlockState);
            this.blockColors[blockStateID] = ColorUtils.colorMultiplier(lilyRGB, lilypadMultiplier | 0xFF000000);
            this.blockColorsWithDefaultTint[blockStateID] = this.blockColors[blockStateID];
        }
        String defaultFormat = properties.getProperty("palette.format");
        boolean globalGrid = defaultFormat != null && defaultFormat.equalsIgnoreCase("grid");
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("palette.block")) continue;
            String filename = key.substring("palette.block.".length());
            filename = filename.replace("~", "optifine");
            this.processColorPropertyHelper(new ResourceLocation(filename), properties.getProperty(key), globalGrid);
        }
        for (ResourceLocation resource : this.findResources("minecraft", "/optifine/colormap/blocks", ".properties", true, false, true)) {
            String format;
            ResourceLocation resourcePNG;
            String source;
            Properties colorProperties;
            block15: {
                colorProperties = new Properties();
                try {
                    InputStream input = this.game.func_195551_G().func_199002_a(resource).func_199027_b();
                    if (input == null) break block15;
                    colorProperties.load(input);
                    input.close();
                }
                catch (IOException e2) {
                    break;
                }
            }
            String names = colorProperties.getProperty("blocks");
            if (names == null) {
                String name = resource.func_110623_a();
                names = name = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf(".properties"));
            }
            if ((source = colorProperties.getProperty("source")) != null) {
                resourcePNG = new ResourceLocation(resource.func_110624_b(), source);
                try {
                    this.game.func_195551_G().func_199002_a(resourcePNG);
                }
                catch (IOException e3) {
                    Path path = Paths.get("optifine/colormap/blocks/", source);
                    path = path.normalize();
                    resourcePNG = new ResourceLocation(resource.func_110624_b(), path.toString().replace(File.separatorChar, '/'));
                    System.out.println("trying " + resourcePNG.toString());
                }
            } else {
                resourcePNG = new ResourceLocation(resource.func_110624_b(), resource.func_110623_a().replace(".properties", ".png"));
            }
            boolean grid = (format = colorProperties.getProperty("format")) != null ? format != null && format.equalsIgnoreCase("grid") : globalGrid;
            String yOffsetString = colorProperties.getProperty("yOffset");
            int yOffset = 0;
            if (yOffsetString != null) {
                yOffset = Integer.valueOf(yOffsetString);
            }
            this.processColorProperty(resourcePNG, names, grid, yOffset);
        }
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/water.png"), "water", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/watercolorx.png"), "water", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/swampgrass.png"), "grass_block grass fern tall_grass large_fern", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/swampgrasscolor.png"), "grass_block grass fern tall_grass large_fern", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/swampfoliage.png"), "oak_leaves vine", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/swampfoliagecolor.png"), "oak_leaves vine", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/pine.png"), "spruce_leaves", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/pinecolor.png"), "spruce_leaves", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/birch.png"), "birch_leaves", globalGrid);
        this.processColorPropertyHelper(new ResourceLocation("optifine/colormap/birchcolor.png"), "birch_leaves", globalGrid);
    }

    private void processColorPropertyHelper(ResourceLocation resource, String list, boolean grid) {
        ResourceLocation resourceProperties = new ResourceLocation(resource.func_110624_b(), resource.func_110623_a().replace(".png", ".properties"));
        Properties colorProperties = new Properties();
        int yOffset = 0;
        try {
            String yOffsetString;
            String format;
            InputStream input = this.game.func_195551_G().func_199002_a(resourceProperties).func_199027_b();
            if (input != null) {
                colorProperties.load(input);
                input.close();
            }
            if ((format = colorProperties.getProperty("format")) != null) {
                grid = format.equalsIgnoreCase("grid");
            }
            if ((yOffsetString = colorProperties.getProperty("yOffset")) != null) {
                yOffset = Integer.valueOf(yOffsetString);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.processColorProperty(resource, list, grid, yOffset);
    }

    private void processColorProperty(ResourceLocation resource, String list, boolean grid, int yOffset) {
        int[][] tints;
        for (int[] row : tints = new int[this.sizeOfBiomeArray][32]) {
            Arrays.fill(row, -1);
        }
        boolean swamp = resource.func_110623_a().contains("/swamp");
        BufferedImage tintColors = null;
        try {
            InputStream is = this.game.func_195551_G().func_199002_a(resource).func_199027_b();
            tintColors = ImageIO.read(is);
            is.close();
        }
        catch (IOException e) {
            return;
        }
        BufferedImage tintColorsBuff = new BufferedImage(((Image)tintColors).getWidth(null), ((Image)tintColors).getHeight(null), 1);
        Graphics2D gfx = tintColorsBuff.createGraphics();
        gfx.drawImage((Image)tintColors, 0, 0, null);
        gfx.dispose();
        int numBiomesToCheck = grid ? Math.min(tintColorsBuff.getWidth(), this.sizeOfBiomeArray) : this.sizeOfBiomeArray;
        for (int t = 0; t < numBiomesToCheck; ++t) {
            Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_148745_a(t);
            if (biome == null) continue;
            int tintMult = 0;
            int heightMultiplier = tintColorsBuff.getHeight() / this.BIOME_ARRAY_HEIGHT;
            for (int s = 0; s < 32; ++s) {
                if (grid) {
                    tintMult = tintColorsBuff.getRGB(t, Math.min(Math.max(0, s * heightMultiplier - yOffset), tintColorsBuff.getHeight() - 1)) & 0xFFFFFF;
                } else {
                    double var1 = MathHelper.func_76131_a((float)biome.func_225486_c(new BlockPos(0, 64, 0)), (float)0.0f, (float)1.0f);
                    double var2 = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
                    var2 *= var1;
                    var1 = 1.0 - var1;
                    var2 = 1.0 - var2;
                    tintMult = tintColorsBuff.getRGB((int)((double)(tintColorsBuff.getWidth() - 1) * var1), (int)((double)(tintColorsBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
                }
                if (tintMult == 0 || swamp && biome != BiomeRepository.SWAMP && biome != BiomeRepository.SWAMP_HILLS) continue;
                tints[t][s] = tintMult;
            }
        }
        HashSet<BlockState> blockStates = new HashSet<BlockState>();
        blockStates.addAll(this.parseBlocksList(list, ""));
        for (BlockState blockState : blockStates) {
            int blockStateID = BlockRepository.getStateId(blockState);
            int[][] previousTints = this.blockTintTables.get(blockStateID);
            if (swamp && previousTints == null) {
                ResourceLocation defaultResource = resource.func_110623_a().contains("grass") ? new ResourceLocation("textures/colormap/grass.png") : new ResourceLocation("textures/colormap/foliage.png");
                String stateString = blockState.toString().toLowerCase();
                stateString = stateString.replaceAll("^block", "");
                stateString = stateString.replace("{", "");
                stateString = stateString.replace("}", "");
                stateString = stateString.replace("[", ":");
                stateString = stateString.replace("]", "");
                stateString = stateString.replace(",", ":");
                this.processColorProperty(defaultResource, stateString, false, 0);
                previousTints = this.blockTintTables.get(blockStateID);
            }
            if (previousTints != null) {
                for (int t = 0; t < this.sizeOfBiomeArray; ++t) {
                    for (int s = 0; s < 32; ++s) {
                        if (tints[t][s] != -1) continue;
                        tints[t][s] = previousTints[t][s];
                    }
                }
            }
            this.blockColorsWithDefaultTint[blockStateID] = ColorUtils.colorMultiplier(this.getBlockColor(blockStateID), tints[4][8] | 0xFF000000);
            this.blockTintTables.put(blockStateID, tints);
            this.biomeTintsAvailable.add(blockStateID);
        }
    }

    private Block getBlockFromName(String name) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (Registry.field_212618_g.func_212607_c(resourceLocation)) {
                return (Block)Registry.field_212618_g.func_82594_a(resourceLocation);
            }
            return null;
        }
        catch (ResourceLocationException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static interface ColorResolver {
        public int getColorAtPos(Biome var1, BlockPos var2);
    }
}

