/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.forgemod;

import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.FramebufferConstants;
import net.minecraft.util.Timer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TickHandler {
    private VoxelMap voxelMap;
    private Timer timer = null;

    public TickHandler(VoxelMap voxelMap) {
        this.voxelMap = voxelMap;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.timer == null) {
            this.timer = (Timer)ReflectionUtils.getPrivateFieldValueByType(Minecraft.func_71410_x(), Minecraft.class, Timer.class);
        }
        boolean clock = this.timer.field_194148_c > 0.0f;
        this.voxelMap.onTick(Minecraft.func_71410_x(), clock);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.voxelMap.onTickInGame(event.getMatrixStack(), Minecraft.func_71410_x());
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderWorldLastEvent event) {
        if (VoxelMap.getInstance().getMapOptions().showBeacons || VoxelMap.getInstance().getMapOptions().showWaypoints) {
            if (Minecraft.func_238218_y_()) {
                Framebuffer framebuffer = Minecraft.func_71410_x().func_147110_a();
                Framebuffer translucentFramebuffer = Minecraft.func_71410_x().field_71438_f.func_239228_q_();
                if (GlStateManager.func_237508_S_()) {
                    GlStateManager.func_227727_h_((int)36008, (int)translucentFramebuffer.field_147616_f);
                    GlStateManager.func_227727_h_((int)36009, (int)framebuffer.field_147616_f);
                    GlStateManager.func_237510_a_((int)0, (int)0, (int)translucentFramebuffer.field_147622_a, (int)translucentFramebuffer.field_147620_b, (int)0, (int)0, (int)framebuffer.field_147622_a, (int)framebuffer.field_147620_b, (int)256, (int)9728);
                } else {
                    GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)framebuffer.field_147616_f);
                    int i = GlStateManager.func_237514_p_();
                    if (i != 0) {
                        int j = GlStateManager.func_237515_r_();
                        GlStateManager.func_227760_t_((int)i);
                        GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)translucentFramebuffer.field_147616_f);
                        GlStateManager.func_237509_a_((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Math.min(framebuffer.field_147622_a, translucentFramebuffer.field_147622_a), (int)Math.min(framebuffer.field_147620_b, translucentFramebuffer.field_147620_b));
                        GlStateManager.func_227760_t_((int)j);
                    }
                }
            }
            this.voxelMap.getWaypointManager().renderWaypoints(event.getPartialTicks(), event.getMatrixStack(), VoxelMap.getInstance().getMapOptions().showBeacons, VoxelMap.getInstance().getMapOptions().showWaypoints, true, true);
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.shadeModel((int)7424);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.disableFog();
            RenderSystem.disableLighting();
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        ITextComponent chat = event.getMessage();
        if (!CommandUtils.checkForWaypoints(chat)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSendChatMessage(ClientChatEvent event) {
        String message = event.getMessage();
        if (message.startsWith("/newWaypoint")) {
            CommandUtils.waypointClicked(message);
            event.setCanceled(true);
        } else if (message.startsWith("/ztp")) {
            CommandUtils.teleport(message);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChunkEvent(ChunkEvent event) {
        ChunkPos pos = event.getChunk().func_76632_l();
        this.voxelMap.getWorldUpdateListener().notifyObservers(pos.field_77276_a, pos.field_77275_b, false);
    }

    @SubscribeEvent
    public void onBlockEvent(BlockEvent event) {
        BlockPos pos = event.getPos();
        int chunkX = (int)Math.floor((float)pos.func_177958_n() / 16.0f);
        int chunkZ = (int)Math.floor((float)pos.func_177952_p() / 16.0f);
        for (int x = chunkX - 1; x <= chunkX + 1; ++x) {
            for (int z = chunkZ - 1; z <= chunkZ + 1; ++z) {
                this.voxelMap.getWorldUpdateListener().notifyObservers(x, z, true);
            }
        }
    }
}

