/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiMinimapControls
extends GuiScreenMinimap {
    private Screen parentScreen;
    protected String screenTitle = "Controls";
    private MapSettingsManager options;
    public KeyBinding buttonId = null;

    public GuiMinimapControls(Screen par1GuiScreen, IVoxelMap master) {
        this.parentScreen = par1GuiScreen;
        this.options = master.getMapOptions();
    }

    private int getLeftBorder() {
        return this.getWidth() / 2 - 155;
    }

    public void func_231160_c_() {
        int left = this.getLeftBorder();
        for (int t = 0; t < this.options.keyBindings.length; ++t) {
            int id = t;
            this.func_230480_a_((Widget)new Button(left + t % 2 * 160, this.getHeight() / 6 + 24 * (t >> 1), 70, 20, this.options.getKeybindDisplayString(t), button -> this.controlButtonClicked(id)));
        }
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.getMinecraft().func_147108_a(this.parentScreen)));
        this.screenTitle = I18nUtils.getString("controls.minimap.title", new Object[0]);
    }

    protected void controlButtonClicked(int id) {
        for (int buttonListIndex = 0; buttonListIndex < this.options.keyBindings.length; ++buttonListIndex) {
            ((Button)this.getButtonList().get(buttonListIndex)).func_238482_a_(this.options.getKeybindDisplayString(buttonListIndex));
        }
        this.buttonId = this.options.keyBindings[id];
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.buttonId != null) {
            this.options.setKeyBinding(this.buttonId, InputMappings.Type.MOUSE.func_197944_a(mouseButton));
            this.buttonId = null;
            KeyBinding.func_74508_b();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int keysm, int scancode, int b) {
        if (this.buttonId != null) {
            if (keysm == 256) {
                this.options.setKeyBinding(this.buttonId, InputMappings.field_197958_a);
            } else {
                this.options.setKeyBinding(this.buttonId, InputMappings.func_197954_a((int)keysm, (int)scancode));
            }
            this.buttonId = null;
            KeyBinding.func_74508_b();
            return true;
        }
        return super.func_231046_a_(keysm, scancode, b);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        this.func_230446_a_(matrixStack);
        GuiMinimapControls.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        int leftBorder = this.getLeftBorder();
        for (int keyCounter = 0; keyCounter < this.options.keyBindings.length; ++keyCounter) {
            boolean keycodeCollision = false;
            KeyBinding keyBinding = this.options.keyBindings[keyCounter];
            for (int compareKeyCounter = 0; compareKeyCounter < this.options.game.field_71474_y.field_74324_K.length; ++compareKeyCounter) {
                KeyBinding compareBinding;
                if (compareKeyCounter < this.options.keyBindings.length && keyBinding != (compareBinding = this.options.keyBindings[compareKeyCounter]) && keyBinding.equals(compareBinding)) {
                    keycodeCollision = true;
                    break;
                }
                if (compareKeyCounter >= this.options.game.field_71474_y.field_74324_K.length || keyBinding == (compareBinding = this.options.game.field_71474_y.field_74324_K[compareKeyCounter]) || !keyBinding.equals(compareBinding)) continue;
                keycodeCollision = true;
                break;
            }
            if (this.buttonId == this.options.keyBindings[keyCounter]) {
                ((Button)this.getButtonList().get(keyCounter)).func_238482_a_((ITextComponent)new StringTextComponent("> ").func_230529_a_((ITextComponent)new StringTextComponent("???").func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" <").func_240699_a_(TextFormatting.YELLOW));
            } else if (keycodeCollision) {
                ((Button)this.getButtonList().get(keyCounter)).func_238482_a_((ITextComponent)this.options.getKeybindDisplayString(keyCounter).func_230532_e_().func_240699_a_(TextFormatting.RED));
            } else {
                ((Button)this.getButtonList().get(keyCounter)).func_238482_a_(this.options.getKeybindDisplayString(keyCounter));
            }
            GuiMinimapControls.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.options.getKeyBindingDescription(keyCounter), (int)(leftBorder + keyCounter % 2 * 160 + 70 + 6), (int)(this.getHeight() / 6 + 24 * (keyCounter >> 1) + 7), (int)-1);
        }
        GuiMinimapControls.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("controls.minimap.unbind1", new Object[0]), (int)(this.getWidth() / 2), (int)(this.getHeight() / 6 + 115), (int)0xFFFFFF);
        GuiMinimapControls.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("controls.minimap.unbind2", new Object[0]), (int)(this.getWidth() / 2), (int)(this.getHeight() / 6 + 129), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

