/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSubworldEdit;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.entity.Entity;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSubworldsSelect
extends GuiScreenMinimap
implements BooleanConsumer {
    private ITextComponent title;
    private ITextComponent select;
    private boolean multiworld = false;
    private Button cancelBtn;
    private TextFieldWidget newNameField;
    private boolean newWorld = false;
    private float yaw;
    private PointOfView thirdPersonViewOrig;
    private Button[] selectButtons;
    private Button[] editButtons;
    private String[] worlds;
    private Screen parent;
    ClientPlayerEntity thePlayer;
    ClientPlayerEntity camera;
    private IVoxelMap master;
    private IWaypointManager waypointManager;

    public GuiSubworldsSelect(Screen parent, IVoxelMap master) {
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.parent = parent;
        this.thePlayer = this.getMinecraft().field_71439_g;
        this.camera = new ClientPlayerEntity(this.getMinecraft(), this.getMinecraft().field_71441_e, this.getMinecraft().func_147114_u(), this.thePlayer.func_146107_m(), new ClientRecipeBook(), false, false);
        this.camera.field_71158_b = new MovementInputFromOptions(this.getMinecraft().field_71474_y);
        this.camera.func_70012_b(this.thePlayer.func_226277_ct_(), this.thePlayer.func_226278_cu_() - this.thePlayer.func_70033_W(), this.thePlayer.func_226281_cx_(), this.thePlayer.field_70177_z, 0.0f);
        this.yaw = this.thePlayer.field_70177_z;
        this.thirdPersonViewOrig = this.getMinecraft().field_71474_y.func_243230_g();
        this.master = master;
        this.waypointManager = master.getWaypointManager();
    }

    public void func_231160_c_() {
        ArrayList<String> knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
        if (!(this.multiworld || this.waypointManager.isMultiworld() || this.getMinecraft().func_181540_al())) {
            ConfirmScreen confirmScreen = new ConfirmScreen((BooleanConsumer)this, (ITextComponent)new TranslationTextComponent("worldmap.multiworld.isthismultiworld"), (ITextComponent)new TranslationTextComponent("worldmap.multiworld.explanation"), (ITextComponent)new TranslationTextComponent("gui.yes"), (ITextComponent)new TranslationTextComponent("gui.no"));
            this.getMinecraft().func_147108_a((Screen)confirmScreen);
        } else {
            this.getMinecraft().field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
            this.getMinecraft().func_175607_a((Entity)this.camera);
        }
        this.title = new TranslationTextComponent("worldmap.multiworld.title");
        this.select = new TranslationTextComponent("worldmap.multiworld.select");
        this.getButtonList().clear();
        int centerX = this.field_230708_k_ / 2;
        int buttonsPerRow = this.field_230708_k_ / 150;
        if (buttonsPerRow == 0) {
            buttonsPerRow = 1;
        }
        int buttonWidth = this.field_230708_k_ / buttonsPerRow - 5;
        int xSpacing = (this.field_230708_k_ - buttonsPerRow * buttonWidth) / 2;
        this.cancelBtn = new Button(centerX - 100, this.field_230709_l_ - 30, 200, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.getMinecraft().func_147108_a((Screen)null));
        this.func_230480_a_((Widget)this.cancelBtn);
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(knownSubworldNames, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                return -collator.compare(name1, name2);
            }
        });
        int numKnownSubworlds = knownSubworldNames.size();
        int completeRows = (int)Math.floor((float)(numKnownSubworlds + 1) / (float)buttonsPerRow);
        int lastRowShiftBy = (int)(Math.ceil((float)(numKnownSubworlds + 1) / (float)buttonsPerRow) * (double)buttonsPerRow - (double)(numKnownSubworlds + 1));
        this.worlds = new String[numKnownSubworlds];
        this.selectButtons = new Button[numKnownSubworlds + 1];
        this.editButtons = new Button[numKnownSubworlds + 1];
        for (int t = 0; t < numKnownSubworlds; ++t) {
            int shiftBy = 1;
            if (t / buttonsPerRow >= completeRows) {
                shiftBy = lastRowShiftBy + 1;
            }
            this.worlds[t] = knownSubworldNames.get(t);
            int tt = t;
            this.selectButtons[t] = new Button((buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing, this.field_230709_l_ - 60 - t / buttonsPerRow * 21, buttonWidth - 32, 20, (ITextComponent)new StringTextComponent(this.worlds[t]), button -> this.worldSelected(this.worlds[tt]));
            this.editButtons[t] = new Button((buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing + buttonWidth - 32, this.field_230709_l_ - 60 - t / buttonsPerRow * 21, 30, 20, (ITextComponent)new StringTextComponent("\u2692"), button -> this.editWorld(this.worlds[tt]));
            this.func_230480_a_((Widget)this.selectButtons[t]);
            this.func_230480_a_((Widget)this.editButtons[t]);
        }
        int numButtons = this.selectButtons.length - 1;
        if (!this.newWorld) {
            this.selectButtons[numButtons] = new Button((buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing, this.field_230709_l_ - 60 - numButtons / buttonsPerRow * 21, buttonWidth - 2, 20, (ITextComponent)new StringTextComponent("< " + I18nUtils.getString("worldmap.multiworld.newname", new Object[0]) + " >"), button -> {
                this.newWorld = true;
                this.newNameField.func_146195_b(true);
            });
            this.func_230480_a_((Widget)this.selectButtons[numButtons]);
        }
        this.newNameField = new TextFieldWidget(this.getFontRenderer(), (buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing + 1, this.field_230709_l_ - 60 - numButtons / buttonsPerRow * 21 + 1, buttonWidth - 4, 18, null);
    }

    public void accept(boolean par1) {
        if (!par1) {
            this.getMinecraft().func_147108_a(this.parent);
        } else {
            this.multiworld = true;
            this.getMinecraft().func_147108_a((Screen)this);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.newWorld) {
            this.newNameField.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int keysm, int scancode, int b) {
        if (this.newNameField.func_230999_j_()) {
            String newName;
            this.newNameField.func_231046_a_(keysm, scancode, b);
            if ((keysm == 257 || keysm == 335) && this.newNameField.func_230999_j_() && (newName = this.newNameField.func_146179_b()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.func_231046_a_(keysm, scancode, b);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.newNameField.func_230999_j_()) {
            String newName;
            this.newNameField.func_231042_a_(typedChar, keyCode);
            if (keyCode == 28 && (newName = this.newNameField.func_146179_b()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    public void func_231023_e_() {
        this.newNameField.func_146178_a();
        super.func_231023_e_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int titleStringWidth = this.getFontRenderer().func_238414_a_((ITextProperties)this.title);
        titleStringWidth = Math.max(titleStringWidth, this.getFontRenderer().func_238414_a_((ITextProperties)this.select));
        GuiSubworldsSelect.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - titleStringWidth / 2 - 5), (int)0, (int)(this.field_230708_k_ / 2 + titleStringWidth / 2 + 5), (int)27, (int)-1073741824);
        GuiSubworldsSelect.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (ITextComponent)this.title, (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        GuiSubworldsSelect.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (ITextComponent)this.select, (int)(this.field_230708_k_ / 2), (int)15, (int)0xFF0000);
        this.camera.field_70125_A = 0.0f;
        this.camera.field_70127_C = 0.0f;
        this.camera.field_70126_B = this.camera.field_70177_z = this.yaw;
        float var4 = 0.475f;
        this.camera.field_70137_T = this.camera.field_70167_r = this.thePlayer.func_226278_cu_();
        this.camera.field_70142_S = this.camera.field_70169_q = this.thePlayer.func_226277_ct_() - (double)var4 * Math.sin((double)this.yaw / 180.0 * Math.PI);
        this.camera.field_70136_U = this.camera.field_70166_s = this.thePlayer.func_226281_cx_() + (double)var4 * Math.cos((double)this.yaw / 180.0 * Math.PI);
        this.camera.func_70107_b(this.camera.field_70169_q, this.camera.field_70167_r, this.camera.field_70166_s);
        float var5 = 1.0f;
        this.yaw = (float)((double)this.yaw + (double)var5 * (1.0 + (double)0.7f * Math.cos((double)(this.yaw + 45.0f) / 45.0 * Math.PI)));
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.newWorld) {
            this.newNameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_71474_y.func_243229_a(this.thirdPersonViewOrig);
        this.getMinecraft().func_175607_a((Entity)this.thePlayer);
    }

    private void worldSelected(String selectedSubworldName) {
        this.waypointManager.setSubworldName(selectedSubworldName, false);
        this.getMinecraft().func_147108_a(this.parent);
    }

    private void editWorld(String subworldNameToEdit) {
        this.getMinecraft().func_147108_a((Screen)new GuiSubworldEdit(this, this.master, subworldNameToEdit));
    }
}

