/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui.overridden;

import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.IPopupGuiScreen;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;

public abstract class PopupGuiScreen
extends GuiScreenMinimap
implements IPopupGuiScreen {
    private ArrayList<Popup> popups = new ArrayList();

    public void drawMap() {
    }

    @Override
    public void func_231164_f_() {
    }

    public void createPopup(int x, int y, int directX, int directY, ArrayList<Popup.PopupEntry> entries) {
        this.popups.add(new Popup(x, y, directX, directY, entries, this));
    }

    public void clearPopups() {
        this.popups.clear();
    }

    public boolean clickedPopup(double x, double y) {
        boolean clicked = false;
        ArrayList<Popup> deadPopups = new ArrayList<Popup>();
        for (Popup popup : this.popups) {
            boolean clickedPopup = popup.clickedMe(x, y);
            if (!clickedPopup) {
                deadPopups.add(popup);
            } else if (popup.shouldClose()) {
                deadPopups.add(popup);
            }
            clicked = clicked || clickedPopup;
        }
        this.popups.removeAll(deadPopups);
        return clicked;
    }

    @Override
    public boolean overPopup(int x, int y) {
        boolean over = false;
        for (Popup popup : this.popups) {
            boolean overPopup = popup.overMe(x, y);
            over = over || overPopup;
        }
        return over;
    }

    @Override
    public boolean popupOpen() {
        return this.popups.size() > 0;
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float dunno) {
        super.func_230430_a_(matrixStack, x, y, dunno);
        for (Popup popup : this.popups) {
            popup.drawPopup(matrixStack, x, y);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.clickedPopup(mouseX, mouseY)) {
            return false;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }
}

