/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextUtils {
    public static String scrubCodes(String string) {
        string = string.replaceAll("(\u00a7.)", "");
        return string;
    }

    public static String scrubName(String input) {
        input = input.replace(",", "~comma~");
        input = input.replace(":", "~colon~");
        return input;
    }

    public static String scrubNameRegex(String input) {
        input = input.replace(",", "\ufe50");
        input = input.replace("[", "\u27e6");
        input = input.replace("]", "\u27e7");
        return input;
    }

    public static String scrubNameFile(String input) {
        input = input.replace("<", "~less~");
        input = input.replace(">", "~greater~");
        input = input.replace(":", "~colon~");
        input = input.replace("\"", "~quote~");
        input = input.replace("/", "~slash~");
        input = input.replace("\\", "~backslash~");
        input = input.replace("|", "~pipe~");
        input = input.replace("?", "~question~");
        input = input.replace("*", "~star~");
        return input;
    }

    public static String descrubName(String input) {
        input = input.replace("~less~", "<");
        input = input.replace("~greater~", ">");
        input = input.replace("~colon~", ":");
        input = input.replace("~quote~", "\"");
        input = input.replace("~slash~", "/");
        input = input.replace("~backslash~", "\\");
        input = input.replace("~pipe~", "|");
        input = input.replace("~question~", "?");
        input = input.replace("~star~", "*");
        input = input.replace("~comma~", ",");
        input = input.replace("~colon~", ":");
        input = input.replace("\ufe50", ",");
        input = input.replace("\u27e6", "[");
        input = input.replace("\u27e7", "]");
        return input;
    }

    public static String prettify(String input) {
        CharSequence[] words = input.split("_");
        for (int t = 0; t < words.length; ++t) {
            words[t] = ((String)words[t]).substring(0, 1).toUpperCase() + ((String)words[t]).substring(1).toLowerCase();
        }
        return String.join((CharSequence)" ", words);
    }

    public static String getFormattedText(ITextComponent text2) {
        StringBuilder stringBuilder = new StringBuilder();
        String lastStyleString = "";
        for (ITextComponent text2 : TextUtils.stream(text2)) {
            String contentString = text2.func_150261_e();
            if (contentString.isEmpty()) continue;
            String styleString = TextUtils.getFormattingCode(text2.func_150256_b());
            if (!styleString.equals(lastStyleString)) {
                if (!lastStyleString.isEmpty()) {
                    stringBuilder.append(TextFormatting.RESET);
                }
                stringBuilder.append(styleString);
                lastStyleString = styleString;
            }
            stringBuilder.append(contentString);
        }
        if (!lastStyleString.isEmpty()) {
            stringBuilder.append(TextFormatting.RESET);
        }
        return stringBuilder.toString();
    }

    private static List<ITextComponent> stream(ITextComponent text) {
        ArrayList<ITextComponent> stream = new ArrayList<ITextComponent>();
        stream.add(text);
        for (ITextComponent sibling : text.func_150253_a()) {
            stream.addAll(TextUtils.stream(sibling));
        }
        return stream;
    }

    private static String getFormattingCode(Style style) {
        TextFormatting colorFormat;
        if (style.func_150229_g()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (style.func_240711_a_() != null && (colorFormat = TextFormatting.func_96300_b((String)style.func_240711_a_().func_240747_b_())) != null) {
            stringBuilder.append(colorFormat);
        }
        if (style.func_150223_b()) {
            stringBuilder.append(TextFormatting.BOLD);
        }
        if (style.func_150242_c()) {
            stringBuilder.append(TextFormatting.ITALIC);
        }
        if (style.func_150234_e()) {
            stringBuilder.append(TextFormatting.UNDERLINE);
        }
        if (style.func_150233_f()) {
            stringBuilder.append(TextFormatting.OBFUSCATED);
        }
        if (style.func_150236_d()) {
            stringBuilder.append(TextFormatting.STRIKETHROUGH);
        }
        return stringBuilder.toString();
    }
}

