/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.chunk.Chunk;

public class WaypointContainer {
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private Waypoint highlightedWaypoint = null;
    private Minecraft mc = Minecraft.func_71410_x();
    public MapSettingsManager options = null;
    private final String TARGETFLAG = "*&^TARget%$^";

    public WaypointContainer(MapSettingsManager options) {
        this.options = options;
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.wayPts.remove(waypoint);
    }

    public void setHighlightedWaypoint(Waypoint highlightedWaypoint) {
        this.highlightedWaypoint = highlightedWaypoint;
    }

    private void sortWaypoints() {
        Collections.sort(this.wayPts, Collections.reverseOrder());
    }

    public void renderWaypoints(float partialTicks, MatrixStack matrixStack, boolean beacons, boolean signs, boolean withDepth, boolean withoutDepth) {
        this.sortWaypoints();
        Entity cameraEntity = this.options.game.func_175606_aa();
        double renderPosX = GameVariableAccessShim.xCoordDouble();
        double renderPosY = GameVariableAccessShim.yCoordDouble();
        double renderPosZ = GameVariableAccessShim.zCoordDouble();
        GLShim.glEnable(2884);
        if (this.options.showBeacons && beacons) {
            GLShim.glDisable(3553);
            GLShim.glDisable(2896);
            GLShim.glDisable(2912);
            GLShim.glEnable(2929);
            GLShim.glDepthMask(false);
            GLShim.glEnable(3042);
            GLShim.glBlendFunc(770, 1);
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            for (Waypoint pt : this.wayPts) {
                int z;
                int x;
                Chunk chunk;
                if (!pt.isActive() && pt != this.highlightedWaypoint || (chunk = this.mc.field_71441_e.func_212866_a_((x = pt.getX()) >> 4, (z = pt.getZ()) >> 4)) == null || chunk.func_76621_g() || !this.mc.field_71441_e.func_217354_b(x >> 4, z >> 4)) continue;
                double bottomOfWorld = 0.0 - renderPosY;
                this.renderBeam(pt, (double)x - renderPosX, bottomOfWorld, (double)z - renderPosZ, 64.0f, matrix4f);
            }
            GLShim.glDisable(3042);
            GLShim.glEnable(2912);
            GLShim.glEnable(2896);
            GLShim.glEnable(3553);
            GLShim.glDepthMask(true);
        }
        if (this.options.showWaypoints && signs) {
            GLShim.glAlphaFunc(516, 0.1f);
            GLShim.glDisable(2896);
            GLShim.glDisable(2912);
            GLShim.glEnable(3042);
            GLShim.glBlendFuncSeparate(770, 771, 1, 771);
            for (Waypoint pt : this.wayPts) {
                if (!pt.isActive() && pt != this.highlightedWaypoint) continue;
                int x = pt.getX();
                int z = pt.getZ();
                int y = pt.getY();
                double distance = Math.sqrt(pt.getDistanceSqToEntity(cameraEntity));
                if (!(distance < (double)this.options.maxWaypointDisplayDistance) && this.options.maxWaypointDisplayDistance >= 0 && pt != this.highlightedWaypoint || this.options.game.field_71474_y.field_74319_N) continue;
                boolean isPointedAt = this.isPointedAt(pt, distance, cameraEntity, Float.valueOf(partialTicks));
                String label = pt.name;
                this.renderLabel(matrixStack, pt, distance, isPointedAt, label, (double)x - renderPosX, (double)y - renderPosY - 0.5, (double)z - renderPosZ, 64, withDepth, withoutDepth);
            }
            if (this.highlightedWaypoint != null && !this.options.game.field_71474_y.field_74319_N) {
                int x = this.highlightedWaypoint.getX();
                int z = this.highlightedWaypoint.getZ();
                int y = this.highlightedWaypoint.getY();
                double distance = Math.sqrt(this.highlightedWaypoint.getDistanceSqToEntity(cameraEntity));
                boolean isPointedAt = this.isPointedAt(this.highlightedWaypoint, distance, cameraEntity, Float.valueOf(partialTicks));
                this.renderLabel(matrixStack, this.highlightedWaypoint, distance, isPointedAt, "*&^TARget%$^", (double)x - renderPosX, (double)y - renderPosY - 0.5, (double)z - renderPosZ, 64, withDepth, withoutDepth);
            }
            GLShim.glEnable(2929);
            GLShim.glDepthMask(true);
            GLShim.glEnable(2912);
            GLShim.glDisable(3042);
        }
    }

    private boolean isPointedAt(Waypoint waypoint, double distance, Entity cameraEntity, Float partialTicks) {
        Vector3d cameraPos = cameraEntity.func_174824_e(partialTicks.floatValue());
        double degrees = 5.0 + Math.min(5.0 / distance, 5.0);
        double angle = degrees * 0.0174533;
        double size = Math.sin(angle) * distance;
        Vector3d cameraPosPlusDirection = cameraEntity.func_70676_i(partialTicks.floatValue());
        Vector3d cameraPosPlusDirectionTimesDistance = cameraPos.func_72441_c(cameraPosPlusDirection.field_72450_a * distance, cameraPosPlusDirection.field_72448_b * distance, cameraPosPlusDirection.field_72449_c * distance);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)((float)waypoint.getX() + 0.5f) - size, (double)((float)waypoint.getY() + 1.5f) - size, (double)((float)waypoint.getZ() + 0.5f) - size, (double)((float)waypoint.getX() + 0.5f) + size, (double)((float)waypoint.getY() + 1.5f) + size, (double)((float)waypoint.getZ() + 0.5f) + size);
        Optional raytraceresult = axisalignedbb.func_216365_b(cameraPos, cameraPosPlusDirectionTimesDistance);
        return axisalignedbb.func_72318_a(cameraPos) ? distance >= 1.0 : raytraceresult.isPresent();
    }

    private void renderBeam(Waypoint par1EntityWaypoint, double baseX, double baseY, double baseZ, float par8, Matrix4f matrix4f) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        int height = 256;
        float brightness = 0.06f;
        double topWidthFactor = 1.05;
        double bottomWidthFactor = 1.05;
        float r = par1EntityWaypoint.red;
        float b = par1EntityWaypoint.blue;
        float g = par1EntityWaypoint.green;
        for (int width = 0; width < 4; ++width) {
            vertexBuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            double d6 = 0.1 + (double)width * 0.2;
            d6 *= topWidthFactor;
            double d7 = 0.1 + (double)width * 0.2;
            d7 *= bottomWidthFactor;
            for (int side = 0; side < 5; ++side) {
                float vertX2 = (float)(baseX + 0.5 - d6);
                float vertZ2 = (float)(baseZ + 0.5 - d6);
                if (side == 1 || side == 2) {
                    vertX2 = (float)((double)vertX2 + d6 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ2 = (float)((double)vertZ2 + d6 * 2.0);
                }
                float vertX1 = (float)(baseX + 0.5 - d7);
                float vertZ1 = (float)(baseZ + 0.5 - d7);
                if (side == 1 || side == 2) {
                    vertX1 = (float)((double)vertX1 + d7 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ1 = (float)((double)vertZ1 + d7 * 2.0);
                }
                vertexBuffer.func_227888_a_(matrix4f, vertX1, (float)baseY + 0.0f, vertZ1).func_227885_a_(r * brightness, g * brightness, b * brightness, 0.8f).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, vertX2, (float)baseY + (float)height, vertZ2).func_227885_a_(r * brightness, g * brightness, b * brightness, 0.8f).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    private void renderLabel(MatrixStack matrixStack, Waypoint pt, double distance, boolean isPointedAt, String name, double baseX, double baseY, double baseZ, int par9, boolean withDepth, boolean withoutDepth) {
        Sprite icon;
        boolean target;
        boolean bl = target = name == "*&^TARget%$^";
        if (target) {
            if (pt.red == 2.0f && pt.green == 0.0f && pt.blue == 0.0f) {
                name = "X:" + pt.getX() + ", Y:" + pt.getY() + ", Z:" + pt.getZ();
            } else {
                isPointedAt = false;
            }
        }
        name = name + " (" + (int)distance + "m)";
        double maxDistance = AbstractOption.field_216706_m.func_216729_a(this.options.game.field_71474_y) * 16.0 * 0.99;
        double adjustedDistance = distance;
        if (distance > maxDistance) {
            baseX = baseX / distance * maxDistance;
            baseY = baseY / distance * maxDistance;
            baseZ = baseZ / distance * maxDistance;
            adjustedDistance = maxDistance;
        }
        float var14 = ((float)adjustedDistance * 0.1f + 1.0f) * 0.0266f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)baseX + 0.5f), (double)((float)baseY + 0.5f), (double)((float)baseZ + 0.5f));
        GLShim.glNormal3f(0.0f, 1.0f, 0.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-this.mc.func_175598_ae().field_217783_c.func_216778_f()));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.mc.func_175598_ae().field_217783_c.func_216777_e()));
        matrixStack.func_227862_a_(-var14, -var14, -var14);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        float fade = distance > 5.0 ? 1.0f : (float)distance / 5.0f;
        fade = Math.min(fade, pt.enabled || target ? 1.0f : 0.3f);
        float width = 10.0f;
        float r = target ? 1.0f : pt.red;
        float g = target ? 0.0f : pt.green;
        float b = target ? 0.0f : pt.blue;
        TextureAtlas textureAtlas = AbstractVoxelMap.getInstance().getWaypointManager().getTextureAtlas();
        Sprite sprite = icon = target ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
        if (icon == textureAtlas.getMissingImage()) {
            icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
        }
        GLUtils.disp(textureAtlas.func_110552_b());
        GLShim.glEnable(3553);
        if (withDepth) {
            GLShim.glDepthMask(distance < maxDistance);
            GLShim.glEnable(2929);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_227888_a_(matrix4f, -width, -width, 0.0f).func_225583_a_(icon.getMinU(), icon.getMinV()).func_227885_a_(r, g, b, 1.0f * fade).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, -width, width, 0.0f).func_225583_a_(icon.getMinU(), icon.getMaxV()).func_227885_a_(r, g, b, 1.0f * fade).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, width, width, 0.0f).func_225583_a_(icon.getMaxU(), icon.getMaxV()).func_227885_a_(r, g, b, 1.0f * fade).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, width, -width, 0.0f).func_225583_a_(icon.getMaxU(), icon.getMinV()).func_227885_a_(r, g, b, 1.0f * fade).func_181675_d();
            tessellator.func_78381_a();
        }
        if (withoutDepth) {
            GLShim.glDisable(2929);
            GLShim.glDepthMask(false);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_227888_a_(matrix4f, -width, -width, 0.0f).func_225583_a_(icon.getMinU(), icon.getMinV()).func_227885_a_(r, g, b, 0.3f * fade).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, -width, width, 0.0f).func_225583_a_(icon.getMinU(), icon.getMaxV()).func_227885_a_(r, g, b, 0.3f * fade).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, width, width, 0.0f).func_225583_a_(icon.getMaxU(), icon.getMaxV()).func_227885_a_(r, g, b, 0.3f * fade).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, width, -width, 0.0f).func_225583_a_(icon.getMaxU(), icon.getMinV()).func_227885_a_(r, g, b, 0.3f * fade).func_181675_d();
            tessellator.func_78381_a();
        }
        FontRenderer fontRenderer = this.mc.func_175598_ae().func_78716_a();
        if (isPointedAt && fontRenderer != null) {
            int elevateBy = -19;
            GLShim.glDisable(3553);
            GLShim.glEnable(32823);
            int halfStringWidth = fontRenderer.func_78256_a(name) / 2;
            if (withDepth) {
                GLShim.glEnable(2929);
                GLShim.glDepthMask(distance < maxDistance);
                GLShim.glPolygonOffset(1.0f, 7.0f);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 2), (float)(-2 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 2), (float)(9 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 2), (float)(9 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 2), (float)(-2 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
                tessellator.func_78381_a();
                GLShim.glPolygonOffset(1.0f, 5.0f);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 1), (float)(-1 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 1), (float)(8 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 1), (float)(8 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 1), (float)(-1 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                tessellator.func_78381_a();
            }
            if (withoutDepth) {
                GLShim.glDisable(2929);
                GLShim.glDepthMask(false);
                GLShim.glPolygonOffset(1.0f, 11.0f);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 2), (float)(-2 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 2), (float)(9 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 2), (float)(9 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 2), (float)(-2 + elevateBy), 0.0f).func_227885_a_(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
                tessellator.func_78381_a();
                GLShim.glPolygonOffset(1.0f, 9.0f);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 1), (float)(-1 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(-halfStringWidth - 1), (float)(8 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 1), (float)(8 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)(halfStringWidth + 1), (float)(-1 + elevateBy), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
                tessellator.func_78381_a();
            }
            GLShim.glDisable(32823);
            GLShim.glDepthMask(false);
            GLShim.glEnable(3553);
            IRenderTypeBuffer.Impl vertexConsumerProvider = this.mc.func_228019_au_().func_228487_b_();
            if (withoutDepth) {
                int textColor = (int)(255.0f * fade) << 24 | 0xCCCCCC;
                GLShim.glDisable(2929);
                fontRenderer.func_243247_a((ITextComponent)new StringTextComponent(name), (float)(-fontRenderer.func_78256_a(name) / 2), (float)elevateBy, textColor, false, matrix4f, (IRenderTypeBuffer)vertexConsumerProvider, true, 0, 0xF000F0);
                vertexConsumerProvider.func_228461_a_();
                GLShim.glEnable(2929);
                textColor = (int)(255.0f * fade) << 24 | 0xFFFFFF;
                fontRenderer.func_238421_b_(matrixStack, name, (float)(-fontRenderer.func_78256_a(name) / 2), (float)elevateBy, textColor);
            }
            GLShim.glEnable(3042);
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }
}

