/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import com.kapiteon.multimod.FreeCamForge;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSoundMinecartRiding;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiCommandBlock;
import net.minecraft.client.gui.GuiEnchantment;
import net.minecraft.client.gui.GuiHopper;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiRepair;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.inventory.GuiBeacon;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiDispenser;
import net.minecraft.client.gui.inventory.GuiEditCommandBlockMinecart;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.gui.inventory.GuiEditStructure;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.inventory.GuiScreenHorseInventory;
import net.minecraft.client.gui.inventory.GuiShulkerBox;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerAbilities;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityPlayerSPex
extends EntityPlayerSP {
    public double posXfake;
    public double posYfake;
    public double posZfake;
    public float yawFake;
    public float pitchFake;
    private final StatisticsManager statWriter;
    private int permissionLevel = 0;
    private double lastReportedPosX;
    private double lastReportedPosY;
    private double lastReportedPosZ;
    private float lastReportedYaw;
    private float lastReportedPitch;
    private boolean prevOnGround;
    private boolean serverSneakState;
    private boolean serverSprintState;
    private int positionUpdateTicks;
    private boolean hasValidHealth;
    private String serverBrand;
    private int horseJumpPowerCounter;
    private float horseJumpPower;
    private boolean handActive;
    private EnumHand activeHand;
    private boolean rowingBoat;
    private boolean autoJumpEnabled = true;
    private int autoJumpTime;
    private boolean wasFallFlying;

    public EntityPlayerSPex(Minecraft mcIn, World worldIn, NetHandlerPlayClient netHandler, StatisticsManager statFile) {
        super(mcIn, worldIn, netHandler, statFile);
        this.statWriter = statFile;
        this.field_71159_c = mcIn;
        this.field_71093_bK = 0;
    }

    public boolean func_175149_v() {
        if (FreeCamForge.getInstance().fc.IsEnabled()) {
            return true;
        }
        return super.func_175149_v();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)amount);
        return false;
    }

    public void func_70691_i(float healAmount) {
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        if (!super.func_184205_a(entityIn, force)) {
            return false;
        }
        if (entityIn instanceof EntityMinecart) {
            this.field_71159_c.func_147118_V().func_147682_a((ISound)new MovingSoundMinecartRiding((EntityPlayer)this, (EntityMinecart)entityIn));
        }
        if (entityIn instanceof EntityBoat) {
            this.field_70126_B = entityIn.field_70177_z;
            this.field_70177_z = entityIn.field_70177_z;
            this.func_70034_d(entityIn.field_70177_z);
        }
        return true;
    }

    public void func_184210_p() {
        super.func_184210_p();
        this.rowingBoat = false;
    }

    public Vec3d func_70676_i(float partialTicks) {
        return this.func_174806_f(this.field_70125_A, this.field_70177_z);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.func_175667_e(new BlockPos(this.field_70165_t, 0.0, this.field_70161_v))) {
            super.func_70071_h_();
            if (this.func_184218_aH()) {
                Entity entity;
                this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Rotation(this.field_70177_z, this.field_70125_A, this.field_70122_E));
                if (!FreeCamForge.getInstance().fc.IsEnabled()) {
                    this.field_71174_a.func_147297_a((Packet)new CPacketInput(this.field_70702_br, this.field_70701_bs, this.field_71158_b.field_78901_c, this.field_71158_b.field_78899_d));
                }
                if ((entity = this.func_184208_bv()) != this && entity.func_184186_bw()) {
                    this.field_71174_a.func_147297_a((Packet)new CPacketVehicleMove(entity));
                }
            } else {
                this.func_175161_p();
            }
        }
    }

    public void func_175161_p() {
        boolean flag1;
        boolean flag = this.func_70051_ag();
        if (flag != this.serverSprintState) {
            if (flag) {
                if (!FreeCamForge.getInstance().fc.IsEnabled()) {
                    this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.START_SPRINTING));
                }
            } else if (!FreeCamForge.getInstance().fc.IsEnabled()) {
                this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.STOP_SPRINTING));
            }
            this.serverSprintState = flag;
        }
        if ((flag1 = this.func_70093_af()) != this.serverSneakState) {
            if (flag1) {
                if (!FreeCamForge.getInstance().fc.IsEnabled()) {
                    this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.START_SNEAKING));
                }
            } else if (!FreeCamForge.getInstance().fc.IsEnabled()) {
                this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.STOP_SNEAKING));
            }
            this.serverSneakState = flag1;
        }
        if (this.func_175160_A()) {
            boolean flag3;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            double d0 = this.field_70165_t - this.lastReportedPosX;
            double d1 = axisalignedbb.field_72338_b - this.lastReportedPosY;
            double d2 = this.field_70161_v - this.lastReportedPosZ;
            double d3 = this.field_70177_z - this.lastReportedYaw;
            double d4 = this.field_70125_A - this.lastReportedPitch;
            ++this.positionUpdateTicks;
            boolean flag2 = d0 * d0 + d1 * d1 + d2 * d2 > 9.0E-4 || this.positionUpdateTicks >= 20;
            boolean bl = flag3 = d3 != 0.0 || d4 != 0.0;
            if (this.func_184218_aH()) {
                this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.PositionRotation(this.field_70159_w, -999.0, this.field_70179_y, this.field_70177_z, this.field_70125_A, this.field_70122_E));
                flag2 = false;
            } else if (flag2 && flag3) {
                if (FreeCamForge.getInstance().fc.IsEnabled()) {
                    this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.PositionRotation(this.posXfake, this.posYfake, this.posZfake, this.yawFake, this.pitchFake, this.field_70122_E));
                } else {
                    this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.PositionRotation(this.field_70165_t, axisalignedbb.field_72338_b, this.field_70161_v, this.field_70177_z, this.field_70125_A, this.field_70122_E));
                }
            } else if (flag2) {
                if (FreeCamForge.getInstance().fc.IsEnabled()) {
                    this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Position(this.posXfake, this.posYfake, this.posZfake, this.field_70122_E));
                } else {
                    this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Position(this.field_70165_t, axisalignedbb.field_72338_b, this.field_70161_v, this.field_70122_E));
                }
            } else if (flag3) {
                if (FreeCamForge.getInstance().fc.IsEnabled()) {
                    this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Rotation(this.yawFake, this.pitchFake, this.field_70122_E));
                } else {
                    this.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Rotation(this.field_70177_z, this.field_70125_A, this.field_70122_E));
                }
            } else if (this.prevOnGround != this.field_70122_E) {
                this.field_71174_a.func_147297_a((Packet)new CPacketPlayer(this.field_70122_E));
            }
            if (flag2) {
                this.lastReportedPosX = this.field_70165_t;
                this.lastReportedPosY = axisalignedbb.field_72338_b;
                this.lastReportedPosZ = this.field_70161_v;
                this.positionUpdateTicks = 0;
            }
            if (flag3) {
                this.lastReportedYaw = this.field_70177_z;
                this.lastReportedPitch = this.field_70125_A;
            }
            this.prevOnGround = this.field_70122_E;
            this.autoJumpEnabled = this.field_71159_c.field_71474_y.field_189989_R;
        }
    }

    @Nullable
    public EntityItem func_71040_bB(boolean dropAll) {
        CPacketPlayerDigging.Action cpacketplayerdigging$action = dropAll ? CPacketPlayerDigging.Action.DROP_ALL_ITEMS : CPacketPlayerDigging.Action.DROP_ITEM;
        this.field_71174_a.func_147297_a((Packet)new CPacketPlayerDigging(cpacketplayerdigging$action, BlockPos.field_177992_a, EnumFacing.DOWN));
        return null;
    }

    public ItemStack func_184816_a(EntityItem p_184816_1_) {
        return ItemStack.field_190927_a;
    }

    public void func_71165_d(String message) {
        this.field_71174_a.func_147297_a((Packet)new CPacketChatMessage(message));
    }

    public void func_184609_a(EnumHand hand) {
        super.func_184609_a(hand);
        this.field_71174_a.func_147297_a((Packet)new CPacketAnimation(hand));
    }

    public void func_71004_bE() {
        this.field_71174_a.func_147297_a((Packet)new CPacketClientStatus(CPacketClientStatus.State.PERFORM_RESPAWN));
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.func_180431_b(damageSrc)) {
            this.func_70606_j(this.func_110143_aJ() - damageAmount);
        }
    }

    public void func_71053_j() {
        this.field_71174_a.func_147297_a((Packet)new CPacketCloseWindow(this.field_71070_bA.field_75152_c));
        this.func_175159_q();
    }

    public void func_175159_q() {
        super.func_175159_q();
    }

    public void func_71150_b(float health) {
        if (this.hasValidHealth) {
            float f = this.func_110143_aJ() - health;
            if (f <= 0.0f) {
                this.func_70606_j(health);
                if (f < 0.0f) {
                    this.field_70172_ad = this.field_70771_an / 2;
                }
            } else {
                this.field_110153_bc = f;
                this.func_70606_j(this.func_110143_aJ());
                this.field_70172_ad = this.field_70771_an;
                this.func_70665_d(DamageSource.field_76377_j, f);
                this.field_70737_aN = this.field_70738_aO = 10;
            }
        } else {
            this.func_70606_j(health);
            this.hasValidHealth = true;
        }
    }

    public void func_71064_a(StatBase stat, int amount) {
        if (stat != null && stat.field_75972_f) {
            super.func_71064_a(stat, amount);
        }
    }

    public void func_71016_p() {
        if (FreeCamForge.getInstance().fc.IsEnabled()) {
            this.field_71075_bZ.field_75101_c = false;
            this.field_71075_bZ.field_75100_b = false;
        }
        this.field_71174_a.func_147297_a((Packet)new CPacketPlayerAbilities(this.field_71075_bZ));
        if (FreeCamForge.getInstance().fc.IsEnabled()) {
            this.field_71075_bZ.field_75101_c = true;
            this.field_71075_bZ.field_75100_b = true;
        }
    }

    public boolean func_175144_cb() {
        return true;
    }

    protected void func_110318_g() {
        this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.START_RIDING_JUMP, MathHelper.func_76141_d((float)(this.func_110319_bJ() * 100.0f))));
    }

    public void func_175163_u() {
        this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.OPEN_INVENTORY));
    }

    public void func_175158_f(String brand) {
        this.serverBrand = brand;
    }

    public String func_142021_k() {
        return this.serverBrand;
    }

    public StatisticsManager func_146107_m() {
        return this.statWriter;
    }

    public int func_184840_I() {
        return this.permissionLevel;
    }

    public void func_184839_n(int p_184839_1_) {
        this.permissionLevel = p_184839_1_;
    }

    public void func_146105_b(ITextComponent chatComponent, boolean actionBar) {
        if (actionBar) {
            this.field_71159_c.field_71456_v.func_175188_a(chatComponent, false);
        } else {
            this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(chatComponent);
        }
    }

    private boolean isHeadspaceFree(BlockPos pos, int height) {
        for (int y = 0; y < height; ++y) {
            if (this.isOpenBlockSpace(pos.func_177982_a(0, y, 0))) continue;
            return false;
        }
        return true;
    }

    protected boolean func_145771_j(double x, double y, double z) {
        boolean inTranslucentBlock;
        if (this.field_70145_X) {
            return false;
        }
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = x - (double)blockpos.func_177958_n();
        double d1 = z - (double)blockpos.func_177952_p();
        int entHeight = Math.max((int)Math.ceil(this.field_70131_O), 1);
        boolean bl = inTranslucentBlock = !this.isHeadspaceFree(blockpos, entHeight);
        if (inTranslucentBlock) {
            int i = -1;
            double d2 = 9999.0;
            if (this.isHeadspaceFree(blockpos.func_177976_e(), entHeight) && d0 < d2) {
                d2 = d0;
                i = 0;
            }
            if (this.isHeadspaceFree(blockpos.func_177974_f(), entHeight) && 1.0 - d0 < d2) {
                d2 = 1.0 - d0;
                i = 1;
            }
            if (this.isHeadspaceFree(blockpos.func_177978_c(), entHeight) && d1 < d2) {
                d2 = d1;
                i = 4;
            }
            if (this.isHeadspaceFree(blockpos.func_177968_d(), entHeight) && 1.0 - d1 < d2) {
                d2 = 1.0 - d1;
                i = 5;
            }
            float f = 0.1f;
            if (i == 0) {
                this.field_70159_w = -0.1f;
            }
            if (i == 1) {
                this.field_70159_w = 0.1f;
            }
            if (i == 4) {
                this.field_70179_y = -0.1f;
            }
            if (i == 5) {
                this.field_70179_y = 0.1f;
            }
        }
        return false;
    }

    private boolean isOpenBlockSpace(BlockPos pos) {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
        return !iblockstate.func_177230_c().isNormalCube(iblockstate, (IBlockAccess)this.field_70170_p, pos);
    }

    public void func_70031_b(boolean sprinting) {
        super.func_70031_b(sprinting);
        this.field_71157_e = 0;
    }

    public void func_71152_a(float currentXP, int maxXP, int level) {
        this.field_71106_cc = currentXP;
        this.field_71067_cb = maxXP;
        this.field_71068_ca = level;
    }

    public void func_145747_a(ITextComponent component) {
        this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(component);
    }

    public boolean func_70003_b(int permLevel, String commandName) {
        return permLevel <= this.func_184840_I();
    }

    public void func_70103_a(byte id) {
        if (id >= 24 && id <= 28) {
            this.func_184839_n(id - 24);
        } else {
            super.func_70103_a(id);
        }
    }

    public BlockPos func_180425_c() {
        return new BlockPos(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5);
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)this, (SoundEvent)soundIn, (SoundCategory)this.func_184176_by(), (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        volume = event.getVolume();
        pitch = event.getPitch();
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundIn, event.getCategory(), volume, pitch, false);
    }

    public boolean func_70613_aW() {
        return true;
    }

    public void func_184598_c(EnumHand hand) {
        ItemStack itemstack = this.func_184586_b(hand);
        if (!itemstack.func_190926_b() && !this.func_184587_cr()) {
            super.func_184598_c(hand);
            this.handActive = true;
            this.activeHand = hand;
        }
    }

    public boolean func_184587_cr() {
        return this.handActive;
    }

    public void func_184602_cy() {
        super.func_184602_cy();
        this.handActive = false;
    }

    public EnumHand func_184600_cs() {
        return this.activeHand;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (field_184621_as.equals(key)) {
            EnumHand enumhand;
            boolean flag = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 1) > 0;
            EnumHand enumHand = enumhand = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 2) > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
            if (flag && !this.handActive) {
                this.func_184598_c(enumhand);
            } else if (!flag && this.handActive) {
                this.func_184602_cy();
            }
        }
        if (!(field_184240_ax.equals(key) && this.func_184613_cA() && this.wasFallFlying)) {
            // empty if block
        }
    }

    public boolean func_110317_t() {
        Entity entity = this.func_184187_bx();
        return this.func_184218_aH() && entity instanceof IJumpingMount && ((IJumpingMount)entity).func_184776_b();
    }

    public float func_110319_bJ() {
        return this.horseJumpPower;
    }

    public void func_175141_a(TileEntitySign signTile) {
        this.field_71159_c.func_147108_a((GuiScreen)new GuiEditSign(signTile));
    }

    public void func_184809_a(CommandBlockBaseLogic commandBlock) {
        this.field_71159_c.func_147108_a((GuiScreen)new GuiEditCommandBlockMinecart(commandBlock));
    }

    public void func_184824_a(TileEntityCommandBlock commandBlock) {
        this.field_71159_c.func_147108_a((GuiScreen)new GuiCommandBlock(commandBlock));
    }

    public void func_189807_a(TileEntityStructure structure) {
        this.field_71159_c.func_147108_a((GuiScreen)new GuiEditStructure(structure));
    }

    public void func_184814_a(ItemStack stack, EnumHand hand) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151099_bA) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiScreenBook((EntityPlayer)this, stack, true));
        }
    }

    public void func_71007_a(IInventory chestInventory) {
        String s;
        String string = s = chestInventory instanceof IInteractionObject ? ((IInteractionObject)chestInventory).func_174875_k() : "minecraft:container";
        if ("minecraft:chest".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiChest((IInventory)this.field_71071_by, chestInventory));
        } else if ("minecraft:hopper".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiHopper(this.field_71071_by, chestInventory));
        } else if ("minecraft:furnace".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiFurnace(this.field_71071_by, chestInventory));
        } else if ("minecraft:brewing_stand".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiBrewingStand(this.field_71071_by, chestInventory));
        } else if ("minecraft:beacon".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiBeacon(this.field_71071_by, chestInventory));
        } else if (!"minecraft:dispenser".equals(s) && !"minecraft:dropper".equals(s)) {
            if ("minecraft:shulker_box".equals(s)) {
                this.field_71159_c.func_147108_a((GuiScreen)new GuiShulkerBox(this.field_71071_by, chestInventory));
            } else {
                this.field_71159_c.func_147108_a((GuiScreen)new GuiChest((IInventory)this.field_71071_by, chestInventory));
            }
        } else {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiDispenser(this.field_71071_by, chestInventory));
        }
    }

    public void func_184826_a(AbstractHorse horse, IInventory inventoryIn) {
        this.field_71159_c.func_147108_a((GuiScreen)new GuiScreenHorseInventory((IInventory)this.field_71071_by, inventoryIn, horse));
    }

    public void func_180468_a(IInteractionObject guiOwner) {
        String s = guiOwner.func_174875_k();
        if ("minecraft:crafting_table".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiCrafting(this.field_71071_by, this.field_70170_p));
        } else if ("minecraft:enchanting_table".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiEnchantment(this.field_71071_by, this.field_70170_p, (IWorldNameable)guiOwner));
        } else if ("minecraft:anvil".equals(s)) {
            this.field_71159_c.func_147108_a((GuiScreen)new GuiRepair(this.field_71071_by, this.field_70170_p));
        }
    }

    public void func_180472_a(IMerchant villager) {
        this.field_71159_c.func_147108_a((GuiScreen)new GuiMerchant(this.field_71071_by, villager, this.field_70170_p));
    }

    public void func_71009_b(Entity entityHit) {
        this.field_71159_c.field_71452_i.func_178926_a(entityHit, EnumParticleTypes.CRIT);
    }

    public void func_71047_c(Entity entityHit) {
        this.field_71159_c.field_71452_i.func_178926_a(entityHit, EnumParticleTypes.CRIT_MAGIC);
    }

    public boolean func_70093_af() {
        boolean flag = this.field_71158_b != null && this.field_71158_b.field_78899_d;
        return flag && !this.field_71083_bS;
    }

    public void func_70626_be() {
        super.func_70626_be();
        if (this.func_175160_A()) {
            this.field_70702_br = this.field_71158_b.field_78902_a;
            this.field_70701_bs = this.field_71158_b.field_78900_b;
            this.field_70703_bu = this.field_71158_b.field_78901_c;
            this.field_71163_h = this.field_71154_f;
            this.field_71164_i = this.field_71155_g;
            this.field_71155_g = (float)((double)this.field_71155_g + (double)(this.field_70125_A - this.field_71155_g) * 0.5);
            this.field_71154_f = (float)((double)this.field_71154_f + (double)(this.field_70177_z - this.field_71154_f) * 0.5);
        }
    }

    protected boolean func_175160_A() {
        return this.field_71159_c.func_175606_aa() == this;
    }

    public void func_70636_d() {
        ItemStack itemstack;
        boolean flag4;
        ++this.field_71157_e;
        if (this.field_71156_d > 0) {
            --this.field_71156_d;
        }
        this.field_71080_cy = this.field_71086_bY;
        if (this.field_71087_bX) {
            if (this.field_71159_c.field_71462_r != null && !this.field_71159_c.field_71462_r.func_73868_f()) {
                this.field_71159_c.func_147108_a((GuiScreen)null);
            }
            if (this.field_71086_bY == 0.0f) {
                this.field_71159_c.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187814_ei, (float)(this.field_70146_Z.nextFloat() * 0.4f + 0.8f)));
            }
            this.field_71086_bY += 0.0125f;
            if (this.field_71086_bY >= 1.0f) {
                this.field_71086_bY = 1.0f;
            }
            this.field_71087_bX = false;
        } else if (this.func_70644_a(MobEffects.field_76431_k) && this.func_70660_b(MobEffects.field_76431_k).func_76459_b() > 60) {
            this.field_71086_bY += 0.006666667f;
            if (this.field_71086_bY > 1.0f) {
                this.field_71086_bY = 1.0f;
            }
        } else {
            if (this.field_71086_bY > 0.0f) {
                this.field_71086_bY -= 0.05f;
            }
            if (this.field_71086_bY < 0.0f) {
                this.field_71086_bY = 0.0f;
            }
        }
        if (this.field_71088_bW > 0) {
            --this.field_71088_bW;
        }
        boolean flag = this.field_71158_b.field_78901_c;
        boolean flag1 = this.field_71158_b.field_78899_d;
        float f = 0.8f;
        boolean flag2 = this.field_71158_b.field_78900_b >= 0.8f;
        this.field_71158_b.func_78898_a();
        if (this.func_184587_cr() && !this.func_184218_aH()) {
            this.field_71158_b.field_78902_a *= 0.2f;
            this.field_71158_b.field_78900_b *= 0.2f;
            this.field_71156_d = 0;
        }
        boolean flag3 = false;
        if (this.autoJumpTime > 0) {
            --this.autoJumpTime;
            flag3 = true;
            this.field_71158_b.field_78901_c = true;
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_145771_j(this.field_70165_t - (double)this.field_70130_N * 0.35, axisalignedbb.field_72338_b + 0.5, this.field_70161_v + (double)this.field_70130_N * 0.35);
        this.func_145771_j(this.field_70165_t - (double)this.field_70130_N * 0.35, axisalignedbb.field_72338_b + 0.5, this.field_70161_v - (double)this.field_70130_N * 0.35);
        this.func_145771_j(this.field_70165_t + (double)this.field_70130_N * 0.35, axisalignedbb.field_72338_b + 0.5, this.field_70161_v - (double)this.field_70130_N * 0.35);
        this.func_145771_j(this.field_70165_t + (double)this.field_70130_N * 0.35, axisalignedbb.field_72338_b + 0.5, this.field_70161_v + (double)this.field_70130_N * 0.35);
        boolean bl = flag4 = (float)this.func_71024_bL().func_75116_a() > 6.0f || this.field_71075_bZ.field_75101_c || FreeCamForge.getInstance().fc.IsEnabled();
        if (this.field_70122_E && !flag1 && !flag2 && this.field_71158_b.field_78900_b >= 0.8f && !this.func_70051_ag() && flag4 && !this.func_184587_cr() && !this.func_70644_a(MobEffects.field_76440_q)) {
            if (this.field_71156_d <= 0 && !this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
                this.field_71156_d = 7;
            } else {
                this.func_70031_b(true);
            }
        }
        if (!this.func_70051_ag() && this.field_71158_b.field_78900_b >= 0.8f && flag4 && !this.func_184587_cr() && !this.func_70644_a(MobEffects.field_76440_q) && this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
            this.func_70031_b(true);
        }
        if (this.func_70051_ag() && (this.field_71158_b.field_78900_b < 0.8f || this.field_70123_F || !flag4)) {
            this.func_70031_b(false);
        }
        if (this.field_71075_bZ.field_75101_c || FreeCamForge.getInstance().fc.IsEnabled()) {
            if (this.field_71159_c.field_71442_b.func_178887_k() || FreeCamForge.getInstance().fc.IsEnabled()) {
                if (!this.field_71075_bZ.field_75100_b || FreeCamForge.getInstance().fc.IsEnabled()) {
                    this.field_71075_bZ.field_75100_b = true;
                    if (!FreeCamForge.getInstance().fc.IsEnabled()) {
                        this.func_71016_p();
                    }
                }
            } else if (!flag && this.field_71158_b.field_78901_c && !flag3) {
                if (this.field_71101_bC == 0) {
                    this.field_71101_bC = 7;
                } else {
                    boolean bl2 = this.field_71075_bZ.field_75100_b = !this.field_71075_bZ.field_75100_b;
                    if (this.field_71075_bZ.field_75101_c) {
                        this.func_71016_p();
                    }
                    this.field_71101_bC = 0;
                }
            }
        }
        if (this.field_71158_b.field_78901_c && !flag && !this.field_70122_E && this.field_70181_x < 0.0 && !this.func_184613_cA() && !this.field_71075_bZ.field_75100_b && (itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST)).func_77973_b() == Items.field_185160_cR && ItemElytra.func_185069_d((ItemStack)itemstack) && !FreeCamForge.getInstance().fc.IsEnabled()) {
            this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.START_FALL_FLYING));
        }
        this.wasFallFlying = this.func_184613_cA();
        if (this.field_71075_bZ.field_75100_b && this.func_175160_A()) {
            if (this.field_71158_b.field_78899_d) {
                this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a / 0.3);
                this.field_71158_b.field_78900_b = (float)((double)this.field_71158_b.field_78900_b / 0.3);
                this.field_70181_x -= (double)(this.field_71075_bZ.func_75093_a() * 3.0f);
            }
            if (this.field_71158_b.field_78901_c) {
                this.field_70181_x += (double)(this.field_71075_bZ.func_75093_a() * 3.0f);
            }
        }
        if (this.func_110317_t()) {
            IJumpingMount ijumpingmount = (IJumpingMount)this.func_184187_bx();
            if (this.horseJumpPowerCounter < 0) {
                ++this.horseJumpPowerCounter;
                if (this.horseJumpPowerCounter == 0) {
                    this.horseJumpPower = 0.0f;
                }
            }
            if (flag && !this.field_71158_b.field_78901_c) {
                this.horseJumpPowerCounter = -10;
                ijumpingmount.func_110206_u(MathHelper.func_76141_d((float)(this.func_110319_bJ() * 100.0f)));
                this.func_110318_g();
            } else if (!flag && this.field_71158_b.field_78901_c) {
                this.horseJumpPowerCounter = 0;
                this.horseJumpPower = 0.0f;
            } else if (flag) {
                ++this.horseJumpPowerCounter;
                this.horseJumpPower = this.horseJumpPowerCounter < 10 ? (float)this.horseJumpPowerCounter * 0.1f : 0.8f + 2.0f / (float)(this.horseJumpPowerCounter - 9) * 0.1f;
            }
        } else {
            this.horseJumpPower = 0.0f;
        }
        super.func_70636_d();
        if (this.field_70122_E && this.field_71075_bZ.field_75100_b && !this.field_71159_c.field_71442_b.func_178887_k()) {
            this.field_71075_bZ.field_75100_b = false;
            this.func_71016_p();
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
        this.rowingBoat = false;
        if (this.func_184187_bx() instanceof EntityBoat) {
            EntityBoat entityboat = (EntityBoat)this.func_184187_bx();
            entityboat.func_184442_a(this.field_71158_b.field_187257_e, this.field_71158_b.field_187258_f, this.field_71158_b.field_187255_c, this.field_71158_b.field_187256_d);
            this.rowingBoat |= this.field_71158_b.field_187257_e || this.field_71158_b.field_187258_f || this.field_71158_b.field_187255_c || this.field_71158_b.field_187256_d;
        }
    }

    public boolean func_184838_M() {
        return this.rowingBoat;
    }

    @Nullable
    public PotionEffect func_184596_c(@Nullable Potion potioneffectin) {
        if (potioneffectin == MobEffects.field_76431_k) {
            this.field_71080_cy = 0.0f;
            this.field_71086_bY = 0.0f;
        }
        return super.func_184596_c(potioneffectin);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70161_v;
        super.func_70091_d(type, x, y, z);
        this.func_189810_i((float)(this.field_70165_t - d0), (float)(this.field_70161_v - d1));
    }

    public boolean func_189809_N() {
        return this.autoJumpEnabled;
    }

    protected void func_189810_i(float p_189810_1_, float p_189810_2_) {
        if (this.func_189809_N() && this.autoJumpTime <= 0 && this.field_70122_E && !this.func_70093_af() && !this.func_184218_aH()) {
            Vec2f vec2f = this.field_71158_b.func_190020_b();
            if (vec2f.field_189982_i != 0.0f || vec2f.field_189983_j != 0.0f) {
                IBlockState iblockstate1;
                BlockPos blockpos;
                IBlockState iblockstate;
                Vec3d vec3d = new Vec3d(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
                double d0 = this.field_70165_t + (double)p_189810_1_;
                double d1 = this.field_70161_v + (double)p_189810_2_;
                Vec3d vec3d1 = new Vec3d(d0, this.func_174813_aQ().field_72338_b, d1);
                Vec3d vec3d2 = new Vec3d((double)p_189810_1_, 0.0, (double)p_189810_2_);
                float f = this.func_70689_ay();
                float f1 = (float)vec3d2.func_189985_c();
                if (f1 <= 0.001f) {
                    float f2 = f * vec2f.field_189982_i;
                    float f3 = f * vec2f.field_189983_j;
                    float f4 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f5 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    vec3d2 = new Vec3d((double)(f2 * f5 - f3 * f4), vec3d2.field_72448_b, (double)(f3 * f5 + f2 * f4));
                    f1 = (float)vec3d2.func_189985_c();
                    if (f1 <= 0.001f) {
                        return;
                    }
                }
                float f12 = (float)MathHelper.func_181161_i((double)f1);
                Vec3d vec3d12 = vec3d2.func_186678_a((double)f12);
                Vec3d vec3d13 = this.func_189651_aD();
                float f13 = (float)(vec3d13.field_72450_a * vec3d12.field_72450_a + vec3d13.field_72449_c * vec3d12.field_72449_c);
                if (f13 >= -0.15f && (iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72337_e, this.field_70161_v))).func_185890_d((IBlockAccess)this.field_70170_p, blockpos) == null && (iblockstate1 = this.field_70170_p.func_180495_p(blockpos = blockpos.func_177984_a())).func_185890_d((IBlockAccess)this.field_70170_p, blockpos) == null) {
                    float f14;
                    float f6 = 7.0f;
                    float f7 = 1.2f;
                    if (this.func_70644_a(MobEffects.field_76430_j)) {
                        f7 += (float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.75f;
                    }
                    float f8 = Math.max(f * 7.0f, 1.0f / f12);
                    Vec3d vec3d4 = vec3d1.func_178787_e(vec3d12.func_186678_a((double)f8));
                    float f9 = this.field_70130_N;
                    float f10 = this.field_70131_O;
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(vec3d, vec3d4.func_72441_c(0.0, (double)f10, 0.0)).func_72314_b((double)f9, 0.0, (double)f9);
                    Vec3d lvt_19_1_ = vec3d.func_72441_c(0.0, (double)0.51f, 0.0);
                    vec3d4 = vec3d4.func_72441_c(0.0, (double)0.51f, 0.0);
                    Vec3d vec3d5 = vec3d12.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
                    Vec3d vec3d6 = vec3d5.func_186678_a((double)(f9 * 0.5f));
                    Vec3d vec3d7 = lvt_19_1_.func_178788_d(vec3d6);
                    Vec3d vec3d8 = vec3d4.func_178788_d(vec3d6);
                    Vec3d vec3d9 = lvt_19_1_.func_178787_e(vec3d6);
                    Vec3d vec3d10 = vec3d4.func_178787_e(vec3d6);
                    List list = this.field_70170_p.func_184144_a((Entity)this, axisalignedbb);
                    if (!list.isEmpty()) {
                        // empty if block
                    }
                    float f11 = Float.MIN_VALUE;
                    for (AxisAlignedBB axisalignedbb2 : list) {
                        if (!axisalignedbb2.func_189973_a(vec3d7, vec3d8) && !axisalignedbb2.func_189973_a(vec3d9, vec3d10)) continue;
                        f11 = (float)axisalignedbb2.field_72337_e;
                        Vec3d vec3d11 = axisalignedbb2.func_189972_c();
                        BlockPos blockpos1 = new BlockPos(vec3d11);
                        int i = 1;
                        while (!((float)i >= f7)) {
                            IBlockState iblockstate3;
                            BlockPos blockpos2 = blockpos1.func_177981_b(i);
                            IBlockState iblockstate2 = this.field_70170_p.func_180495_p(blockpos2);
                            AxisAlignedBB axisalignedbb1 = iblockstate2.func_185890_d((IBlockAccess)this.field_70170_p, blockpos2);
                            if (axisalignedbb1 != null && (double)(f11 = (float)axisalignedbb1.field_72337_e + (float)blockpos2.func_177956_o()) - this.func_174813_aQ().field_72338_b > (double)f7) {
                                return;
                            }
                            if (i > 1 && (iblockstate3 = this.field_70170_p.func_180495_p(blockpos = blockpos.func_177984_a())).func_185890_d((IBlockAccess)this.field_70170_p, blockpos) != null) {
                                return;
                            }
                            ++i;
                        }
                        break block0;
                    }
                    if (f11 != Float.MIN_VALUE && (f14 = (float)((double)f11 - this.func_174813_aQ().field_72338_b)) > 0.5f && f14 <= f7) {
                        this.autoJumpTime = 1;
                    }
                }
            }
        }
    }
}

