/*
 * Decompiled with CFR 0.152.
 */
package com.kapiteon.freecam;

import com.google.common.base.Strings;
import com.kapiteon.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetHandlerPlayClientWrapper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="freecam")
public class FreeCam {
    public static String modName = "freecam";
    public NetHandlerPlayClientWrapper netHandler;
    private static final Logger LOGGER = LogManager.getLogger();
    private static FreeCam instance = null;
    private KeyBinding[] keys = new KeyBinding[0];
    private boolean enabled = false;
    public Minecraft mc;
    private double posX_fake;
    private double posY_fake;
    private double posZ_fake;
    private float yaw_fake;
    private float pitch_fake;
    private String state;
    private GameType oldGameType;
    private PlayerAbilities oldCapabilities;
    public static ConnectingScreen connectingScreen;

    public FreeCam() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        instance = this;
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        instance = this;
        this.keys = new KeyBinding[1];
        this.keys[0] = new KeyBinding(modName + "(ON/OFF)", 295, modName);
        for (KeyBinding key : this.keys) {
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
        this.mc = Minecraft.func_71410_x();
        this.setState(this.enabled);
    }

    public void Enable() {
        this.posX_fake = this.mc.field_71439_g.func_226277_ct_();
        this.posY_fake = this.mc.field_71439_g.func_226278_cu_();
        this.posZ_fake = this.mc.field_71439_g.func_226281_cx_();
        this.yaw_fake = this.mc.field_71439_g.field_70177_z;
        this.pitch_fake = this.mc.field_71439_g.field_70125_A;
        NetHandlerPlayClientWrapper cfr_ignored_0 = FreeCam.getInstance().netHandler;
        NetHandlerPlayClientWrapper.sendProcessors.add(packetIn -> {
            if (packetIn instanceof CPlayerAbilitiesPacket) {
                CPlayerAbilitiesPacket packet = (CPlayerAbilitiesPacket)packetIn;
                FreeCam.getInstance().netHandler.wrapped.func_147297_a((IPacket)new CPlayerAbilitiesPacket(this.oldCapabilities));
                return true;
            }
            if (packetIn instanceof CInputPacket) {
                CInputPacket packet = (CInputPacket)packetIn;
                return true;
            }
            if (packetIn instanceof CEntityActionPacket) {
                CEntityActionPacket packet = (CEntityActionPacket)packetIn;
                return true;
            }
            if (packetIn.getClass() == CPlayerPacket.class) {
                CPlayerPacket packet = (CPlayerPacket)packetIn;
                FreeCam.getInstance().netHandler.wrapped.func_147297_a((IPacket)new CPlayerPacket(true));
                return true;
            }
            if (packetIn instanceof CPlayerPacket.PositionPacket) {
                CPlayerPacket.PositionPacket packet = (CPlayerPacket.PositionPacket)packetIn;
                FreeCam.getInstance().netHandler.wrapped.func_147297_a((IPacket)new CPlayerPacket.PositionPacket(this.posX_fake, this.posY_fake, this.posZ_fake, true));
                return true;
            }
            if (packetIn instanceof CPlayerPacket.RotationPacket) {
                CPlayerPacket.RotationPacket packet = (CPlayerPacket.RotationPacket)packetIn;
                FreeCam.getInstance().netHandler.wrapped.func_147297_a((IPacket)new CPlayerPacket.RotationPacket(this.yaw_fake, this.pitch_fake, true));
                return true;
            }
            return false;
        });
        Helper.setValueToFinal(this.mc.field_71439_g, ClientPlayNetHandler.class, (Object)FreeCam.getInstance().netHandler);
        Helper.setValueToFinal(this.mc.field_71442_b, ClientPlayNetHandler.class, (Object)FreeCam.getInstance().netHandler);
        this.oldGameType = this.mc.field_71442_b.func_178889_l();
        this.oldCapabilities = this.mc.field_71439_g.field_71075_bZ;
        Helper.setValueToFinal(this.mc.field_71439_g, this.mc.field_71439_g.field_71075_bZ.getClass(), new PlayerAbilities());
        this.mc.field_71439_g.field_71075_bZ.field_75101_c = true;
        this.mc.field_71439_g.field_71075_bZ.field_75100_b = true;
        this.mc.field_71442_b.func_78746_a(GameType.SPECTATOR);
        this.mc.field_71439_g.func_71033_a(GameType.SPECTATOR);
        FreeCam.getInstance().netHandler.setGameType(this.mc.field_71439_g.func_146103_bH().getId(), GameType.SPECTATOR);
        this.enabled = true;
    }

    public void Disable() {
        Helper.setValueToFinal(this.mc.field_71439_g, this.mc.field_71439_g.field_71075_bZ.getClass(), this.oldCapabilities);
        FreeCam.getInstance().netHandler.setGameType(this.mc.field_71439_g.func_146103_bH().getId(), this.oldGameType);
        this.mc.field_71442_b.func_78746_a(this.oldGameType);
        this.mc.field_71439_g.func_71033_a(this.oldGameType);
        NetHandlerPlayClientWrapper cfr_ignored_0 = FreeCam.getInstance().netHandler;
        NetHandlerPlayClientWrapper.sendProcessors.clear();
        this.mc.field_71439_g.func_70107_b(this.posX_fake, this.posY_fake, this.posZ_fake);
        this.mc.field_71439_g.func_70080_a(this.posX_fake, this.posY_fake, this.posZ_fake, this.yaw_fake, this.pitch_fake);
        this.mc.field_71439_g.func_213293_j(0.0, 0.0, 0.0);
        Helper.setValueToFinal(this.mc.field_71439_g, ClientPlayNetHandler.class, FreeCam.getInstance().netHandler.wrapped);
        Helper.setValueToFinal(this.mc.field_71442_b, ClientPlayNetHandler.class, FreeCam.getInstance().netHandler.wrapped);
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public KeyBinding[] getKeys() {
        return this.keys;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(InputEvent.KeyInputEvent event) {
        if (this.keys[0].func_151468_f()) {
            if (this.enabled) {
                this.Disable();
            } else {
                this.Enable();
            }
            this.setState(this.enabled);
        }
    }

    private void setState(boolean enabled) {
        this.state = TextFormatting.RESET + modName + " " + (enabled ? TextFormatting.GREEN : TextFormatting.RED) + (enabled ? "ENABLED" : "DISABLED");
    }

    public void initNetHandler() {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            INetHandler inh;
            NetworkManager networkManager = null;
            if (connectingScreen != null) {
                networkManager = (NetworkManager)Helper.getValueReflection(connectingScreen, NetworkManager.class);
                connectingScreen = null;
            } else {
                networkManager = (NetworkManager)Helper.getValueReflection(mc, NetworkManager.class);
            }
            if (networkManager != null && (inh = (INetHandler)Helper.getValueReflection(networkManager, INetHandler.class)) instanceof ClientPlayNetHandler) {
                ClientPlayNetHandler nhpc = (ClientPlayNetHandler)inh;
                if (this.netHandler == null) {
                    this.netHandler = new NetHandlerPlayClientWrapper(mc, mc.field_71462_r, networkManager, nhpc.func_175105_e(), nhpc, this);
                } else {
                    this.netHandler.setWrapped(nhpc);
                }
                networkManager.func_150719_a((INetHandler)this.netHandler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onWorldEventLoad(WorldEvent.Load event) {
        this.initNetHandler();
    }

    @SubscribeEvent
    public void onGuiScreen(GuiOpenEvent event) {
        if (event instanceof GuiOpenEvent && event.getGui() instanceof ConnectingScreen) {
            connectingScreen = (ConnectingScreen)event.getGui();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onConnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.enabled = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onEvent(RenderGameOverlayEvent.Text event) throws IllegalAccessException {
        if (this.mc.field_71474_y.field_74330_P) {
            String s = this.state;
            int lineNum = 1;
            if (!Strings.isNullOrEmpty((String)s)) {
                int stringHeight = 9;
                int stringWidth = this.mc.field_71466_p.func_78256_a(s);
                int stringStartX = this.mc.func_228018_at_().func_198107_o() - 2 - stringWidth;
                int stringStartY = this.mc.func_228018_at_().func_198087_p() - (2 + stringHeight * lineNum);
                AbstractGui.fill((int)(stringStartX - 1), (int)stringStartY, (int)(stringStartX + stringWidth + 1), (int)(stringStartY + stringHeight - 1), (int)-1873784752);
                this.mc.field_71466_p.func_211126_b(s, (float)stringStartX, (float)stringStartY, 0xE0E0E0);
            }
        }
    }

    public static FreeCam getInstance() {
        return instance;
    }
}

