/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDeleteObject;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.theme.QuestTheme;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.LogicalSide;

public class ClientQuestFile
extends QuestFile {
    public static ClientQuestFile INSTANCE;
    public PlayerData self;
    public GuiQuests questTreeGui;
    public GuiBase questGui;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    @Override
    public void load(UUID s) {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        this.self = Objects.requireNonNull(this.getData(s));
        INSTANCE = this;
        this.refreshGui();
        FTBQuestsJEIHelper.refresh(this);
    }

    @Override
    public boolean canEdit() {
        return this.self.getCanEdit();
    }

    public void refreshGui() {
        this.clearCachedData();
        boolean hasPrev = false;
        boolean guiOpen = false;
        int zoom = 0;
        double scrollX = 0.0;
        double scrollY = 0.0;
        int selectedChapter = 0;
        int[] selectedQuests = new int[]{};
        if (this.questTreeGui != null) {
            hasPrev = true;
            zoom = this.questTreeGui.zoom;
            scrollX = this.questTreeGui.questPanel.centerQuestX;
            scrollY = this.questTreeGui.questPanel.centerQuestY;
            selectedChapter = this.questTreeGui.selectedChapter == null ? 0 : this.questTreeGui.selectedChapter.id;
            selectedQuests = new int[this.questTreeGui.selectedObjects.size()];
            int i = 0;
            for (Movable m : this.questTreeGui.selectedObjects) {
                if (m instanceof Quest) {
                    selectedQuests[i] = ((Quest)m).id;
                }
                ++i;
            }
            if (ClientUtils.getCurrentGuiAs(GuiQuests.class) != null) {
                guiOpen = true;
            }
        }
        this.questTreeGui = new GuiQuests(this);
        this.questGui = this.questTreeGui;
        if (hasPrev) {
            this.questTreeGui.zoom = zoom;
            this.questTreeGui.selectChapter(this.getChapter(selectedChapter));
            for (int i : selectedQuests) {
                Quest q = this.getQuest(i);
                if (q == null) continue;
                this.questTreeGui.selectedObjects.add(q);
            }
            if (guiOpen) {
                this.questTreeGui.openGui();
            }
        }
        this.questTreeGui.refreshWidgets();
        if (hasPrev) {
            this.questTreeGui.questPanel.scrollTo(scrollX, scrollY);
        }
    }

    public void openQuestGui() {
        if (this.disableGui && !this.self.getCanEdit()) {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("item.ftbquests.book.disabled"), true);
        } else if (ClientQuestFile.exists()) {
            this.questGui.openGui();
        }
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void deleteObject(int id) {
        new MessageDeleteObject(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }
}

