/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.events.ClearFileCacheEvent;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.task.ObservationTask;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.sidebar.SidebarButtonCreatedEvent;
import com.feed_the_beast.mods.ftbguilibrary.widget.CustomClickEvent;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    private List<ObservationTask> observationTasks = null;
    private ObservationTask currentlyObserving = null;
    private long currentlyObservingTicks = 0L;

    public void init() {
        MinecraftForge.EVENT_BUS.addListener(this::registerItemColors);
        MinecraftForge.EVENT_BUS.addListener(this::onSidebarButtonCreated);
        MinecraftForge.EVENT_BUS.addListener(this::onFileCacheClear);
        MinecraftForge.EVENT_BUS.addListener(this::onKeyEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onCustomClick);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::onScreenRender);
    }

    private void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, tintIndex) -> {
            LootCrate crate = ItemLootCrate.getCrate(null, stack);
            return crate == null ? -1 : 0xFF000000 | crate.color.rgb();
        }, new IItemProvider[]{FTBQuestsItems.LOOTCRATE});
    }

    private void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists() && ClientQuestFile.INSTANCE.self.hasUnclaimedRewards()) {
                    return "[!]";
                }
                return "";
            });
        }
    }

    private void onFileCacheClear(ClearFileCacheEvent event) {
        this.observationTasks = null;
    }

    private void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBQuestsClient.KEY_QUESTS.func_151468_f()) {
            ClientQuestFile.INSTANCE.openQuestGui();
        }
    }

    private void onCustomClick(CustomClickEvent event) {
        if (event.getId().func_110624_b().equals("ftbquests") && "open_gui".equals(event.getId().func_110623_a())) {
            if (!ClientQuestFile.exists()) {
                Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new StringTextComponent("Error?! Server doesn't have FTB Quests!"), null));
            } else {
                ClientQuestFile.INSTANCE.openQuestGui();
            }
            event.setCanceled(true);
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71441_e != null && ClientQuestFile.exists()) {
            if (this.observationTasks == null) {
                this.observationTasks = ClientQuestFile.INSTANCE.collect(ObservationTask.class);
            }
            if (this.observationTasks.isEmpty()) {
                return;
            }
            this.currentlyObserving = null;
            for (ObservationTask task : this.observationTasks) {
                if (ClientQuestFile.INSTANCE.self.isComplete(task) || !task.matcher.check((PlayerEntity)mc.field_71439_g, mc.field_71476_x) || !ClientQuestFile.INSTANCE.self.canStartTasks(task.quest)) continue;
                this.currentlyObserving = task;
                break;
            }
            if (this.currentlyObserving != null) {
                if (!mc.func_147113_T()) {
                    ++this.currentlyObservingTicks;
                }
                if (this.currentlyObservingTicks >= this.currentlyObserving.ticks) {
                    new MessageSubmitTask(this.currentlyObserving.id).sendToServer();
                    ClientQuestFile.INSTANCE.self.getTaskData(this.currentlyObserving).addProgress(1L);
                    this.currentlyObserving = null;
                    this.currentlyObservingTicks = 0L;
                }
            } else {
                this.currentlyObservingTicks = 0L;
            }
        }
    }

    private void onScreenRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || !ClientQuestFile.exists()) {
            return;
        }
        ClientQuestFile file = ClientQuestFile.INSTANCE;
        PlayerData data = file.self;
        GlStateManager.func_227740_m_();
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack matrixStack = event.getMatrixStack();
        int cy = event.getWindow().func_198087_p() / 2;
        if (this.currentlyObserving != null) {
            int cx = event.getWindow().func_198107_o() / 2;
            IFormattableTextComponent cot = this.currentlyObserving.getTitle().func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE});
            int sw = mc.field_71466_p.func_238414_a_((ITextProperties)cot);
            int bw = Math.max(sw, 100);
            Color4I.DARK_GRAY.withAlpha(130).draw(matrixStack, cx - bw / 2 - 3, cy - 63, bw + 6, 29);
            GuiHelper.drawHollowRect((MatrixStack)matrixStack, (int)(cx - bw / 2 - 3), (int)(cy - 63), (int)(bw + 6), (int)29, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)cot, (float)cx - (float)sw / 2.0f, (float)(cy - 60), 0xFFFFFF);
            double completed = (double)((float)this.currentlyObservingTicks + event.getPartialTicks()) / (double)this.currentlyObserving.ticks;
            GuiHelper.drawHollowRect((MatrixStack)matrixStack, (int)(cx - bw / 2), (int)(cy - 49), (int)bw, (int)12, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            Color4I.LIGHT_BLUE.withAlpha(130).draw(matrixStack, cx - bw / 2 + 1, cy - 48, (int)(((double)bw - 2.0) * completed), 10);
            String cop = this.currentlyObservingTicks * 100L / this.currentlyObserving.ticks + "%";
            mc.field_71466_p.func_238405_a_(matrixStack, cop, (float)cx - (float)mc.field_71466_p.func_78256_a(cop) / 2.0f, (float)(cy - 47), 0xFFFFFF);
        }
        if (!data.pinnedQuests.isEmpty()) {
            ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
            boolean first = true;
            if (data.pinnedQuests.contains(1)) {
                for (Chapter chapter : file.chapters) {
                    for (Quest quest : chapter.quests) {
                        if (data.isComplete(quest) || !data.canStartTasks(quest)) continue;
                        if (first) {
                            first = false;
                            continue;
                        }
                        list.add(IReorderingProcessor.field_242232_a);
                    }
                }
            } else {
                IntIterator sw = data.pinnedQuests.iterator();
                while (sw.hasNext()) {
                    int q = (Integer)sw.next();
                    Quest quest = file.getQuest(q);
                    if (quest == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        list.add(IReorderingProcessor.field_242232_a);
                    }
                    if (!data.isComplete(quest)) continue;
                    StringTextComponent component = new StringTextComponent("");
                    component.func_230529_a_((ITextComponent)quest.getTitle().func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.GREEN}));
                    component.func_230529_a_((ITextComponent)new StringTextComponent(" 100%").func_240699_a_(TextFormatting.DARK_GREEN));
                    list.addAll(mc.field_71466_p.func_238425_b_((ITextProperties)component, 160));
                }
            }
            if (!list.isEmpty()) {
                int mw = 0;
                for (IReorderingProcessor s : list) {
                    mw = Math.max(mw, (int)mc.field_71466_p.func_238420_b_().func_243238_a(s));
                }
                float scale = ((Double)ThemeProperties.PINNED_QUEST_SIZE.get(file)).floatValue();
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)((float)event.getWindow().func_198107_o() - (float)mw * scale) - 8.0, (double)cy - (double)list.size() * 4.5 * (double)scale, 100.0);
                matrixStack.func_227862_a_(scale, scale, 1.0f);
                Color4I.BLACK.withAlpha(100).draw(matrixStack, 0, 0, mw + 8, list.size() * 9 + 8);
                for (int i = 0; i < list.size(); ++i) {
                    mc.field_71466_p.func_238407_a_(matrixStack, (IReorderingProcessor)list.get(i), 4.0f, (float)(i * 9 + 4), -1);
                }
                matrixStack.func_227865_b_();
            }
        }
    }
}

