/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigDouble;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetVerticalSpace;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiEditRewardTable
extends GuiButtonListBase {
    private final RewardTable originalTable;
    private final RewardTable rewardTable;
    private final Runnable callback;

    public GuiEditRewardTable(RewardTable r, Runnable c) {
        this.originalTable = r;
        this.rewardTable = new RewardTable(this.originalTable.file);
        CompoundNBT nbt = new CompoundNBT();
        this.originalTable.writeData(nbt);
        this.rewardTable.readData(nbt);
        this.callback = c;
        this.setTitle((ITextComponent)new TranslationTextComponent("ftbquests.reward_table"));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        panel.add((Widget)new ButtonRewardTableSettings(panel));
        panel.add((Widget)new ButtonSaveRewardTable(panel));
        panel.add((Widget)new ButtonAddWeightedReward(panel));
        panel.add((Widget)new WidgetVerticalSpace(panel, 1));
        for (WeightedReward r : this.rewardTable.rewards) {
            panel.add((Widget)new ButtonWeightedReward(panel, r));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ButtonWeightedReward
    extends SimpleTextButton {
        private final WeightedReward reward;

        private ButtonWeightedReward(Panel panel, WeightedReward r) {
            super(panel, (ITextComponent)r.reward.getTitle(), r.reward.getIcon());
            this.reward = r;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.reward.reward.addMouseOverText(list);
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.reward_table.weight").func_240702_b_(": " + this.reward.weight).func_230529_a_((ITextComponent)new StringTextComponent(" [" + WeightedReward.chanceString(this.reward.weight, GuiEditRewardTable.this.rewardTable.getTotalWeight(true)) + "]").func_240699_a_(TextFormatting.DARK_GRAY)));
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.edit"), GuiIcons.SETTINGS, () -> {
                ConfigGroup group = new ConfigGroup("ftbquests");
                this.reward.reward.getConfig(this.reward.reward.createSubGroup(group));
                group.savedCallback = accepted -> this.run();
                new GuiEditConfig(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.reward_table.set_weight"), GuiIcons.SETTINGS, () -> {
                ConfigDouble c = new ConfigDouble(0.0, Double.POSITIVE_INFINITY);
                GuiEditConfigFromString.open((ConfigFromString)c, (Object)this.reward.weight, (Object)1.0, accepted -> {
                    if (accepted) {
                        this.reward.weight = ((Double)c.value).intValue();
                        if ((Double)c.value < 1.0) {
                            for (WeightedReward reward : ((GuiEditRewardTable)GuiEditRewardTable.this).rewardTable.rewards) {
                                reward.weight = (int)((double)reward.weight / (Double)c.value);
                            }
                            this.reward.weight = 1;
                        }
                    }
                    this.run();
                });
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.delete"), GuiIcons.REMOVE, () -> {
                ((GuiEditRewardTable)GuiEditRewardTable.this).rewardTable.rewards.remove(this.reward);
                GuiEditRewardTable.this.refreshWidgets();
            }).setYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{this.reward.reward.getTitle()})));
            GuiEditRewardTable.this.openContextMenu(contextMenu);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.reward.reward.getIngredient();
        }
    }

    private class ButtonAddWeightedReward
    extends SimpleTextButton {
        private ButtonAddWeightedReward(Panel panel) {
            super(panel, (ITextComponent)new TranslationTextComponent("gui.add"), GuiIcons.ADD);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (RewardType type : RewardType.getRegistry()) {
                if (type.getExcludeFromListRewards()) continue;
                contextMenu.add(new ContextMenuItem((ITextComponent)type.getDisplayName(), type.getIcon(), () -> {
                    this.playClickSound();
                    type.getGuiProvider().openCreationGui((Runnable)((Object)this), ((GuiEditRewardTable)GuiEditRewardTable.this).rewardTable.fakeQuest, reward -> {
                        ((GuiEditRewardTable)GuiEditRewardTable.this).rewardTable.rewards.add(new WeightedReward((Reward)reward, 1));
                        this.openGui();
                    });
                }));
            }
            this.getGui().openContextMenu(contextMenu);
        }
    }

    private class ButtonSaveRewardTable
    extends SimpleTextButton {
        private ButtonSaveRewardTable(Panel panel) {
            super(panel, (ITextComponent)new TranslationTextComponent("gui.accept"), GuiIcons.ACCEPT);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.closeGui();
            CompoundNBT nbt = new CompoundNBT();
            GuiEditRewardTable.this.rewardTable.writeData(nbt);
            GuiEditRewardTable.this.originalTable.readData(nbt);
            GuiEditRewardTable.this.callback.run();
        }
    }

    private class ButtonRewardTableSettings
    extends SimpleTextButton {
        private ButtonRewardTableSettings(Panel panel) {
            super(panel, (ITextComponent)new TranslationTextComponent("gui.settings"), GuiIcons.SETTINGS);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigGroup group = new ConfigGroup("ftbquests");
            GuiEditRewardTable.this.rewardTable.getConfig(GuiEditRewardTable.this.rewardTable.createSubGroup(group));
            group.savedCallback = accepted -> this.run();
            new GuiEditConfig(group).openGui();
        }
    }
}

