/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageGetEmergencyItems;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetLayout;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiEmergencyItems
extends GuiBase {
    private final long endTime;
    private boolean done;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public GuiEmergencyItems() {
        this.endTime = System.currentTimeMillis() + (long)ClientQuestFile.INSTANCE.emergencyItemsCooldown * 1000L;
        this.done = false;
        this.cancelButton = new SimpleTextButton((Panel)this, (ITextComponent)new TranslationTextComponent("gui.cancel"), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                this.getGui().closeGui();
            }
        };
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack stack : ClientQuestFile.INSTANCE.emergencyItems) {
                    this.add(new EmergencyItem(this, stack));
                }
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
                this.setHeight(22);
                this.setPos((GuiEmergencyItems.this.width - ((GuiEmergencyItems)GuiEmergencyItems.this).itemPanel.width) / 2, GuiEmergencyItems.this.height * 2 / 3 - 10);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        long left = this.endTime - System.currentTimeMillis();
        if (left <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle((ITextComponent)new TranslationTextComponent("gui.close"));
                new MessageGetEmergencyItems().sendToServer();
            }
            left = 0L;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((int)((float)w / 2.0f)), (double)((int)((float)h / 5.0f)), 0.0);
        matrixStack.func_227862_a_(2.0f, 2.0f, 1.0f);
        String s = I18n.func_135052_a((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(matrixStack, (Object)s, (float)(-theme.getStringWidth(s)) / 2.0f, 0.0f, Color4I.WHITE, 0);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((int)((float)w / 2.0f)), (double)((int)((float)h / 2.5f)), 0.0);
        matrixStack.func_227862_a_(4.0f, 4.0f, 1.0f);
        s = left <= 0L ? "00:00" : StringUtils.getTimeString((long)(left / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(matrixStack, (Object)s, (float)(x1 - 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)(x1 + 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, -1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 0.0f, Color4I.WHITE, 0);
        matrixStack.func_227865_b_();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class EmergencyItem
    extends Widget {
        private final ItemStack stack;

        public EmergencyItem(Panel p, ItemStack is) {
            super(p);
            this.setY(3);
            this.stack = is;
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList list1 = new ArrayList();
            GuiHelper.addStackTooltip((ItemStack)this.stack, list1);
            for (ITextComponent t : list1) {
                list.add(t);
            }
        }

        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            QuestShape.get((String)"rsquare").outline.draw(matrixStack, x - 3, y - 3, w + 6, h + 6);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 100.0);
            GuiHelper.drawItem((MatrixStack)matrixStack, (ItemStack)this.stack, (double)x, (double)y, (float)1.0f, (float)1.0f, (boolean)true, null);
            matrixStack.func_227865_b_();
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.stack;
        }
    }
}

