/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.net.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiRewardTables
extends GuiButtonListBase {
    public GuiRewardTables() {
        this.setTitle((ITextComponent)new TranslationTextComponent("ftbquests.reward_tables"));
        this.setHasSearchBox(true);
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        SimpleTextButton button = new SimpleTextButton(panel, (ITextComponent)new TranslationTextComponent("gui.add"), GuiIcons.ADD){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                ConfigString c = new ConfigString();
                GuiEditConfigFromString.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                    if (accepted) {
                        RewardTable table = new RewardTable(ClientQuestFile.INSTANCE);
                        table.title = (String)c.value;
                        new MessageCreateObject(table, null).sendToServer();
                    }
                    this.openGui();
                });
            }
        };
        button.setHeight(14);
        panel.add((Widget)button);
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            panel.add((Widget)new ButtonRewardTable(panel, table));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ButtonRewardTable
    extends SimpleTextButton {
        private final RewardTable table;

        public ButtonRewardTable(Panel panel, RewardTable t) {
            super(panel, (ITextComponent)t.getTitle(), t.getIcon());
            this.table = t;
            this.setHeight(14);
            if (this.table.lootCrate != null) {
                this.title = this.title.func_230532_e_().func_240699_a_(TextFormatting.YELLOW);
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (button.isLeft()) {
                this.table.onEditButtonClicked((Runnable)((Object)this));
                return;
            }
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuests.addObjectMenuItems(contextMenu, (Runnable)((Object)GuiRewardTables.this), this.table);
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("item.ftbquests.lootcrate"), GuiIcons.ACCEPT, () -> {
                if (this.table.lootCrate == null) {
                    this.table.lootCrate = new LootCrate(this.table);
                    Matcher matcher = Pattern.compile("[^a-z0-9_]").matcher(this.table.getUnformattedTitle().toLowerCase());
                    Matcher matcher1 = Pattern.compile("_{2,}").matcher(matcher.replaceAll("_"));
                    switch (this.table.lootCrate.stringID = matcher1.replaceAll("_")) {
                        case "common": {
                            this.table.lootCrate.color = Color4I.rgb((int)0x92999A);
                            this.table.lootCrate.drops.passive = 350;
                            this.table.lootCrate.drops.monster = 10;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "uncommon": {
                            this.table.lootCrate.color = Color4I.rgb((int)3648105);
                            this.table.lootCrate.drops.passive = 200;
                            this.table.lootCrate.drops.monster = 90;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "rare": {
                            this.table.lootCrate.color = Color4I.rgb((int)38143);
                            this.table.lootCrate.drops.passive = 50;
                            this.table.lootCrate.drops.monster = 200;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "epic": {
                            this.table.lootCrate.color = Color4I.rgb((int)0x8000FF);
                            this.table.lootCrate.drops.passive = 9;
                            this.table.lootCrate.drops.monster = 10;
                            this.table.lootCrate.drops.boss = 10;
                            break;
                        }
                        case "legendary": {
                            this.table.lootCrate.color = Color4I.rgb((int)16761159);
                            this.table.lootCrate.glow = true;
                            this.table.lootCrate.drops.passive = 1;
                            this.table.lootCrate.drops.monster = 1;
                            this.table.lootCrate.drops.boss = 190;
                        }
                    }
                    this.title = this.table.getTitle().func_240699_a_(TextFormatting.YELLOW);
                } else {
                    this.table.lootCrate = null;
                    this.title = this.table.getTitle();
                }
                new MessageEditObject(this.table).sendToServer();
            }){

                public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                    (((ButtonRewardTable)ButtonRewardTable.this).table.lootCrate != null ? GuiIcons.ACCEPT : GuiIcons.ACCEPT_GRAY).draw(matrixStack, x, y, w, h);
                }
            });
            this.getGui().openContextMenu(contextMenu);
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            int usedIn = 0;
            for (Chapter chapter : this.table.file.chapters) {
                for (Quest quest : chapter.quests) {
                    for (Reward reward : quest.rewards) {
                        if (!(reward instanceof RandomReward) || ((RandomReward)reward).table != this.table) continue;
                        ++usedIn;
                    }
                }
            }
            if (usedIn > 0) {
                list.add((ITextComponent)new TranslationTextComponent("ftbquests.reward_table.used_in", new Object[]{usedIn}).func_240699_a_(TextFormatting.GRAY));
            }
            this.table.addMouseOverText(list, true, true);
        }
    }
}

