/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageClaimChoiceReward;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.ChoiceReward;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSelectChoiceReward
extends GuiButtonListBase {
    private final ChoiceReward choiceReward;

    public GuiSelectChoiceReward(ChoiceReward r) {
        this.choiceReward = r;
        this.setTitle((ITextComponent)new TranslationTextComponent("ftbquests.reward.ftbquests.choice"));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        for (WeightedReward r : this.choiceReward.getTable().rewards) {
            panel.add((Widget)new ButtonChoiceReward(panel, r));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ButtonChoiceReward
    extends SimpleTextButton {
        private final WeightedReward weightedReward;

        private ButtonChoiceReward(Panel panel, WeightedReward r) {
            super(panel, (ITextComponent)r.reward.getTitle(), r.reward.getIcon());
            this.weightedReward = r;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.weightedReward.reward.addMouseOverText(list);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.closeGui();
            new MessageClaimChoiceReward(((GuiSelectChoiceReward)GuiSelectChoiceReward.this).choiceReward.id, ((GuiSelectChoiceReward)GuiSelectChoiceReward.this).choiceReward.getTable().rewards.indexOf(this.weightedReward)).sendToServer();
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.weightedReward.reward.getIngredient();
        }
    }
}

