/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSelectQuestObject<T extends QuestObjectBase>
extends GuiButtonListBase {
    private final ConfigQuestObject<T> config;
    private final ConfigCallback callback;

    public GuiSelectQuestObject(ConfigQuestObject<T> c, ConfigCallback cb) {
        this.setTitle((ITextComponent)new TranslationTextComponent("ftbquests.gui.select_quest_object"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.config = c;
        this.callback = cb;
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }

    public void addButtons(Panel panel) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase objectBase : ClientQuestFile.INSTANCE.getAllObjects()) {
            if (!this.config.predicate.test(objectBase)) continue;
            list.add(objectBase);
        }
        list.sort((o1, o2) -> {
            int i = Integer.compare(o1.getObjectType().ordinal(), o2.getObjectType().ordinal());
            return i == 0 ? o1.getUnformattedTitle().compareToIgnoreCase(o2.getUnformattedTitle()) : i;
        });
        if (this.config.predicate.test(null)) {
            panel.add((Widget)new ButtonQuestObject(this, panel, null));
        }
        for (QuestObjectBase objectBase : list) {
            panel.add((Widget)new ButtonQuestObject(this, panel, objectBase));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public static class ButtonQuestObject
    extends SimpleTextButton {
        public final T object;
        final /* synthetic */ GuiSelectQuestObject this$0;

        public ButtonQuestObject(@Nullable Panel panel, T o) {
            this.this$0 = this$0;
            super(panel, (ITextComponent)(o == null ? new TranslationTextComponent("ftbquests.null") : ((QuestObjectBase)o).getTitle().func_240699_a_(((QuestObjectBase)o).getObjectType().getColor())), (Icon)(o == null ? Icon.EMPTY : ((QuestObjectBase)o).getIcon()));
            this.object = o;
            this.setSize(200, 14);
        }

        private void addObject(TooltipList list, QuestObjectBase o) {
            list.add((ITextComponent)QuestObjectType.NAME_MAP.getDisplayName((Object)o.getObjectType()).func_230532_e_().func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)o.getTitle().func_240699_a_(o.getObjectType().getColor())));
        }

        public void addMouseOverText(TooltipList list) {
            if (this.object == null) {
                return;
            }
            list.add((ITextComponent)((QuestObjectBase)this.object).getTitle());
            list.add((ITextComponent)new StringTextComponent("ID: ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(((QuestObjectBase)this.object).toString()).func_240699_a_(TextFormatting.DARK_GRAY)));
            list.add((ITextComponent)new StringTextComponent("Type: ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)QuestObjectType.NAME_MAP.getDisplayName((Object)((QuestObjectBase)this.object).getObjectType()).func_230532_e_().func_240699_a_(((QuestObjectBase)this.object).getObjectType().getColor())));
            if (this.object instanceof Quest) {
                Quest quest = (Quest)this.object;
                this.addObject(list, quest.chapter);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add((ITextComponent)new TranslationTextComponent("ftbquests.rewards").func_240699_a_(TextFormatting.GRAY));
                    for (Reward reward : quest.rewards) {
                        list.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)reward.getTitle().func_240699_a_(QuestObjectType.REWARD.getColor())));
                    }
                }
            } else if (this.object instanceof Task) {
                Quest quest = ((Task)this.object).quest;
                this.addObject(list, quest.chapter);
                this.addObject(list, quest);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add((ITextComponent)new TranslationTextComponent("ftbquests.rewards").func_240699_a_(TextFormatting.GRAY));
                    for (Reward reward : quest.rewards) {
                        list.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)reward.getTitle().func_240699_a_(QuestObjectType.REWARD.getColor())));
                    }
                }
            } else if (this.object instanceof Reward) {
                Quest quest = ((Reward)this.object).quest;
                this.addObject(list, quest.chapter);
                this.addObject(list, quest);
            } else if (this.object instanceof RewardTable) {
                ((RewardTable)this.object).addMouseOverText(list, true, true);
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.this$0.config.setCurrentValue(this.object);
            this.this$0.callback.save(true);
        }
    }
}

