/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.net.MessageCreateObject;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonAddTask
extends Button {
    public final Quest quest;

    public ButtonAddTask(Panel panel, Quest q) {
        super(panel, (ITextComponent)new TranslationTextComponent("gui.add"), (Icon)ThemeProperties.ADD_ICON.get());
        this.quest = q;
        this.setSize(18, 18);
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        for (TaskType type : TaskType.getRegistry()) {
            contextMenu.add(new ContextMenuItem((ITextComponent)type.getDisplayName(), type.getIcon(), () -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, task -> {
                    CompoundNBT extra = new CompoundNBT();
                    extra.func_74778_a("type", type.getTypeForNBT());
                    new MessageCreateObject((QuestObjectBase)task, extra).sendToServer();
                });
            }));
        }
        this.getGui().openContextMenu(contextMenu);
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }
}

