/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.gui.quests.ButtonTab;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class ButtonChapter
extends ButtonTab {
    public Chapter chapter;

    public ButtonChapter(Panel panel, Chapter c) {
        super(panel, (ITextComponent)c.getTitle(), c.getIcon());
        this.chapter = c;
    }

    public void onClicked(MouseButton button) {
    }

    public void addMouseOverText(TooltipList list) {
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.viewQuestPanel.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.chapter == this.treeGui.selectedChapter || this.treeGui.selectedChapter != null && this.chapter == this.treeGui.selectedChapter.group) {
            Color4I backgroundColor = (Color4I)ThemeProperties.WIDGET_BACKGROUND.get(this.treeGui.selectedChapter);
            backgroundColor.draw(matrixStack, x + 1, y, w - 2, h);
        }
        if (this.treeGui.chapterHoverPanel.chapter == this) {
            return;
        }
        int is = this.width < 18 ? 8 : 16;
        this.icon.draw(matrixStack, x + (w - is) / 2, y + (h - is) / 2, is, is);
        if (this.chapter.quests.isEmpty() && !this.chapter.hasChildren()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 450.0);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.CLOSE_ICON.get()).draw(matrixStack, x + w - 10, y + 2, 8, 8);
            matrixStack.func_227865_b_();
            return;
        }
        if (this.treeGui.file.self.hasUnclaimedRewards(this.chapter)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 450.0);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(matrixStack, x + w - 7, y + 2, 6, 6);
            matrixStack.func_227865_b_();
        } else if (this.treeGui.file.self.isComplete(this.chapter)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 450.0);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 8, y + 1, 8, 8);
            matrixStack.func_227865_b_();
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.icon.getIngredient();
    }
}

