/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChapterImage;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonChapterImage
extends Button {
    public GuiQuests treeGui;
    public ChapterImage chapterImage;

    public ButtonChapterImage(Panel panel, ChapterImage i) {
        super(panel, StringTextComponent.field_240750_d_, i.image);
        this.treeGui = (GuiQuests)panel.getGui();
        this.setSize(20, 20);
        this.chapterImage = i;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver() && (!this.chapterImage.click.isEmpty() || this.treeGui.file.canEdit() && !button.isLeft())) {
            this.onClicked(button);
            return true;
        }
        return false;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.questPanel.mouseOverQuest != null || this.treeGui.movingObjects || this.treeGui.viewQuestPanel.isMouseOver() || this.treeGui.chapterHoverPanel.isMouseOverAnyWidget()) {
            return false;
        }
        if (this.chapterImage.click.isEmpty() && !this.treeGui.file.canEdit()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void onClicked(MouseButton button) {
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> {
                ConfigGroup group = new ConfigGroup("ftbquests");
                this.chapterImage.getConfig(group.getGroup("chapter").getGroup("image"));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        new MessageEditObject(this.chapterImage.chapter).sendToServer();
                    }
                    this.run();
                };
                new GuiEditConfig(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.chapterImage.chapter), () -> {
                this.treeGui.movingObjects = true;
                this.treeGui.selectedObjects.clear();
                this.treeGui.toggleSelected(this.chapterImage);
            }){

                public void addMouseOverText(TooltipList list) {
                    list.add((ITextComponent)new TranslationTextComponent("ftbquests.gui.move_tooltip").func_240699_a_(TextFormatting.DARK_GRAY));
                }
            });
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.chapterImage.chapter.images.remove(this.chapterImage);
                new MessageEditObject(this.chapterImage.chapter).sendToServer();
            }).setYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{this.chapterImage.image.toString()})));
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (!this.chapterImage.click.isEmpty()) {
                this.playClickSound();
                this.handleClick(this.chapterImage.click);
            }
        } else if (this.treeGui.file.canEdit() && button.isMiddle()) {
            if (!this.treeGui.selectedObjects.contains(this.chapterImage)) {
                this.treeGui.toggleSelected(this.chapterImage);
            }
            this.treeGui.movingObjects = true;
        }
    }

    public void addMouseOverText(TooltipList list) {
        for (String s : this.chapterImage.hover) {
            if (s.startsWith("{") && s.endsWith("}")) {
                list.add((ITextComponent)new TranslationTextComponent(s.substring(1, s.length() - 1)));
                continue;
            }
            list.add((ITextComponent)new StringTextComponent(s));
        }
    }

    public boolean shouldDraw() {
        return false;
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((int)((double)x + (double)w / 2.0)), (double)((int)((double)y + (double)h / 2.0)), 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.chapterImage.rotation));
        matrixStack.func_227862_a_((float)w / 2.0f, (float)h / 2.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.chapterImage.image.draw(matrixStack, -1, -1, 2, 2);
        matrixStack.func_227865_b_();
    }
}

