/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardTables;
import com.feed_the_beast.ftbquests.gui.quests.ButtonTab;
import com.feed_the_beast.ftbquests.net.MessageChangeProgress;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.theme.ThemeLoader;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ButtonEditSettings
extends ButtonTab {
    public ButtonEditSettings(Panel panel) {
        super(panel, (ITextComponent)new TranslationTextComponent("gui.settings"), (Icon)ThemeProperties.SETTINGS_ICON.get());
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (this.treeGui.contextMenu != null) {
            this.treeGui.closeContextMenu();
            return;
        }
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.edit_file"), (Icon)ThemeProperties.SETTINGS_ICON.get(), () -> this.treeGui.file.onEditButtonClicked((Runnable)((Object)this))));
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.uuid, this.treeGui.file.id, ChangeProgress.RESET).sendToServer()).setYesNo((ITextComponent)new TranslationTextComponent("ftbquests.gui.reset_progress_q")));
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.uuid, this.treeGui.file.id, ChangeProgress.COMPLETE).sendToServer()).setYesNo((ITextComponent)new TranslationTextComponent("ftbquests.gui.complete_instantly_q")));
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.reward_tables"), (Icon)ThemeProperties.REWARD_TABLE_ICON.get(), () -> new GuiRewardTables().openGui()));
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.save_as_file"), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), () -> {
            try {
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                File file = new File(Minecraft.func_71410_x().field_71412_D, fileName.toString()).getCanonicalFile();
                ClientQuestFile.INSTANCE.writeDataFull(file.toPath());
                TranslationTextComponent component = new TranslationTextComponent("ftbquests.gui.saved_as_file", new Object[]{file.getPath().replace(Minecraft.func_71410_x().field_71412_D.getCanonicalFile().getAbsolutePath(), "")});
                component.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)component, Util.field_240973_b_);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.reload_theme"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
            Minecraft mc = Minecraft.func_71410_x();
            ThemeLoader.loadTheme(mc.func_195551_G());
            ClientQuestFile.INSTANCE.refreshGui();
        }));
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.wiki"), GuiIcons.INFO, () -> this.handleClick("https://faq.ftb.world/books/ftb-quests")));
        this.treeGui.openContextMenu(contextMenu);
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }
}

