/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardNotifications;
import com.feed_the_beast.ftbquests.gui.quests.ButtonTab;
import com.feed_the_beast.ftbquests.net.MessageClaimAllRewards;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonModpack
extends ButtonTab {
    private final boolean unclaimedRewards;

    public ButtonModpack(Panel panel) {
        super(panel, StringTextComponent.field_240750_d_, ClientQuestFile.INSTANCE.getIcon());
        this.title = this.treeGui.file.getTitle();
        this.unclaimedRewards = this.treeGui.file.self.hasUnclaimedRewards();
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (ClientQuestFile.exists()) {
            new GuiRewardNotifications().openGui();
            new MessageClaimAllRewards().sendToServer();
        }
    }

    public void addMouseOverText(TooltipList list) {
        super.addMouseOverText(list);
        if (this.unclaimedRewards) {
            list.blankLine();
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.gui.collect_rewards").func_240699_a_(TextFormatting.GOLD));
        }
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.draw(matrixStack, theme, x, y, w, h);
        if (this.unclaimedRewards) {
            float s = (float)w / 2.0f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)(x + w) - s), (double)y, 500.0);
            matrixStack.func_227862_a_(s, s, 1.0f);
            ((Icon)ThemeProperties.ALERT_ICON.get(this.treeGui.file)).draw(matrixStack, 0, 0, 1, 1);
            matrixStack.func_227865_b_();
        }
    }
}

