/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonReward
extends Button {
    public final GuiQuests treeGui;
    public final Reward reward;

    public ButtonReward(Panel panel, Reward r) {
        super(panel, (ITextComponent)r.getTitle(), r.getIcon());
        this.treeGui = (GuiQuests)panel.getGui();
        this.reward = r;
        this.setSize(18, 18);
    }

    public ITextComponent getTitle() {
        if (this.reward.isTeamReward()) {
            return super.getTitle().func_230532_e_().func_240699_a_(TextFormatting.BLUE);
        }
        return super.getTitle();
    }

    public void addMouseOverText(TooltipList list) {
        if (ButtonReward.isShiftKeyDown() && ButtonReward.isCtrlKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(this.reward.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (this.reward.isTeamReward()) {
            Object ingredient;
            Object object;
            if (this.reward.addTitleInMouseOverText()) {
                list.add(this.getTitle());
            }
            if ((object = this.getIngredientUnderMouse()) instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap((Object)object)) instanceof ItemStack && !((ItemStack)ingredient).func_190926_b()) {
                ArrayList list1 = new ArrayList();
                GuiHelper.addStackTooltip((ItemStack)((ItemStack)ingredient), list1);
                list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            }
            list.blankLine();
            this.reward.addMouseOverText(list);
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.reward.team_reward").func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.UNDERLINE}));
        } else {
            if (this.reward.addTitleInMouseOverText()) {
                list.add(this.getTitle());
            }
            this.reward.addMouseOverText(list);
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!ClientQuestFile.exists() || !ClientQuestFile.INSTANCE.self.isComplete(this.reward.quest)) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.exists()) {
                this.reward.onButtonClicked(this, ClientQuestFile.INSTANCE.self.getClaimType(this.reward).canClaim());
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuests.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.reward);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.reward.getIngredient();
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        String s;
        int bs = h >= 32 ? 32 : 16;
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.treeGui.file.self == null) {
            return;
        }
        if (this.treeGui.contextMenu != null) {
            // empty if block
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 200.0);
        RenderSystem.enableBlend();
        boolean completed = false;
        if (this.treeGui.file.self.getClaimType(this.reward).isClaimed()) {
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
            completed = true;
        } else if (this.treeGui.file.self.isComplete(this.reward.quest)) {
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
        }
        matrixStack.func_227865_b_();
        if (!completed && !(s = this.reward.getButtonText()).isEmpty()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)x + 19.0f - (float)theme.getStringWidth(s) / 2.0f), (double)((float)y + 15.0f), 200.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            theme.drawString(matrixStack, (Object)s, 0.0f, 0.0f, Color4I.WHITE, 2);
            matrixStack.func_227865_b_();
        }
    }
}

