/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import dev.latvian.mods.itemfilters.api.ItemFiltersItems;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonTask
extends Button {
    public final GuiQuests treeGui;
    public Task task;

    public ButtonTask(Panel panel, Task t) {
        super(panel, (ITextComponent)t.getTitle(), GuiIcons.ACCEPT);
        this.treeGui = (GuiQuests)panel.getGui();
        this.task = t;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            this.task.onButtonClicked(this, !this.task.invalid && this.treeGui.file.self.canStartTasks(this.task.quest) && !this.treeGui.file.self.isComplete(this.task));
        } else if (button.isRight() && this.treeGui.file.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (this.task instanceof ItemTask) {
                final ItemTask i = (ItemTask)this.task;
                final Set tags = i.item.func_77973_b().getTags();
                if (!tags.isEmpty() && !ItemFiltersAPI.isFilter((ItemStack)i.item)) {
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.task.ftbquests.item.convert_tag"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
                        final ItemStack tagFilter = new ItemStack((IItemProvider)ItemFiltersItems.TAG);
                        if (tags.size() == 1) {
                            String tag = ((ResourceLocation)tags.iterator().next()).toString();
                            ((IStringValueFilter)tagFilter.func_77973_b()).setValue(tagFilter, tag);
                            i.item = tagFilter;
                            if (i.title.isEmpty()) {
                                i.title = "Any " + tag;
                            }
                            new MessageEditObject(i).sendToServer();
                        } else {
                            new GuiButtonListBase(){

                                public void addButtons(Panel panel) {
                                    for (final ResourceLocation s : tags) {
                                        panel.add((Widget)new SimpleTextButton(panel, (ITextComponent)new StringTextComponent(s.toString()), (Icon)Icon.EMPTY){

                                            public void onClicked(MouseButton button) {
                                                ButtonTask.this.treeGui.openGui();
                                                ((IStringValueFilter)tagFilter.func_77973_b()).setValue(tagFilter, s.toString());
                                                i.item = tagFilter;
                                                if (i.title.isEmpty()) {
                                                    i.title = "Any " + s;
                                                }
                                                new MessageEditObject(i).sendToServer();
                                            }
                                        });
                                    }
                                }
                            }.openGui();
                        }
                    }));
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                }
            }
            GuiQuests.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.task);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.task.getIngredient();
    }

    public void addMouseOverText(TooltipList list) {
        TaskData data;
        if (ButtonTask.isShiftKeyDown() && ButtonTask.isCtrlKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(this.task.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (this.task.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        if (this.treeGui.file.self.canStartTasks(this.task.quest)) {
            data = this.treeGui.file.self.getTaskData(this.task);
            long maxp = this.task.getMaxProgress();
            if (maxp > 1L) {
                if (this.task.hideProgressNumbers()) {
                    list.add((ITextComponent)new StringTextComponent("[" + data.getRelativeProgress() + "%]").func_240699_a_(TextFormatting.DARK_GREEN));
                } else {
                    String prog;
                    String max = ButtonTask.isShiftKeyDown() ? Long.toUnsignedString(maxp) : this.task.getMaxProgressString();
                    String string = prog = ButtonTask.isShiftKeyDown() ? Long.toUnsignedString(data.progress) : data.getProgressString();
                    if (maxp < 100L) {
                        list.add((ITextComponent)new StringTextComponent((data.progress > maxp ? max : prog) + " / " + max).func_240699_a_(TextFormatting.DARK_GREEN));
                    } else {
                        list.add((ITextComponent)new StringTextComponent((data.progress > maxp ? max : prog) + " / " + max).func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new StringTextComponent(" [" + data.getRelativeProgress() + "%]").func_240699_a_(TextFormatting.DARK_GRAY)));
                    }
                }
            }
        } else {
            data = null;
        }
        this.task.addMouseOverText(list, data);
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.treeGui.file.self.getTaskData(this.task), matrixStack, x, y, w, h);
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        int bs = h >= 32 ? 32 : 16;
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.treeGui.file.self == null) {
            return;
        }
        if (this.treeGui.contextMenu != null) {
            // empty if block
        }
        if (this.treeGui.file.self.isComplete(this.task)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
            matrixStack.func_227865_b_();
        } else {
            IFormattableTextComponent s = this.task.getButtonText();
            if (s != StringTextComponent.field_240750_d_) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)((float)x + 19.0f - (float)theme.getStringWidth((ITextProperties)s) / 2.0f), (double)((float)y + 15.0f), 200.0);
                matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
                RenderSystem.enableBlend();
                theme.drawString(matrixStack, (Object)s, 0.0f, 0.0f, Color4I.WHITE, 2);
                matrixStack.func_227865_b_();
            }
        }
    }
}

