/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.gui.quests.ButtonChapter;
import com.feed_the_beast.ftbquests.gui.quests.PanelChapterHover;
import com.feed_the_beast.ftbquests.gui.quests.PanelChapters;
import com.feed_the_beast.ftbquests.gui.quests.PanelOtherButtonsBottom;
import com.feed_the_beast.ftbquests.gui.quests.PanelOtherButtonsTop;
import com.feed_the_beast.ftbquests.gui.quests.PanelQuests;
import com.feed_the_beast.ftbquests.gui.quests.PanelViewQuest;
import com.feed_the_beast.ftbquests.net.MessageChangeProgress;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.theme.QuestTheme;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigWithVariants;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiQuests
extends GuiBase {
    public final ClientQuestFile file;
    public double scrollWidth;
    public double scrollHeight;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed;
    public Chapter selectedChapter;
    public final List<Movable> selectedObjects;
    public final PanelChapters chapterPanel;
    public final PanelQuests questPanel;
    public final PanelOtherButtonsBottom otherButtonsBottomPanel;
    public final PanelOtherButtonsTop otherButtonsTopPanel;
    public final PanelChapterHover chapterHoverPanel;
    public final PanelViewQuest viewQuestPanel;
    public boolean movingObjects = false;
    public int zoom = 16;
    public long lastShiftPress = 0L;
    public static boolean grid = false;

    public GuiQuests(ClientQuestFile q) {
        this.file = q;
        this.selectedObjects = new ArrayList<Movable>();
        this.chapterPanel = new PanelChapters((Panel)this);
        this.selectedChapter = this.file.chapters.isEmpty() ? null : (Chapter)this.file.chapters.get(0);
        this.questPanel = new PanelQuests((Panel)this);
        this.otherButtonsBottomPanel = new PanelOtherButtonsBottom((Panel)this);
        this.otherButtonsTopPanel = new PanelOtherButtonsTop((Panel)this);
        this.chapterHoverPanel = new PanelChapterHover((Panel)this);
        this.viewQuestPanel = new PanelViewQuest(this);
        this.selectChapter(null);
    }

    @Nullable
    public Quest getViewedQuest() {
        return this.viewQuestPanel.quest;
    }

    public void addWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.add((Widget)this.chapterPanel);
        this.add((Widget)this.questPanel);
        this.add((Widget)this.otherButtonsBottomPanel);
        this.add((Widget)this.otherButtonsTopPanel);
        this.add((Widget)this.chapterHoverPanel);
        this.add((Widget)this.viewQuestPanel);
    }

    public void alignWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.otherButtonsBottomPanel.alignWidgets();
        this.otherButtonsTopPanel.alignWidgets();
        this.chapterPanel.alignWidgets();
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        this.selectedObjects.clear();
        super.onClosed();
    }

    public void selectChapter(@Nullable Chapter chapter) {
        if (this.selectedChapter != chapter) {
            this.closeQuest();
            this.selectedChapter = chapter;
            this.questPanel.refreshWidgets();
            this.questPanel.resetScroll();
        }
    }

    public void viewQuest(Quest quest) {
        if (this.viewQuestPanel.quest != quest) {
            this.viewQuestPanel.quest = quest;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void onBack() {
        if (this.getViewedQuest() != null) {
            this.closeQuest();
        } else {
            super.onBack();
        }
    }

    public void closeQuest() {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.hidePanel = false;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void toggleSelected(Movable movable) {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.refreshWidgets();
        }
        if (!this.selectedObjects.add(movable)) {
            this.selectedObjects.remove(movable);
        }
    }

    public static void addObjectMenuItems(List<ContextMenuItem> contextMenu, Runnable gui, final QuestObjectBase object) {
        ConfigGroup group = new ConfigGroup("ftbquests");
        ConfigGroup g = object.createSubGroup(group);
        object.getConfig(g);
        if (!g.getValues().isEmpty()) {
            ArrayList<1> list = new ArrayList<1>();
            for (final ConfigValue c : g.getValues()) {
                if (!(c instanceof ConfigWithVariants)) continue;
                TranslationTextComponent name = new TranslationTextComponent(c.getNameKey());
                if (!c.getCanEdit()) {
                    name = name.func_240699_a_(TextFormatting.GRAY);
                }
                list.add(new ContextMenuItem((ITextComponent)name, GuiIcons.SETTINGS, null){

                    public void addMouseOverText(TooltipList list) {
                        list.add(c.getStringForGUI(c.value));
                    }

                    public void onClicked(Panel panel, MouseButton button) {
                        c.onClicked(button, accepted -> {
                            if (accepted) {
                                c2.setter.accept(c2.value);
                                new MessageEditObject(object).sendToServer();
                            }
                        });
                    }

                    public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                        c.getIcon(c.value).draw(matrixStack, x, y, w, h);
                    }
                });
            }
            if (!list.isEmpty()) {
                list.sort(null);
                contextMenu.addAll(list);
                contextMenu.add(ContextMenuItem.SEPARATOR);
            }
        }
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> object.onEditButtonClicked(gui)));
        if (object instanceof RandomReward && !QuestObjectBase.isNull(((RandomReward)object).getTable())) {
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.reward_table.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> ((RandomReward)object).getTable().onEditButtonClicked(gui)));
        }
        ContextMenuItem delete = new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> ClientQuestFile.INSTANCE.deleteObject(object.id));
        if (!GuiQuests.isShiftKeyDown()) {
            delete.setYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{object.getTitle()}));
        }
        contextMenu.add(delete);
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.uuid, object.id, GuiQuests.isShiftKeyDown() ? ChangeProgress.RESET_DEPS : ChangeProgress.RESET).sendToServer()).setYesNo((ITextComponent)new TranslationTextComponent("ftbquests.gui.reset_progress_q")));
        if (object instanceof QuestObject) {
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.uuid, object.id, GuiQuests.isShiftKeyDown() ? ChangeProgress.COMPLETE_DEPS : ChangeProgress.COMPLETE).sendToServer()).setYesNo((ITextComponent)new TranslationTextComponent("ftbquests.gui.complete_instantly_q")));
        }
        contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.copy_id"), (Icon)ThemeProperties.WIKI_ICON.get(), () -> GuiQuests.setClipboardString((String)QuestObjectBase.getCodeString(object))){

            public void addMouseOverText(TooltipList list) {
                list.add((ITextComponent)new StringTextComponent(QuestObjectBase.getCodeString(object)));
            }
        });
    }

    public static void displayError(ITextComponent error) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TranslationTextComponent("ftbquests.gui.error"), error));
    }

    private boolean moveSelectedQuests(double x, double y) {
        for (Movable movable : this.selectedObjects) {
            if (movable.getChapter() != this.selectedChapter) continue;
            movable.move(this.selectedChapter, movable.getX() + x, movable.getY() + y);
        }
        return true;
    }

    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (key.is(258)) {
            if (this.selectedChapter != null && this.file.chapters.size() > 1) {
                List<Chapter> visibleChapters;
                List<Chapter> list = visibleChapters = this.file.canEdit() ? this.file.chapters : this.file.getVisibleChapters(this.file.self, true);
                if (!visibleChapters.isEmpty()) {
                    this.selectChapter(visibleChapters.get(MathUtils.mod((int)(visibleChapters.indexOf(this.selectedChapter) + (GuiQuests.isShiftKeyDown() ? -1 : 1)), (int)visibleChapters.size())));
                }
            }
            return true;
        }
        if (key.is(32)) {
            this.questPanel.resetScroll();
            return true;
        }
        if (key.is(82) && key.modifiers.onlyControl()) {
            grid = !grid;
            return true;
        }
        if (key.keyCode >= 49 && key.keyCode <= 57) {
            int i = key.keyCode - 49;
            if (i < this.file.chapters.size()) {
                this.selectChapter((Chapter)this.file.chapters.get(i));
            }
            return true;
        }
        if (key.modifiers.control() && this.selectedChapter != null && this.file.canEdit()) {
            double step = key.modifiers.shift() ? 0.1 : 0.5;
            switch (key.keyCode) {
                case 65: {
                    this.selectedObjects.addAll(this.selectedChapter.quests);
                    return true;
                }
                case 68: {
                    this.selectedObjects.clear();
                    return true;
                }
                case 264: {
                    return this.moveSelectedQuests(0.0, step);
                }
                case 265: {
                    return this.moveSelectedQuests(0.0, -step);
                }
                case 263: {
                    return this.moveSelectedQuests(-step, 0.0);
                }
                case 262: {
                    return this.moveSelectedQuests(step, 0.0);
                }
            }
        }
        if (key.keyCode == 340 || key.keyCode == 344) {
            long now = System.currentTimeMillis();
            if (this.lastShiftPress == 0L) {
                this.lastShiftPress = now;
            } else {
                if (now - this.lastShiftPress <= 400L) {
                    ConfigQuestObject c = new ConfigQuestObject(QuestObjectType.CHAPTER.or(QuestObjectType.QUEST));
                    GuiSelectQuestObject gui = new GuiSelectQuestObject(c, accepted -> {
                        if (accepted) {
                            if (c.value instanceof Chapter) {
                                this.selectChapter((Chapter)c.value);
                            } else if (c.value instanceof Quest) {
                                this.zoom = 20;
                                this.selectChapter(((Quest)c.value).chapter);
                                this.viewQuestPanel.hidePanel = false;
                                this.viewQuest((Quest)c.value);
                            }
                        }
                        this.openGui();
                    });
                    gui.focus();
                    gui.setTitle((ITextComponent)new TranslationTextComponent("gui.search_box"));
                    gui.openGui();
                }
                this.lastShiftPress = 0L;
            }
        }
        return false;
    }

    public void tick() {
        List<Chapter> visible;
        if (this.selectedChapter != null && this.selectedChapter.invalid) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null && !(visible = this.file.getVisibleChapters(this.file.self, !this.file.canEdit())).isEmpty()) {
            this.selectChapter(visible.get(0));
        }
        super.tick();
    }

    public int getZoom() {
        return this.zoom;
    }

    public double getQuestButtonSize() {
        return (double)this.getZoom() * 3.0 / 2.0;
    }

    public double getQuestButtonSpacing() {
        return (double)this.getZoom() * (Double)ThemeProperties.QUEST_SPACING.get(this.selectedChapter) / 4.0;
    }

    public void addZoom(double up) {
        int z = this.zoom;
        this.zoom = (int)MathHelper.func_151237_a((double)((double)this.zoom + up * 4.0), (double)4.0, (double)28.0);
        if (this.zoom != z) {
            this.grabbed = 0;
            double sx = this.questPanel.centerQuestX;
            double sy = this.questPanel.centerQuestY;
            this.questPanel.resetScroll();
            this.questPanel.scrollTo(sx, sy);
        }
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        QuestTheme.currentObject = this.selectedChapter;
        super.drawBackground(matrixStack, theme, x, y, w, h);
        int pw = 20;
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        Color4I backgroundColor = (Color4I)ThemeProperties.WIDGET_BACKGROUND.get(this.selectedChapter);
        borderColor.draw(matrixStack, x + pw - 1, y + 1, 1, h - 2);
        backgroundColor.draw(matrixStack, x + 1, y + 1, pw - 2, h - 2);
        borderColor.draw(matrixStack, x + w - pw, y + 1, 1, h - 2);
        backgroundColor.draw(matrixStack, x + w - pw + 1, y + 1, pw - 2, h - 2);
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > (double)this.questPanel.width) {
                this.questPanel.setScrollX(Math.max(Math.min(this.questPanel.getScrollX() + (double)(this.prevMouseX - mx), this.scrollWidth - (double)this.questPanel.width), 0.0));
            } else {
                this.questPanel.setScrollX((this.scrollWidth - (double)this.questPanel.width) / 2.0);
            }
            if (this.scrollHeight > (double)this.questPanel.height) {
                this.questPanel.setScrollY(Math.max(Math.min(this.questPanel.getScrollY() + (double)(this.prevMouseY - my), this.scrollHeight - (double)this.questPanel.height), 0.0));
            } else {
                this.questPanel.setScrollY((this.scrollHeight - (double)this.questPanel.height) / 2.0);
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
    }

    public void drawForeground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        GuiHelper.drawHollowRect((MatrixStack)matrixStack, (int)x, (int)y, (int)w, (int)h, (Color4I)borderColor, (boolean)false);
        super.drawForeground(matrixStack, theme, x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground(MatrixStack matrixStack) {
        return false;
    }

    public void open(@Nullable QuestObject object, boolean focus) {
        Chapter c;
        Chapter chapter = c = this.chapterHoverPanel.chapter == null ? null : this.chapterHoverPanel.chapter.chapter;
        if (object instanceof Chapter) {
            this.selectChapter((Chapter)object);
        } else if (object instanceof Quest) {
            this.viewQuestPanel.hidePanel = false;
            Quest q = (Quest)object;
            this.selectChapter(q.chapter);
            this.viewQuest(q);
            if (focus) {
                this.questPanel.scrollTo(q.x + 0.5, q.y + 0.5);
            }
        } else if (object instanceof Task) {
            this.viewQuestPanel.hidePanel = false;
            this.selectChapter(((Task)object).quest.chapter);
            this.viewQuest(((Task)object).quest);
        }
        this.openGui();
        if (c != null) {
            for (Widget widget : this.chapterPanel.widgets) {
                if (!(widget instanceof ButtonChapter) || c != ((ButtonChapter)widget).chapter) continue;
                this.chapterHoverPanel.chapter = (ButtonChapter)widget;
                this.chapterHoverPanel.refreshWidgets();
                this.chapterHoverPanel.updateMouseOver(this.getMouseX(), this.getMouseY());
                break;
            }
        }
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() && path.startsWith("#")) {
            this.open(this.file.get(this.file.getID(path)), true);
            return true;
        }
        return super.handleClick(scheme, path);
    }

    public void addMouseOverText(TooltipList list) {
        super.addMouseOverText(list);
        list.zOffset = 950;
    }
}

