/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.misc.CompactGridLayout;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetLayout;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;

public class GuiValidItems
extends GuiBase {
    public final ItemTask task;
    public final List<ItemStack> validItems;
    public String title = "";
    public final boolean canClick;
    public final Panel itemPanel;
    public final Button backButton;
    public final Button submitButton;

    public GuiValidItems(ItemTask t, List<ItemStack> v, boolean c) {
        this.task = t;
        this.validItems = v;
        this.canClick = c;
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack validItem : GuiValidItems.this.validItems) {
                    this.add((Widget)new ButtonValidItem(this, validItem));
                }
            }

            public void alignWidgets() {
                this.align((WidgetLayout)new CompactGridLayout(36));
                this.setHeight(Math.min(160, this.getContentHeight()));
                this.parent.setHeight(this.height + 53);
                int off = (this.width - this.getContentWidth()) / 2;
                for (Widget widget : this.widgets) {
                    widget.setX(widget.posX + off);
                }
                GuiValidItems.this.itemPanel.setX((this.parent.width - this.width) / 2);
                GuiValidItems.this.backButton.setPosAndSize(GuiValidItems.this.itemPanel.posX - 1, this.height + 28, 70, 20);
                GuiValidItems.this.submitButton.setPosAndSize(GuiValidItems.this.itemPanel.posX + 75, this.height + 28, 70, 20);
            }

            public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                theme.drawButton(matrixStack, x - 1, y - 1, w + 2, h + 2, WidgetType.NORMAL);
            }
        };
        this.itemPanel.setPosAndSize(0, 22, 144, 0);
        this.backButton = new SimpleTextButton((Panel)this, (ITextComponent)new TranslationTextComponent("gui.back"), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                GuiValidItems.this.onBack();
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.submitButton = new SimpleTextButton((Panel)this, (ITextComponent)new StringTextComponent("Submit"), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                new MessageSubmitTask(GuiValidItems.this.task.id).sendToServer();
                GuiValidItems.this.onBack();
            }

            public void addMouseOverText(TooltipList list) {
                if (GuiValidItems.this.canClick && !GuiValidItems.this.task.consumesResources()) {
                    list.translate("ftbquests.task.auto_detected", new Object[0]);
                }
            }

            public WidgetType getWidgetType() {
                return GuiValidItems.this.canClick && GuiValidItems.this.task.consumesResources() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
    }

    public void addWidgets() {
        this.title = new TranslationTextComponent("ftbquests.task.ftbquests.item.valid_for", new Object[]{this.task.getTitle()}).getString();
        this.setWidth(Math.max(156, this.getTheme().getStringWidth(this.title) + 12));
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.backButton);
        this.add((Widget)this.submitButton);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.title, (float)x + (float)w / 2.0f, (float)(y + 6), Color4I.WHITE, 4);
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.onBack();
        }
        return false;
    }

    public class ButtonValidItem
    extends Button {
        public final ItemStack stack;

        public ButtonValidItem(Panel panel, ItemStack is) {
            super(panel, StringTextComponent.field_240750_d_, ItemIcon.getItemIcon((ItemStack)is));
            this.stack = is;
        }

        public void onClicked(MouseButton button) {
            if (ModList.get().isLoaded("jei")) {
                this.showJEIRecipe();
            }
        }

        private void showJEIRecipe() {
            FTBQuestsJEIHelper.showRecipes(this.stack);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient((Object)this.stack).tooltip();
        }

        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 10.0);
            GuiHelper.drawItem((MatrixStack)matrixStack, (ItemStack)this.stack, (double)(x + 2), (double)(y + 2), (float)2.0f, (float)2.0f, (boolean)true, null);
            matrixStack.func_227865_b_();
        }
    }
}

