/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.jei;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class LootCrateWrapper
implements ITooltipCallback<ItemStack> {
    public final LootCrate crate;
    public final IFormattableTextComponent name;
    public final ItemStack itemStack;
    public final List<ItemStack> items;
    public final List<WeightedReward> rewards;
    public final List<List<ItemStack>> itemLists;

    public LootCrateWrapper(LootCrate c) {
        this.crate = c;
        this.name = this.crate.table.getTitle();
        this.itemStack = this.crate.createStack();
        this.items = new ArrayList<ItemStack>(c.table.rewards.size());
        this.rewards = new ArrayList<WeightedReward>(c.table.rewards);
        this.rewards.sort(null);
        for (WeightedReward reward : this.rewards) {
            ItemStack stack;
            Object object = reward.reward.getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.field_190927_a;
            if (!stack.func_190926_b()) {
                this.items.add(stack.func_77946_l());
                continue;
            }
            if (reward.reward.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)reward.reward.getIcon()).getStack().func_77946_l();
                stack.func_200302_a((ITextComponent)reward.reward.getTitle());
                this.items.add(stack);
                continue;
            }
            stack = new ItemStack((IItemProvider)Items.field_151159_an);
            stack.func_200302_a((ITextComponent)reward.reward.getTitle());
            stack.func_77983_a("icon", (INBT)StringNBT.func_229705_a_((String)reward.reward.getIcon().toString()));
            this.items.add(stack);
        }
        if (this.items.size() <= 50) {
            this.itemLists = new ArrayList<List<ItemStack>>(this.items.size());
            for (ItemStack stack : this.items) {
                this.itemLists.add(Collections.singletonList(stack));
            }
        } else {
            int i;
            this.itemLists = new ArrayList<List<ItemStack>>(50);
            for (i = 0; i < 50; ++i) {
                this.itemLists.add(new ArrayList());
            }
            for (i = 0; i < this.items.size(); ++i) {
                this.itemLists.get(i % 50).add(this.items.get(i));
            }
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.itemStack);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.itemLists);
    }

    private String chance(String type, int w, int t) {
        String s = I18n.func_135052_a((String)("ftbquests.loot.entitytype." + type), (Object[])new Object[0]) + ": " + WeightedReward.chanceString(w, t);
        if (w > 0) {
            s = s + " (1 in " + StringUtils.formatDouble00((double)(1.0 / ((double)w / (double)t))) + ")";
        }
        return s;
    }

    public void drawInfo(MatrixStack matrixStack, Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GuiHelper.drawItem((MatrixStack)matrixStack, (ItemStack)this.itemStack, (double)0.0, (double)0.0, (float)2.0f, (float)2.0f, (boolean)true, null);
        mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)this.crate.table.getTitle().func_240699_a_(TextFormatting.UNDERLINE), 36.0f, 0.0f, -14540254);
        int total = ClientQuestFile.INSTANCE.lootCrateNoDrop.passive;
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            if (table.lootCrate == null) continue;
            total += table.lootCrate.drops.passive;
        }
        mc.field_71466_p.func_238421_b_(matrixStack, this.chance("passive", this.crate.drops.passive, total), 36.0f, 10.0f, -14540254);
        total = ClientQuestFile.INSTANCE.lootCrateNoDrop.monster;
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            if (table.lootCrate == null) continue;
            total += table.lootCrate.drops.monster;
        }
        mc.field_71466_p.func_238421_b_(matrixStack, this.chance("monster", this.crate.drops.monster, total), 36.0f, 19.0f, -14540254);
        total = ClientQuestFile.INSTANCE.lootCrateNoDrop.boss;
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            if (table.lootCrate == null) continue;
            total += table.lootCrate.drops.boss;
        }
        mc.field_71466_p.func_238421_b_(matrixStack, this.chance("boss", this.crate.drops.boss, total), 36.0f, 28.0f, -14540254);
    }

    public void onTooltip(int slot, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
        if (slot > 0 && slot - 1 < this.items.size()) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i) != ingredient) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent("jei.ftbquests.lootcrates.chance", new Object[]{TextFormatting.GOLD + WeightedReward.chanceString(this.rewards.get((int)i).weight, this.crate.table.getTotalWeight(true))}).func_240699_a_(TextFormatting.GRAY));
                return;
            }
        }
    }
}

