/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.jei;

import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class QuestWrapper {
    public final Quest quest;
    public final IFormattableTextComponent name;
    public final List<List<ItemStack>> input;
    public final List<List<ItemStack>> output;

    public QuestWrapper(Quest q, List<Reward> rewards) {
        ArrayList<ItemStack> list;
        ItemStack stack;
        Object object;
        this.quest = q;
        this.name = this.quest.getTitle();
        this.input = new ArrayList<List<ItemStack>>(5);
        this.output = new ArrayList<List<ItemStack>>(5);
        if (this.quest.tasks.size() == 1) {
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
        }
        for (Task task : this.quest.tasks) {
            if (task instanceof ItemTask) {
                ItemStack filter = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("itemfilters", "or")));
                this.input.add(Collections.singletonList(filter));
                continue;
            }
            object = task.getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.field_190927_a;
            if (!stack.func_190926_b()) {
                list = new ArrayList<ItemStack>();
                ItemFiltersAPI.getValidItems((ItemStack)stack, list);
                this.input.add(list);
                continue;
            }
            if (task.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)task.getIcon()).getStack().func_77946_l();
                stack.func_200302_a((ITextComponent)task.getTitle());
                this.input.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack((IItemProvider)Items.field_151159_an);
            stack.func_200302_a((ITextComponent)task.getTitle());
            stack.func_77983_a("icon", (INBT)StringNBT.func_229705_a_((String)task.getIcon().toString()));
            this.input.add(Collections.singletonList(stack));
        }
        if (rewards.size() == 1) {
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
        }
        for (Reward reward : rewards) {
            object = reward.getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.field_190927_a;
            if (!stack.func_190926_b()) {
                this.output.add(Collections.singletonList(stack.func_77946_l()));
                continue;
            }
            if (reward instanceof RandomReward) {
                list = new ArrayList();
                RewardTable table = ((RandomReward)reward).getTable();
                if (table.hideTooltip) {
                    ItemStack unknown = new ItemStack((IItemProvider)Items.field_221803_eL);
                    unknown.func_200302_a((ITextComponent)new StringTextComponent("Unknown Reward"));
                    list.add(unknown);
                } else {
                    for (WeightedReward reward1 : table.rewards) {
                        Object object1 = reward1.reward.getIngredient();
                        if (!(object1 instanceof ItemStack)) continue;
                        list.add((ItemStack)object1);
                    }
                }
                this.output.add(list);
                continue;
            }
            if (reward.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)reward.getIcon()).getStack().func_77946_l();
                stack.func_200302_a((ITextComponent)reward.getTitle());
                this.output.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack((IItemProvider)Items.field_151159_an);
            stack.func_200302_a((ITextComponent)reward.getTitle());
            stack.func_77983_a("icon", (INBT)StringNBT.func_229705_a_((String)reward.getIcon().toString()));
            this.output.add(Collections.singletonList(stack));
        }
    }
}

