/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftbquests.net.MessageBase;
import com.feed_the_beast.ftbquests.net.MessageCreateObjectResponse;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.util.NetUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCreateObject
extends MessageBase {
    private final int parent;
    private final QuestObjectType type;
    private final CompoundNBT nbt;
    private final CompoundNBT extra;

    MessageCreateObject(PacketBuffer buffer) {
        this.parent = buffer.func_150792_a();
        this.type = (QuestObjectType)QuestObjectType.NAME_MAP.read(buffer);
        this.nbt = buffer.func_150793_b();
        this.extra = buffer.func_150793_b();
    }

    public MessageCreateObject(QuestObjectBase o, @Nullable CompoundNBT e) {
        this.parent = o.getParentID();
        this.type = o.getObjectType();
        this.nbt = new CompoundNBT();
        o.writeData(this.nbt);
        this.extra = e;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.parent);
        QuestObjectType.NAME_MAP.write(buffer, (Object)this.type);
        buffer.func_150786_a(this.nbt);
        buffer.func_150786_a(this.extra);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (NetUtils.canEdit(context)) {
            QuestObjectBase object = ServerQuestFile.INSTANCE.create(this.type, this.parent, this.extra == null ? new CompoundNBT() : this.extra);
            object.readData(this.nbt);
            object.id = ServerQuestFile.INSTANCE.newID();
            object.onCreated();
            object.getQuestFile().refreshIDMap();
            object.getQuestFile().clearCachedData();
            object.getQuestFile().save();
            if (object instanceof Chapter) {
                object.getQuestFile().updateChapterIndices();
            }
            new MessageCreateObjectResponse(object, this.extra).sendToAll();
        }
    }
}

