/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftbquests.net.MessageBase;
import com.feed_the_beast.ftbquests.net.MessageCreateObjectResponse;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.util.NetUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MessageCreateTaskAt
extends MessageBase {
    private final int chapter;
    private final double x;
    private final double y;
    private final TaskType type;
    private final CompoundNBT nbt;

    MessageCreateTaskAt(PacketBuffer buffer) {
        this.chapter = buffer.func_150792_a();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.type = (TaskType)TaskType.getRegistry().getValue(buffer.func_150792_a());
        this.nbt = buffer.func_150793_b();
    }

    public MessageCreateTaskAt(Chapter c, double _x, double _y, Task task) {
        this.chapter = c.id;
        this.x = _x;
        this.y = _y;
        this.type = task.getType();
        this.nbt = new CompoundNBT();
        task.writeData(this.nbt);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.chapter);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.func_150787_b(TaskType.getRegistry().getID((IForgeRegistryEntry)this.type));
        buffer.func_150786_a(this.nbt);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Chapter c;
        if (NetUtils.canEdit(context) && (c = ServerQuestFile.INSTANCE.getChapter(this.chapter)) != null) {
            Quest quest = new Quest(c);
            quest.x = this.x;
            quest.y = this.y;
            quest.id = ServerQuestFile.INSTANCE.newID();
            quest.onCreated();
            new MessageCreateObjectResponse(quest, null).sendToAll();
            Task task = this.type.provider.create(quest);
            task.id = ServerQuestFile.INSTANCE.newID();
            task.readData(this.nbt);
            task.onCreated();
            CompoundNBT extra = new CompoundNBT();
            extra.func_74778_a("type", this.type.getTypeForNBT());
            new MessageCreateObjectResponse(task, extra).sendToAll();
            ServerQuestFile.INSTANCE.refreshIDMap();
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
        }
    }
}

