/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.ChapterImage;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.util.NetUtils;
import com.feed_the_beast.ftbquests.util.OrderedCompoundNBT;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconAnimation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class Chapter
extends QuestObject {
    public final QuestFile file;
    public String filename;
    public final List<Quest> quests;
    public final List<String> subtitle;
    public boolean alwaysInvisible;
    public Chapter group;
    public String defaultQuestShape;
    public final List<ChapterImage> images;
    public int orderIndex;

    public Chapter(QuestFile f) {
        this.file = f;
        this.filename = "";
        this.quests = new ArrayList<Quest>();
        this.subtitle = new ArrayList<String>(0);
        this.alwaysInvisible = false;
        this.group = null;
        this.defaultQuestShape = "";
        this.images = new ArrayList<ChapterImage>();
        this.orderIndex = 0;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        ListNBT list;
        nbt.func_74778_a("filename", this.filename);
        nbt.func_74768_a("order_index", this.orderIndex);
        super.writeData(nbt);
        if (!this.subtitle.isEmpty()) {
            list = new ListNBT();
            for (String v : this.subtitle) {
                list.add((Object)StringNBT.func_229705_a_((String)v));
            }
            nbt.func_218657_a("subtitle", (INBT)list);
        }
        if (this.alwaysInvisible) {
            nbt.func_74757_a("always_invisible", true);
        }
        if (this.group != null && !this.group.invalid) {
            nbt.func_74768_a("group", this.group.id);
        }
        nbt.func_74778_a("default_quest_shape", this.defaultQuestShape);
        if (!this.images.isEmpty()) {
            list = new ListNBT();
            for (ChapterImage image : this.images) {
                OrderedCompoundNBT nbt1 = new OrderedCompoundNBT();
                image.writeData(nbt1);
                list.add((Object)nbt1);
            }
            nbt.func_218657_a("images", (INBT)list);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        this.filename = nbt.func_74779_i("filename");
        this.orderIndex = nbt.func_74762_e("order_index");
        super.readData(nbt);
        this.subtitle.clear();
        ListNBT subtitleNBT = nbt.func_150295_c("subtitle", 8);
        for (int i = 0; i < subtitleNBT.size(); ++i) {
            this.subtitle.add(subtitleNBT.func_150307_f(i));
        }
        this.alwaysInvisible = nbt.func_74767_n("always_invisible");
        this.group = this.file.getChapter(nbt.func_74762_e("group"));
        this.defaultQuestShape = nbt.func_74779_i("default_quest_shape");
        if (this.defaultQuestShape.equals("default")) {
            this.defaultQuestShape = "";
        }
        ListNBT imgs = nbt.func_150295_c("images", 10);
        this.images.clear();
        for (int i = 0; i < imgs.size(); ++i) {
            ChapterImage image = new ChapterImage(this);
            image.readData(imgs.func_150305_b(i));
            this.images.add(image);
        }
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.filename, Short.MAX_VALUE);
        NetUtils.writeStrings(buffer, this.subtitle);
        buffer.writeBoolean(this.alwaysInvisible);
        buffer.writeInt(this.group == null || this.group.invalid ? 0 : this.group.id);
        buffer.func_211400_a(this.defaultQuestShape, Short.MAX_VALUE);
        NetUtils.write(buffer, this.images, (d, img) -> img.writeNetData((PacketBuffer)d));
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.filename = buffer.func_150789_c(Short.MAX_VALUE);
        NetUtils.readStrings(buffer, this.subtitle);
        this.alwaysInvisible = buffer.readBoolean();
        this.group = this.file.getChapter(buffer.readInt());
        this.defaultQuestShape = buffer.func_150789_c(Short.MAX_VALUE);
        NetUtils.read(buffer, this.images, d -> {
            ChapterImage image = new ChapterImage(this);
            image.readNetData((PacketBuffer)d);
            return image;
        });
    }

    public int getIndex() {
        return this.file.chapters.indexOf(this);
    }

    @Override
    public int getRelativeProgressFromChildren(PlayerData data) {
        if (this.alwaysInvisible) {
            return 100;
        }
        List<Chapter> children = this.getChildren();
        if (this.quests.isEmpty() && children.isEmpty()) {
            return 100;
        }
        int progress = 0;
        int count = 0;
        for (Quest quest : this.quests) {
            if (quest.isProgressionIgnored()) continue;
            progress += data.getRelativeProgress(quest);
            ++count;
        }
        for (Chapter chapter : this.getChildren()) {
            progress += chapter.getRelativeProgressFromChildren(data);
            ++count;
        }
        if (count <= 0) {
            return 100;
        }
        return Chapter.getRelativeProgressFromChildren(progress, count);
    }

    @Override
    public void onCompleted(PlayerData data, List<ServerPlayerEntity> onlineMembers, List<ServerPlayerEntity> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        MinecraftForge.EVENT_BUS.post((Event)new ObjectCompletedEvent.ChapterEvent(data, this, onlineMembers, notifiedPlayers));
        if (!this.disableToast) {
            for (ServerPlayerEntity player : notifiedPlayers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
        for (Chapter chapter : this.file.chapters) {
            for (Quest quest : chapter.quests) {
                if (!quest.dependencies.contains(this)) continue;
                data.checkAutoCompletion(quest);
            }
        }
        if (data.isComplete(this.file)) {
            this.file.onCompleted(data, onlineMembers, notifiedPlayers);
        }
    }

    @Override
    public void changeProgress(PlayerData data, ChangeProgress type) {
        for (Quest quest : this.quests) {
            quest.changeProgress(data, type);
        }
        for (Chapter chapter : this.getChildren()) {
            chapter.changeProgress(data, type);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Quest quest : this.quests) {
            list.add(quest.getIcon());
        }
        for (Chapter child : this.getChildren()) {
            list.add(child.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.unnamed");
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.file.chapters.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Quest quest : this.quests) {
            quest.deleteChildren();
            quest.invalid = true;
        }
        this.quests.clear();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            String s = this.title.replace(' ', '_').replaceAll("\\W", "").toLowerCase().trim();
            if (s.isEmpty()) {
                s = this.toString();
            }
            this.filename = s;
            Set existingNames = this.file.chapters.stream().map(ch -> ch.filename).collect(Collectors.toSet());
            int i = 2;
            while (existingNames.contains(this.filename)) {
                this.filename = s + "_" + i;
                ++i;
            }
        }
        this.file.chapters.add(this);
        if (!this.quests.isEmpty()) {
            ArrayList<Quest> l = new ArrayList<Quest>(this.quests);
            this.quests.clear();
            for (Quest quest : l) {
                quest.onCreated();
            }
        }
    }

    @Override
    public String getPath() {
        return "chapters/" + this.filename + ".snbt";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("subtitle", this.subtitle, (ConfigValue)new ConfigString(null), (Object)"");
        config.addBool("always_invisible", this.alwaysInvisible, v -> {
            this.alwaysInvisible = v;
        }, false);
        config.addEnum("default_quest_shape", (Object)(this.defaultQuestShape.isEmpty() ? "default" : this.defaultQuestShape), v -> {
            this.defaultQuestShape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
    }

    @Override
    public boolean isVisible(PlayerData data) {
        if (this.alwaysInvisible) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (!quest.isVisible(data)) continue;
            return true;
        }
        for (Chapter child : this.getChildren()) {
            if (!child.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Quest quest : this.quests) {
            quest.clearCachedData();
        }
        for (Chapter chapter : this.getChildren()) {
            chapter.clearCachedData();
        }
    }

    public boolean hasChildren() {
        if (this.group != null) {
            return false;
        }
        for (Chapter chapter : this.file.chapters) {
            if (chapter.group != this) continue;
            return true;
        }
        return false;
    }

    public List<Chapter> getChildren() {
        List<Chapter> list = Collections.emptyList();
        if (this.group != null) {
            return list;
        }
        for (Chapter chapter : this.file.chapters) {
            if (chapter.group != this) continue;
            if (list.isEmpty()) {
                list = new ArrayList<Chapter>(3);
            }
            list.add(chapter);
        }
        return list;
    }

    @Override
    public boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (quest.verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.invalid;
    }

    public String getDefaultQuestShape() {
        return this.defaultQuestShape.isEmpty() ? this.file.getDefaultQuestShape() : this.defaultQuestShape;
    }
}

